/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class MuldimUseStaffRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_muldimusestaff");

    public static MuldimUseStaffRepository getInstance() {
        return MuldimUseStaffInstance.INSTANCE;
    }

    public DynamicObject[] queryMuldimUseStaffByMuldimDetailIds(List<Long> muldimDetailEntryIds) {
        QFilter useOrgDetailFilter = new QFilter("muldimendetail", "in", muldimDetailEntryIds);
        QFilter statusFilter = new QFilter("status", "in", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgDetailFilter, statusFilter});
    }

    public DynamicObject[] queryMuldimUseStaffByUidList(List<Long> uidLis) {
        QFilter qFilter = new QFilter("orgusestaffdetail.id", "in", uidLis);
        return this.serviceHelper.query("id, status", new QFilter[]{qFilter});
    }

    public void save(DynamicObject[] muldimUseStaffs) {
        this.serviceHelper.save(muldimUseStaffs);
    }

    public void delete(List<Long> pkList) {
        this.serviceHelper.delete(pkList.toArray());
    }

    public DynamicObject[] queryByPersonStaffInfoIdsAndOrgUseStaffIds(List<Long> personStaffInfoIds, List<Long> orgUseStaffIds) {
        QFilter personStaffInfoIdsFilter = new QFilter("personstaffinfo", "in", personStaffInfoIds);
        QFilter orgUseStaffIdsFilter = new QFilter("orgusestaffdetail", "in", orgUseStaffIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"0");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personStaffInfoIdsFilter, orgUseStaffIdsFilter, statusFilter});
    }

    public DynamicObject[] queryByOrgUseStaffDetailIds(List<Long> orgUseStaffIds) {
        QFilter orgUseStaffIdsFilter = new QFilter("orgusestaffdetail", "in", orgUseStaffIds);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgUseStaffIdsFilter});
    }

    public DynamicObject[] queryByBoAndOrgUseStaffIds(List<Long> muldimBos, List<Long> muldimToOrgUseStaffIds) {
        QFilter boFilter = new QFilter("bo", "in", muldimBos);
        QFilter orgUseStaffIdsFilter = new QFilter("orgusestaffdetail", "in", muldimToOrgUseStaffIds);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, orgUseStaffIdsFilter});
    }

    public DynamicObject[] queryOccupyDimenInfoByBOId(String selectField, Date queryDate, Set<Long> boIdSet) {
        QFilter filter = new QFilter("bo", "in", boIdSet);
        filter.and("status", "in", (Object)new String[]{"1", "2"});
        if (queryDate != null) {
            filter.and("effdt", "<=", (Object)queryDate);
            filter.and("leffdt", ">=", (Object)queryDate);
        }
        filter.and("stafftype", "in", (Object)new String[]{"1", "2", "4"});
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryExistMulDimUseStaffList(List<Long> uIdList) {
        DynamicObject[] dys = this.serviceHelper.query("personstaffinfo, orgusestaffdetail, bo", new QFilter("orgusestaffdetail", "in", uIdList).and(OrgStaffConstants.EFF_INV_STATUS_QFILTER).toArray());
        return dys;
    }

    private static class MuldimUseStaffInstance {
        private static MuldimUseStaffRepository INSTANCE = new MuldimUseStaffRepository();

        private MuldimUseStaffInstance() {
        }
    }
}

