/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PersonStaffInfoRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_personstaffinfo");

    public void save(DynamicObject[] dys) {
        this.serviceHelper.save(dys);
    }

    public static PersonStaffInfoRepository getInstance() {
        return PersonStaffInfoInstance.INSTANCE;
    }

    public DynamicObject[] queryBaseInfoByPersonIds(List<Long> personIds) {
        QFilter personFilter = new QFilter("person", "in", personIds);
        return this.serviceHelper.query("id,candidate,person,status,effdt,leffdt", new QFilter[]{personFilter});
    }

    public DynamicObject[] queryBaseInfoByPersonIdsOrCandidateId(List<Long> personIdList, List<Long> candidateIdList) {
        QFilter filter = new QFilter("person", "in", personIdList);
        filter.or(new QFilter("candidate", "in", candidateIdList));
        return this.serviceHelper.query("id,candidate,person,status,effdt,leffdt", new QFilter[]{filter});
    }

    public DynamicObject[] queryById(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.serviceHelper.query("id, person, status", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPersonStaffInfoCandidateIds(List<Long> candidateIds) {
        QFilter personFilter = new QFilter("candidate", "in", candidateIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
    }

    public List<Long> queryExistDepempIdList(List<Long> depempIdList) {
        QFilter qFilter = new QFilter("orgperson", "in", depempIdList);
        DynamicObject[] dys = this.serviceHelper.query("orgperson", new QFilter[]{qFilter});
        return Stream.of(dys).map(it -> it.getLong("orgperson_id")).collect(Collectors.toList());
    }

    public Map<Long, Long> queryPersonIdByIdList(List<Long> idList) {
        QFilter personFilter = new QFilter("id", "in", idList);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        DynamicObject[] personStaffInfoDyns = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
        return Arrays.stream(personStaffInfoDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("person.id")));
    }

    private static class PersonStaffInfoInstance {
        private static PersonStaffInfoRepository INSTANCE = new PersonStaffInfoRepository();

        private PersonStaffInfoInstance() {
        }
    }
}

