/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.staff.StaffCaseConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StaffCaseRepository
implements StaffCaseConstants {
    private HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_staffcase");

    public static StaffCaseRepository getInstance() {
        return StaffCaseInstance.staffCaseRepository;
    }

    public boolean isExistsById(Long id) {
        QFilter idFilter = new QFilter("id", "in", (Object)id);
        return this.helper.isExists(idFilter);
    }

    public DynamicObject[] queryEnableAndAuditDyns(List<Long> personIdList) {
        QFilter personnelIdListFilter = new QFilter("person", "in", personIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.helper.query("id, personnel, person, bsed, bsled", new QFilter[]{enableFilter, personnelIdListFilter}, "bsed desc");
    }

    public DynamicObject[] queryDynByPersonnelIdList(List<Long> personnelIdList) {
        QFilter personnelIdListFilter = new QFilter("personnel.id", "in", personnelIdList);
        return this.helper.query("id, personnel, person", new QFilter[]{personnelIdListFilter});
    }

    public DynamicObject[] queryAllEnableAndAuditDyns() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return this.helper.query("id, personnel, person, bsed, bsled", new QFilter[]{enableFilter, statusFilter}, "bsed desc");
    }

    public DynamicObject[] queryAllDyns() {
        QFilter allEqualsFilter = new QFilter("1", "=", (Object)1);
        return this.helper.loadDynamicObjectArray(new QFilter[]{allEqualsFilter});
    }

    public DynamicObject[] queryAllEnableAndAuditDynsByDate(Date queryDate) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)queryDate);
        dateFilter.and("bsled", ">=", (Object)queryDate);
        return this.helper.query("id, personnel, person, bsed, bsled", new QFilter[]{enableFilter, statusFilter}, "bsed desc");
    }

    public void updateDyns(DynamicObject[] staffCaseDyns) {
        this.helper.update(staffCaseDyns);
    }

    public DynamicObject getNewEmptyDyn() {
        return this.helper.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryDyns(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.helper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    private static class StaffCaseInstance {
        private static StaffCaseRepository staffCaseRepository = new StaffCaseRepository();

        private StaffCaseInstance() {
        }
    }
}

