/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StaffReportRepository {
    private HRBaseServiceHelper orgServiceHelper = new HRBaseServiceHelper("haos_orgstaffreport");
    private HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("haos_dimstaffreport");

    public static StaffReportRepository getInstance() {
        return Instance.INSTANCE;
    }

    public void deleteOrgDataByStaffId(List<Long> staffId) {
        QFilter staffIdFilter = new QFilter("staffid", "in", staffId);
        this.orgServiceHelper.deleteByFilter(new QFilter[]{staffIdFilter});
    }

    public void deleteDimDataByStaffId(List<Long> staffId) {
        QFilter staffIdFilter = new QFilter("staffid", "in", staffId);
        this.dimServiceHelper.deleteByFilter(new QFilter[]{staffIdFilter});
    }

    public void saveOrgData(DynamicObject[] orgdata) {
        this.orgServiceHelper.save(orgdata);
    }

    public void saveDimData(DynamicObject[] dimData) {
        this.dimServiceHelper.save(dimData);
    }

    public DynamicObject newEmptyOrgstaffReportDyn() {
        return this.orgServiceHelper.generateEmptyDynamicObject();
    }

    public DynamicObject newEmptyDimstaffReportDyn() {
        return this.dimServiceHelper.generateEmptyDynamicObject();
    }

    private static class Instance {
        private static StaffReportRepository INSTANCE = new StaffReportRepository();

        private Instance() {
        }
    }
}

