/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.teamcoop;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.util.FilterCommonUtils;
import kd.hr.haos.common.constants.TeamCoopRelConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class TeamCoopRelRepository {
    private HRBaseServiceHelper orgTeamCoopHelper = new HRBaseServiceHelper("haos_orgteamcooprel");

    public static TeamCoopRelRepository getInstance() {
        return TeamCoopRelInstance.INSTANCE;
    }

    public DynamicObject[] getProTeamCoopRelInfoBySourceOrgId(List<Long> sourceOrgIdLis, String selectFields, Boolean isCurVersion, List<String> dataStatusList, String initStatus) {
        if (ObjectUtils.isEmpty(sourceOrgIdLis)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("org", "in", sourceOrgIdLis);
        FilterCommonUtils.andCommonFilterByParam(isCurVersion, dataStatusList, initStatus, filter);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id,bo,org,coopreltype,cooporgteam,bsed,bsled,datastatus,iscurrentversion,sourcevid";
        }
        QFilter[] filters = new QFilter[]{filter};
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, filters);
    }

    public DynamicObject[] loadAdCoopRel(Set<Long> orgIdSet) {
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("coopreltype", "=", (Object)1010L);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        return this.orgTeamCoopHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] loadAdCoopRelAllDataByOtBo(Set<Long> orgIdSet) {
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("coopreltype", "=", (Object)1010L);
        return this.orgTeamCoopHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] queryOriginalArrayAllOneTypeRelByBsed(String selectFields, Set<Long> relTypeIdSet, Date bsed) {
        QFilter relTypeFilter = new QFilter("coopreltype.id", "in", relTypeIdSet);
        QFilter enabledFilter = new QFilter("enable", "=", (Object)"1");
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, new QFilter[]{relTypeFilter, enabledFilter, QFilterHelper.createValidHisVersionFilter(bsed)});
    }

    public DynamicObject[] queryOriginalArray4EnabledCurrentVersionByOt(String selectFields, Set<Long> otBoSet) {
        QFilter orgFilter = new QFilter("org", "in", otBoSet);
        QFilter enabledFilter = new QFilter("enable", "=", (Object)"1");
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, new QFilter[]{orgFilter, enabledFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalArray4EnabledCurrentVersionWithoutAdByOt(String selectFields, Set<Long> otBoSet) {
        QFilter orgFilter = new QFilter("org", "in", otBoSet);
        QFilter enabledFilter = new QFilter("enable", "=", (Object)"1");
        QFilter notEqualsAdRelFilter = new QFilter("coopreltype", "!=", (Object)TeamCoopRelConstants.AFFILIATION_ID);
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, new QFilter[]{orgFilter, enabledFilter, notEqualsAdRelFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalArray4CurrentVersionOnlyAdByOt(String selectFields, Set<Long> otBoSet) {
        QFilter orgFilter = new QFilter("org", "in", otBoSet);
        QFilter notEqualsAdRelFilter = new QFilter("coopreltype", "=", (Object)TeamCoopRelConstants.AFFILIATION_ID);
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, new QFilter[]{orgFilter, notEqualsAdRelFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalArrayById(String selectFields, Set<Long> idSet) {
        QFilter idFilter = new QFilter("id", "in", idSet);
        return this.orgTeamCoopHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject getAffiliationCoopRelBySourceOrg(Long sourceOrgId, Date date) {
        QFilter qFilter = new QFilter("org", "=", (Object)sourceOrgId);
        qFilter.and("coopreltype", "=", (Object)1010L);
        qFilter.and("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        return this.orgTeamCoopHelper.loadDynamicObject(qFilter);
    }

    public DynamicObject queryAffiliationCoopRel(Long sourceOrgId, Date endDate) {
        QFilter qFilter = new QFilter("org", "=", (Object)sourceOrgId);
        qFilter.and("coopreltype", "=", (Object)1010L);
        qFilter.and("bsed", ">", (Object)endDate);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        return this.orgTeamCoopHelper.queryOriginalOne("bsed,bsled,cooporgteam", qFilter.toArray(), "bsed asc");
    }

    public DynamicObject[] queryAffiliationAllDataByOt(String selectFields, Set<Long> sourceOrgSet) {
        QFilter qFilter = new QFilter("org", "in", sourceOrgSet);
        return this.orgTeamCoopHelper.query(selectFields, qFilter.toArray());
    }

    private static class TeamCoopRelInstance {
        private static TeamCoopRelRepository INSTANCE = new TeamCoopRelRepository();

        private TeamCoopRelInstance() {
        }
    }
}

