/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.adminorg;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.haos.business.domain.service.adminorg.IAdminOrgService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgChgStructService;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgStructService;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgServiceImpl
implements IAdminOrgService {
    private static final Log logger = LogFactory.getLog(AdminOrgServiceImpl.class);
    private static AdminOrgServiceImpl service = new AdminOrgServiceImpl();

    private AdminOrgServiceImpl() {
    }

    public static AdminOrgServiceImpl getInstance() {
        return service;
    }

    @Override
    @Deprecated
    public HisResponse<BatchVersionChangeRespData> batchAddNew(DynamicObject[] adminOrgObjs) {
        return null;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchChange(DynamicObject[] adminOrgObjs) {
        List<DynamicObject> newOrgList;
        if (Objects.isNull(adminOrgObjs) || adminOrgObjs.length == 0) {
            throw new KDBizException("No data, can't do change save, please check!");
        }
        List<Long> orgIdList = Stream.of(adminOrgObjs).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id");
        DynamicObject[] changeAdminOrgs = new DynamicObject[adminOrgObjs.length];
        int index = 0;
        Map<Long, DynamicObject> allParentOrgMap = AdminOrgHisServiceHelper.getAllParentOrgs(adminOrgObjs);
        for (DynamicObject dynamicObject : adminOrgObjs) {
            DynamicObject orgObj = this.buildAdminBasicInfo(dynamicObject, Boolean.TRUE, oldOrgInfoDynMap.get(dynamicObject.getLong("id")), allParentOrgMap);
            changeAdminOrgs[index++] = orgObj;
        }
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(16);
        HisVersionParamBo adminOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(changeAdminOrgs, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
        listHisVersionParamBo.add(adminOrgHisVersionParam);
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        List<DynamicObject> newStructList = AdminOrgChgStructService.getInstance().getChgStructByOrgId(adminOrgObjs);
        if (!ObjectUtils.isEmpty(newStructList)) {
            listHisVersionParamBo.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newStructList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false));
        }
        if (!ObjectUtils.isEmpty(newOrgList = AdminOrgChgStructService.getInstance().getChgBelongCompanyByOrgId(adminOrgObjs, listHisVersionParamBo))) {
            listHisVersionParamBo.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newOrgList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false));
        }
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public HisResponse<VersionChangeRespData> batchSaveTemp(DynamicObject[] adminOrgObjs) {
        if (Objects.isNull(adminOrgObjs) || adminOrgObjs.length == 0) {
            throw new KDBizException("No data, can't do save temp, please check!");
        }
        long startTimeStamp = System.currentTimeMillis();
        Map<Long, DynamicObject> allParentOrgMap = AdminOrgHisServiceHelper.getAllParentOrgs(adminOrgObjs);
        for (DynamicObject dynamicObject : adminOrgObjs) {
            this.buildAdminBasicInfo(dynamicObject, Boolean.FALSE, null, allParentOrgMap);
            dynamicObject.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        }
        HisVersionParamBo adminOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(adminOrgObjs, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
        adminOrgHisVersionParam.setEffImmediately(Boolean.FALSE.booleanValue());
        logger.info(String.format(Locale.ROOT, "AdminOrgServiceImpl.batchSaveTemp() construct basic info cost %s milliseconds, and the size of org is %s", System.currentTimeMillis() - startTimeStamp, adminOrgObjs.length));
        HisResponse adminOrgHisVersionChangeResp = HisModelController.getInstance().hisVersionChange(adminOrgHisVersionParam);
        logger.info(String.format(Locale.ROOT, "AdminOrgServiceImpl.batchSaveTemp() save basic info cost %s milliseconds, and the size of org is %s", System.currentTimeMillis() - startTimeStamp, adminOrgObjs.length));
        HisVersionParamBo orgStructHisParam = AdminOrgStructService.getInstance().buildSaveTempHisParam(adminOrgObjs);
        orgStructHisParam.setEffImmediately(Boolean.FALSE.booleanValue());
        logger.info(String.format(Locale.ROOT, "AdminOrgServiceImpl.batchSaveTemp() construct struct info cost %s milliseconds, and the size of org is %s", System.currentTimeMillis() - startTimeStamp, adminOrgObjs.length));
        HisModelController.getInstance().hisVersionChange(orgStructHisParam);
        logger.info(String.format(Locale.ROOT, "AdminOrgServiceImpl.batchSaveTemp() save struct info cost %s milliseconds, and the size of org is %s", System.currentTimeMillis() - startTimeStamp, adminOrgObjs.length));
        return adminOrgHisVersionChangeResp;
    }

    private DynamicObject buildAdminBasicInfo(DynamicObject orgDynObj, boolean isChange, DynamicObject oldOrgDyn, Map<Long, DynamicObject> allParentOrgMap) {
        String structNumber;
        DynamicObject orgDyn;
        long id = orgDynObj.getLong("id");
        if (isChange) {
            orgDyn = new DynamicObject(orgDynObj.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)oldOrgDyn, (DynamicObject)orgDyn);
            HRDynamicObjectUtils.copy((DynamicObject)orgDynObj, (DynamicObject)orgDyn, AdminOrgHisServiceHelper.getChangeOrgCopyIgnoreKeys());
            structNumber = oldOrgDyn.getString("structnumber");
            orgDyn.set("boid", (Object)id);
            orgDyn.set("id", null);
        } else {
            orgDyn = orgDynObj;
            if (id == 0L) {
                id = ORM.create().genLongId("haos_adminorgdetail");
                orgDyn.set("id", (Object)id);
            }
            structNumber = ORM.create().genStringId("haos_adminorgdetail");
        }
        orgDyn.set("enable", (Object)"1");
        orgDyn.set("status", (Object)"C");
        orgDyn.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
        orgDyn.set("initstatus", (Object)"2");
        orgDyn.set("structnumber", (Object)structNumber);
        String index = orgDyn.getString("index");
        if (HRStringUtils.isEmpty((String)index)) {
            index = AdminOrgHisServiceHelper.getCurOrgIndex(orgDyn);
            orgDyn.set("index", (Object)index);
        }
        long adminOrgTypeId = orgDyn.getLong("adminorgtype.adminorgtypestd.id");
        switch (Objects.requireNonNull(AdminOrgType.getById((long)adminOrgTypeId))) {
            case GROUP: 
            case COMPANY: {
                orgDyn.set("belongcompany", (Object)orgDyn.getLong("id"));
                break;
            }
            case DEPARTMENT: {
                orgDyn.set("belongdept", (Object)orgDyn.getLong("id"));
            }
            case REGION: {
                orgDyn.set("belongcompany", (Object)AdminOrgHisServiceHelper.findBelongCompany(allParentOrgMap, orgDyn));
                break;
            }
        }
        return orgDyn;
    }

    @Override
    public void batchEnableOrDisable(DynamicObject[] adminOrgObjs, String enable) {
    }

    @Override
    public void batchCheck(DynamicObject[] adminOrgObjs) {
    }
}

