/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.orgmsg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.service.impl.orgmsg.CommonOrgMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.MergeSplitMsgInfo;
import kd.hr.haos.business.domain.service.orgmsg.ChangeMsgService;
import kd.hr.haos.business.servicehelper.OrgChangeMsgServiceHelper;
import kd.hr.haos.business.task.PublishTask;
import kd.hr.haos.business.util.SynOrgChangeToOtherDomainUtil;
import kd.hr.haos.common.constants.PublishConstants;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ChangeMsgServiceImpl
implements ChangeMsgService {
    public static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HAOSChangeMsgServiceThreadpool", (int)1, (int)4);
    private Lock lock;
    private String groupNumber;

    public ChangeMsgServiceImpl(Lock lock, String groupNumber) {
        this.groupNumber = groupNumber;
        this.lock = lock;
    }

    public ChangeMsgServiceImpl() {
    }

    @Override
    public void handleChangeMsg(List<DynamicObject> orgList, Map<Long, List<Long>> sceneSubMap, String operateKey) {
        List<DynamicObject> msgList = this.assembleMsgList(orgList, sceneSubMap, operateKey);
        if (msgList != null && !CollectionUtils.isEmpty(msgList)) {
            OrgChangeMsgServiceHelper.saveBatch(msgList);
            List<Long> ids = msgList.stream().map(msg -> msg.getLong("id")).collect(Collectors.toList());
            DynamicObject[] msgs = OrgChangeMsgServiceHelper.queryRetryMsgsById(ids);
            threadPool.execute((Runnable)new PublishTask(Arrays.asList(msgs), this.lock, this.groupNumber));
        }
        SynOrgChangeToOtherDomainUtil.synOrgChange(orgList);
    }

    @Override
    public void retrySendMsgs(DynamicObject[] msgs) {
        PublishTask publishTask = new PublishTask();
        publishTask.publish(Arrays.asList(msgs), null, true, false);
    }

    private List<DynamicObject> assembleMsgList(List<DynamicObject> orgList, Map<Long, List<Long>> sceneSubMap, String operateKey) {
        if (CollectionUtils.isEmpty(orgList)) {
            return null;
        }
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)orgList.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_changemsg");
        long[] msgNumbers = DB.genGlobalLongIds((int)orgList.size());
        int index = 0;
        Date now = new Date();
        for (DynamicObject org : orgList) {
            if (HRStringUtils.equals((String)org.getString("companychangetype"), (String)AdminOrgConstants.CompanyChangeType.SELF_CHANGE.code())) continue;
            DynamicObject msg = new DynamicObject((DynamicObjectType)dataEntityType);
            this.assembleMsgProp(msg, org, sceneSubMap == null ? null : sceneSubMap.get(org.getLong("id")), operateKey);
            this.setMsgCommonProp(msg, msgNumbers[index], now);
            msgList.add(msg);
            ++index;
        }
        return msgList;
    }

    protected void assembleMsgProp(DynamicObject msg, DynamicObject org, List<Long> sceneSub, String operateKey) {
        CommonOrgMsgService.setMsgCommonProperty(msg, org, operateKey);
        this.setMsgParam(msg, org, sceneSub, operateKey);
    }

    public Map<String, Object> setMsgParam(DynamicObject msg, DynamicObject org, List<Long> sceneSub, String operateKey) {
        return CommonOrgMsgService.setParams(msg, org, sceneSub, HRStringUtils.equals((String)operateKey, (String)"C"));
    }

    public List<DynamicObject> assembleMsgListForMergeAndSplit(List<DynamicObject> orgList, Map<Long, List<Long>> sceneSubMap, boolean isMerge, String operateKey, Map<Long, DynamicObject> allBoIdMap, Map<Long, DynamicObject> allAddBoIdMap) {
        if (CollectionUtils.isEmpty(orgList)) {
            return null;
        }
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)orgList.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_changemsg");
        long[] msgNumbers = DB.genGlobalLongIds((int)orgList.size());
        int index = 0;
        Date now = new Date();
        HashSet<Long> boIdSet = new HashSet<Long>();
        Map<String, List<DynamicObject>> groupByAfterMerge = orgList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("changetype.id") + "_" + dy.getLong(isMerge ? "aftermergeorgid" : "beforesplitorgid")));
        for (Map.Entry<String, List<DynamicObject>> entry : groupByAfterMerge.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            List<DynamicObject> beforeMergeOrgId = value.stream().filter(dy -> dy.getLong(isMerge ? "beforemergeorgid" : "aftersplitorgid") != 0L).collect(Collectors.toList());
            List<DynamicObject> afterMergeOrgId = value.stream().filter(dy -> dy.getLong(isMerge ? "beforemergeorgid" : "aftersplitorgid") == 0L).collect(Collectors.toList());
            List<Long> beforeIds = beforeMergeOrgId.stream().map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toList());
            List<Long> afterOrgIds = afterMergeOrgId.stream().map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toList());
            if (beforeMergeOrgId.size() <= 0) continue;
            MergeSplitMsgInfo afterInfo = this.getAfterInfo(allBoIdMap, afterMergeOrgId);
            ArrayList<MergeSplitMsgInfo> beforeInfo = new ArrayList<MergeSplitMsgInfo>(beforeMergeOrgId.size());
            for (DynamicObject dynamicObject : beforeMergeOrgId) {
                beforeInfo.add(this.getBeforeInfo(allBoIdMap, dynamicObject));
            }
            StringBuilder afterName = new StringBuilder();
            afterName.append("\u3010").append(allBoIdMap.containsKey(afterMergeOrgId.get(0).getLong("adminorg.boid")) ? allBoIdMap.get(afterMergeOrgId.get(0).getLong("adminorg.boid")).getString("name") : afterMergeOrgId.get(0).getString("adminorg.name")).append("\u3011");
            String beforeName = this.getBeforeName(beforeMergeOrgId, allBoIdMap);
            String batchNumber = this.getBatchNo();
            for (DynamicObject dyn2 : value) {
                if (!boIdSet.add(dyn2.getLong("adminorg.boid"))) continue;
                DynamicObject msg = this.getMsgAndFill(operateKey, dataEntityType, dyn2, allBoIdMap, allAddBoIdMap);
                Map<String, Object> params = this.setMsgParam(msg, dyn2, this.getSubScene(sceneSubMap, isMerge, beforeIds, afterOrgIds, dyn2), operateKey);
                params.put("batchno", batchNumber);
                params.put(isMerge ? "beforemergeorg" : "beforesplitorg", isMerge ? beforeInfo.stream().map(MergeSplitMsgInfo::toMap).collect(Collectors.toList()) : afterInfo.toMap());
                params.put(isMerge ? "aftermergeorg" : "aftersplitorg", isMerge ? afterInfo.toMap() : beforeInfo.stream().map(MergeSplitMsgInfo::toMap).collect(Collectors.toList()));
                String tag = "";
                String title = "";
                long actionId = 0L;
                switch (operateKey) {
                    case "C": {
                        if (!allBoIdMap.containsKey(dyn2.getLong("adminorg.boid"))) {
                            params.put("aftervid", dyn2.getString("adminorg.id"));
                        }
                        if (isMerge) {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5408\u5e76\u751f\u6548", (String)"OrgMergeMsgService_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5408\u5e76\u5230\u201c%2$s\u201d\u5df2\u751f\u6548\u3002", (String)"OrgMergeMsgService_1", (String)"hrmp-haos-business", (Object[])new Object[0]), beforeName, afterName);
                        } else {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u62c6\u5206\u751f\u6548", (String)"OrgSplitMsgService_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u62c6\u5206\u4e3a\u201c%2$s\u201d\u5df2\u751f\u6548\u3002", (String)"OrgSplitMsgService_1", (String)"hrmp-haos-business", (Object[])new Object[0]), afterName, beforeName);
                        }
                        actionId = isMerge ? 103115L : 103116L;
                        break;
                    }
                    case "submit": {
                        params.put("aftervid", dyn2.getString("adminorg.id"));
                        if (isMerge) {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5408\u5e76\u63d0\u4ea4", (String)"OrgMergeMsgService_8", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5408\u5e76\u5230\u201c%2$s\u201d\u5df2\u63d0\u4ea4\u3002", (String)"OrgMergeMsgService_9", (String)"hrmp-haos-business", (Object[])new Object[0]), beforeName, afterName);
                        } else {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u62c6\u5206\u63d0\u4ea4", (String)"OrgSplitMsgService_8", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u62c6\u5206\u4e3a\u201c%2$s\u201d\u5df2\u63d0\u4ea4\u3002", (String)"OrgSplitMsgService_9", (String)"hrmp-haos-business", (Object[])new Object[0]), afterName, beforeName);
                        }
                        actionId = isMerge ? 103125L : 103126L;
                        break;
                    }
                    case "auditing": {
                        params.put("aftervid", dyn2.getString("adminorg.id"));
                        if (isMerge) {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5408\u5e76\u5ba1\u6279", (String)"OrgMergeMsgService_2", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5408\u5e76\u5230\u201c%2$s\u201d\u5df2\u5ba1\u6279\u3002", (String)"OrgMergeMsgService_3", (String)"hrmp-haos-business", (Object[])new Object[0]), beforeName, beforeName);
                        } else {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u62c6\u5206\u5ba1\u6279", (String)"OrgSplitMsgService_2", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u62c6\u5206\u4e3a\u201c%2$s\u201d\u5df2\u5ba1\u6279\u3002", (String)"OrgSplitMsgService_3", (String)"hrmp-haos-business", (Object[])new Object[0]), afterName, beforeName);
                        }
                        actionId = isMerge ? 103155L : 103156L;
                        break;
                    }
                    case "unsubmit": {
                        params.put("aftervid", dyn2.getString("adminorg.id"));
                        if (isMerge) {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5408\u5e76\u64a4\u9500", (String)"OrgMergeMsgService_4", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5408\u5e76\u5230\u201c%2$s\u201d\u5df2\u64a4\u9500\u3002", (String)"OrgMergeMsgService_5", (String)"hrmp-haos-business", (Object[])new Object[0]), beforeName, afterName);
                        } else {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u62c6\u5206\u64a4\u9500", (String)"OrgSplitMsgService_4", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u62c6\u5206\u4e3a\u201c%2$s\u201d\u5df2\u64a4\u9500\u3002", (String)"OrgSplitMsgService_5", (String)"hrmp-haos-business", (Object[])new Object[0]), afterName, beforeName);
                        }
                        actionId = isMerge ? 103135L : 103136L;
                        break;
                    }
                    case "reject": 
                    case "wfrejecttosubmit": 
                    case "wfauditing": {
                        params.put("aftervid", dyn2.getString("adminorg.id"));
                        if (isMerge) {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5408\u5e76\u9a73\u56de", (String)"OrgMergeMsgService_6", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u5408\u5e76\u5230\u201c%2$s\u201d\u5df2\u9a73\u56de\u3002", (String)"OrgMergeMsgService_7", (String)"hrmp-haos-business", (Object[])new Object[0]), beforeName, afterName);
                        } else {
                            tag = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u62c6\u5206\u9a73\u56de", (String)"OrgSplitMsgService_6", (String)"hrmp-haos-business", (Object[])new Object[0]);
                            title = String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u62c6\u5206\u4e3a\u201c%2$s\u201d\u5df2\u9a73\u56de\u3002", (String)"OrgSplitMsgService_7", (String)"hrmp-haos-business", (Object[])new Object[0]), afterName, beforeName);
                        }
                        actionId = isMerge ? 103145L : 103146L;
                        break;
                    }
                }
                params.put("businessoperateid", actionId);
                params.put("businessopratetypeid", PublishConstants.businessType.get(actionId));
                msg.set("action", (Object)actionId);
                msg.set("msgtitle", (Object)this.subString(title, 255));
                msg.set("msgtag", (Object)this.subString(tag, 255));
                msg.set("msgdesc", (Object)this.subString(tag, 255));
                msg.set("msgparams", (Object)SerializationUtils.serializeToBase64(params));
                this.setMsgCommonProp(msg, msgNumbers[index], now);
                msgList.add(msg);
                ++index;
            }
            boIdSet.clear();
        }
        return msgList;
    }

    private MergeSplitMsgInfo getBeforeInfo(Map<Long, DynamicObject> allBoIdMap, DynamicObject dynamicObject) {
        return new MergeSplitMsgInfo(dynamicObject.getLong("adminorg.boid"), allBoIdMap.containsKey(dynamicObject.getLong("adminorg.boid")) ? allBoIdMap.get(dynamicObject.getLong("adminorg.boid")).getString("name") : dynamicObject.getString("adminorg.name"), allBoIdMap.containsKey(dynamicObject.getLong("adminorg.boid")) ? HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)allBoIdMap.get(dynamicObject.getLong("adminorg.boid")), (String)"changetype") : 0L);
    }

    private MergeSplitMsgInfo getAfterInfo(Map<Long, DynamicObject> allBoIdMap, List<DynamicObject> afterMergeOrgId) {
        MergeSplitMsgInfo afterInfo = new MergeSplitMsgInfo(afterMergeOrgId.get(0).getLong("adminorg.boid"), allBoIdMap.containsKey(afterMergeOrgId.get(0).getLong("adminorg.boid")) ? allBoIdMap.get(afterMergeOrgId.get(0).getLong("adminorg.boid")).getString("name") : afterMergeOrgId.get(0).getString("adminorg.name"), allBoIdMap.containsKey(afterMergeOrgId.get(0).getLong("adminorg.boid")) ? HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)allBoIdMap.get(afterMergeOrgId.get(0).getLong("adminorg.boid")), (String)"changetype") : 0L);
        return afterInfo;
    }

    private List<Long> getSubScene(Map<Long, List<Long>> sceneSubMap, boolean isMerge, List<Long> beforeIds, List<Long> afterOrgIds, DynamicObject dyn) {
        if (sceneSubMap == null) {
            return null;
        }
        ArrayList<Long> allSubScene = new ArrayList<Long>(10);
        List<Long> subScene = sceneSubMap.get(dyn.getLong("id"));
        if (subScene != null) {
            allSubScene.addAll(subScene);
        }
        if (isMerge) {
            if (beforeIds.contains(dyn.getLong("adminorg.boid")) && afterOrgIds.contains(dyn.getLong("adminorg.boid"))) {
                allSubScene.add(1090L);
            } else if (beforeIds.contains(dyn.getLong("adminorg.boid"))) {
                allSubScene.add(1100L);
            } else {
                allSubScene.add(1090L);
            }
        } else if (beforeIds.contains(dyn.getLong("adminorg.boid")) && afterOrgIds.contains(dyn.getLong("adminorg.boid"))) {
            allSubScene.add(1100L);
        } else if (beforeIds.contains(dyn.getLong("adminorg.boid"))) {
            allSubScene.add(1090L);
        } else {
            allSubScene.add(1100L);
        }
        return allSubScene;
    }

    public void setMsgCommonProp(DynamicObject msg, long msgNumber, Date time) {
        msg.set("number", (Object)msgNumber);
        msg.set("sendstate", (Object)"0");
        msg.set("status", (Object)Character.valueOf('C'));
        msg.set("enable", (Object)"1");
        msg.set("changetime", (Object)time);
    }

    public String subString(String str, int length) {
        if (HRStringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.length() > length ? str.substring(0, length) : str;
    }

    public String getBeforeName(List<DynamicObject> beforeMergeOrgId, Map<Long, DynamicObject> allBoIdMap) {
        StringBuilder beforeName = new StringBuilder();
        for (int idx = 0; idx < beforeMergeOrgId.size(); ++idx) {
            if (idx == beforeMergeOrgId.size() - 1) {
                beforeName.append("\u3010").append(allBoIdMap.containsKey(beforeMergeOrgId.get(idx).getLong("adminorg.boid")) ? allBoIdMap.get(beforeMergeOrgId.get(idx).getLong("adminorg.boid")).getString("name") : beforeMergeOrgId.get(idx).getString("adminorg.name")).append("\u3011");
                continue;
            }
            beforeName.append("\u3010").append(allBoIdMap.containsKey(beforeMergeOrgId.get(idx).getLong("adminorg.boid")) ? allBoIdMap.get(beforeMergeOrgId.get(idx).getLong("adminorg.boid")).getString("name") : beforeMergeOrgId.get(idx).getString("adminorg.name")).append("\u3011").append("\u3001");
        }
        return beforeName.toString();
    }

    public String getBatchNo() {
        StringBuilder sb = new StringBuilder();
        sb.append(UUID.randomUUID()).append(System.currentTimeMillis());
        return sb.toString().replaceAll("-", "");
    }

    public DynamicObject getMsgAndFill(String operateKey, MainEntityType dataEntityType, DynamicObject dyn, Map<Long, DynamicObject> allBoIdMap, Map<Long, DynamicObject> allAddBoIdMap) {
        DynamicObject msg = new DynamicObject((DynamicObjectType)dataEntityType);
        msg.set("changescene", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"changescene"));
        msg.set("changetype", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"changetype"));
        if (allBoIdMap.containsKey(dyn.getLong("adminorg.boid"))) {
            msg.set("changeoperate", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)allBoIdMap.get(dyn.getLong("adminorg.boid")), (String)"changetype"));
        } else {
            msg.set("changeoperate", (Object)0L);
        }
        msg.set("changereason", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"changereason"));
        msg.set("changedesc", (Object)dyn.getString("changedescription"));
        msg.set("effetdate", (Object)dyn.getDate("bsed"));
        msg.set("changeuser", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"creator"));
        if ("C".equals(operateKey)) {
            if (allBoIdMap.containsKey(dyn.getLong("adminorg.boid"))) {
                msg.set("adminorg", (Object)dyn.getLong("afterbaseinfoid"));
            } else {
                msg.set("adminorg", (Object)dyn.getLong("adminorg.id"));
            }
        } else {
            msg.set("adminorg", (Object)dyn.getLong("adminorg.id"));
        }
        if (allAddBoIdMap.containsKey(dyn.getLong("adminorg.boid"))) {
            msg.set("adminorgbo", (Object)this.getParentBoId(dyn.getLong("parentorg.boid"), allAddBoIdMap));
        } else {
            msg.set("adminorgbo", (Object)dyn.getLong("adminorg.boid"));
        }
        return msg;
    }

    public Map<String, Object> setMsgParamForMergeSplit(DynamicObject org, List<Long> sceneSub, String operateKey, Map<Long, DynamicObject> allBoIdMap) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put("aftervid", org.getString("afterbaseinfoid"));
        params.put("boid", org.getString("adminorg.boid"));
        params.put("number", org.getString("number"));
        params.put("name", org.getString("name"));
        if (org.getDate("bsed") instanceof Timestamp) {
            params.put("bsed", org.getDate("bsed"));
        } else {
            params.put("bsed", HRDateTimeUtils.format((Date)org.getDate("bsed"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        params.put("changescene", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changescene"));
        params.put("changetype", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changetype"));
        if (allBoIdMap.containsKey(org.getLong("adminorg.boid"))) {
            params.put("changeoperate", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)allBoIdMap.get(org.getLong("adminorg.boid")), (String)"changetype"));
        } else {
            params.put("changeoperate", 0L);
        }
        params.put("changereason", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changereason"));
        if (allBoIdMap.containsKey(org.getLong("adminorg.boid"))) {
            params.put("entryid", allBoIdMap.get(org.getLong("adminorg.boid")).getString("id"));
            params.put("name", allBoIdMap.get(org.getLong("adminorg.boid")).getString("name"));
            params.put("number", allBoIdMap.get(org.getLong("adminorg.boid")).getString("number"));
        } else {
            params.put("entryid", 0L);
        }
        params.put("billid", org.getString("billid"));
        params.put("scenesub", sceneSub);
        if (HRStringUtils.equals((String)operateKey, (String)"C")) {
            params.put("eventid", org.getString("billid"));
        }
        return params;
    }

    private Long getParentBoId(Long parentBoId, Map<Long, DynamicObject> allAddBoIdMap) {
        LinkedList<Long> queue = new LinkedList<Long>();
        queue.offer(parentBoId);
        while (!queue.isEmpty()) {
            Long boId = (Long)queue.poll();
            if (allAddBoIdMap != null && allAddBoIdMap.containsKey(boId)) {
                DynamicObject dynamicObject = allAddBoIdMap.get(boId);
                queue.offer(dynamicObject.getLong("parentorg.boid"));
                continue;
            }
            return boId;
        }
        throw new RuntimeException("can not find parentorg.boid in this data");
    }
}

