/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.orgmsg;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.haos.business.domain.service.impl.orgmsg.ChangeMsgServiceImpl;
import kd.hr.haos.common.constants.PublishConstants;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ReviseMsgService
extends ChangeMsgServiceImpl {
    private final Long reviseReasonId;
    private final Object reviseExplain;
    private final Long eventId;
    private final Map<Long, List<Long>> sceneSubMap;

    public ReviseMsgService(Long eventId, Long reviseReasonId, Object reviseExplain, Map<Long, List<Long>> sceneSubMap) {
        super(null, null);
        this.eventId = eventId;
        this.reviseReasonId = reviseReasonId;
        this.reviseExplain = reviseExplain;
        this.sceneSubMap = sceneSubMap;
    }

    @Override
    protected void assembleMsgProp(DynamicObject msg, DynamicObject org, List<Long> sceneSub, String auditStatus) {
        msg.set("changescene", (Object)PublishConstants.CHANGE_SCENE_REVISE);
        msg.set("changetype", (Object)PublishConstants.CHANGE_TYPE_REVISE);
        msg.set("changeoperate", (Object)PublishConstants.CHANGE_OPERATE_REVISE);
        msg.set("changereason", (Object)this.reviseReasonId);
        msg.set("changedesc", this.reviseExplain);
        msg.set("effetdate", (Object)org.getDate("bsed"));
        msg.set("changeuser", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"creator"));
        msg.set("adminorg", (Object)org.getLong("id"));
        msg.set("adminorgbo", (Object)org.getLong("boid"));
        msg.set("action", (Object)103161L);
        msg.set("msgtitle", (Object)this.subString(this.getTitle(org), 255));
        msg.set("msgtag", (Object)this.subString(this.getTag(), 255));
        msg.set("msgdesc", (Object)this.subString(this.getTag(), 255));
        msg.set("msgparams", (Object)SerializationUtils.serializeToBase64(this.getParams(org, sceneSub)));
    }

    private String getTag() {
        return ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4fe1\u606f\u4fee\u8ba2", (String)"ReviseMsgService_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    private String getTitle(DynamicObject org) {
        return String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u5df2\u88ab\u4fee\u8ba2\u3002", (String)"ReviseMsgService_1", (String)"hrmp-haos-business", (Object[])new Object[0]), org.getString("name"));
    }

    private Map<String, Object> getParams(DynamicObject org, List<Long> sceneSub) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("boid", org.getString("boid"));
        params.put("number", org.getString("number"));
        params.put("name", org.getString("name"));
        params.put("bsed", HRDateTimeUtils.format((Date)org.getDate("bsed")));
        params.put("datastatus", org.getString("datastatus"));
        params.put("changescene", PublishConstants.CHANGE_SCENE_REVISE);
        params.put("changetype", PublishConstants.CHANGE_TYPE_REVISE);
        params.put("changeoperate", PublishConstants.CHANGE_OPERATE_REVISE);
        params.put("businessoperateid", 103161L);
        params.put("businessopratetypeid", PublishConstants.businessType.get(103161L));
        params.put("eventid", this.eventId);
        Iterator<Map.Entry<Long, List<Long>>> it = this.sceneSubMap.entrySet().iterator();
        if (it.hasNext()) {
            params.put("scenesub", it.next().getValue());
        }
        params.put("changed", this.buildParams(org.getString("sourcevid")));
        return params;
    }

    private List<Map<String, Object>> buildParams(String beforeIdStr) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.sceneSubMap.size());
        for (Map.Entry<Long, List<Long>> entry : this.sceneSubMap.entrySet()) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            params.put("scenesub", entry.getValue());
            params.put("aftervid", String.valueOf(entry.getKey()));
            params.put("beforevid", beforeIdStr);
            list.add(params);
        }
        return list;
    }
}

