/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.orgteam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.domain.service.impl.teamcoop.TeamCoopRelServiceImpl;
import kd.hr.haos.business.domain.service.orgteam.IOrgTeamService;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.service.orgteam.OrgTeamEnablingService;
import kd.hr.haos.business.util.BatchSynOtUtils;
import kd.hr.haos.business.util.HAOSDynamicObjectUtil;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.model.orgteam.EnablingModel;
import kd.hr.haos.common.util.DyCollectors;
import kd.hr.haos.common.util.HRDyObjectUtils;

public class OrgTeamServiceImpl
implements IOrgTeamService {
    public static OrgTeamServiceImpl getInstance() {
        return OrgTeamServiceInstance.INSTANCE;
    }

    @Override
    public List<Long> getCurAndSubOrgTeamByBoIdSet(Set<Long> boIdSet) {
        ArrayList<Long> retData = new ArrayList<Long>(16);
        if (ObjectUtils.isEmpty(boIdSet)) {
            return retData;
        }
        OTStructRepository otStructInstance = OTStructRepository.getInstance();
        Object[] curBoOTStructDynArr = otStructInstance.queryOTStructByOrgTeamBoIdSet("structlongnumber", boIdSet);
        if (ObjectUtils.isEmpty((Object[])curBoOTStructDynArr)) {
            return retData;
        }
        HashSet<String> structLongNumberSet = new HashSet<String>(16);
        Arrays.stream(curBoOTStructDynArr).forEach(dyn -> structLongNumberSet.add(dyn.getString("structlongnumber")));
        DynamicObject[] otStructDynArr = otStructInstance.queryOTAllCurAndSubDynBySNSet("orgteam.id", structLongNumberSet, null);
        Arrays.stream(otStructDynArr).forEach(dyn -> retData.add(dyn.getLong("orgteam.id")));
        return retData;
    }

    @Override
    public void add(List<DynamicObject> otList, long structProjectId) {
        Map<Long, Long> boIdVsId = otList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
        otList.forEach(dy -> dy.set("id", (Object)dy.getLong("boid")));
        List newList = otList.stream().map(BatchSynOtUtils.createNewOt4Scene()).collect(Collectors.toList());
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setSaveList(BatchSynOtUtils.createNewOt4SaveList(otList));
        batchSynModel.setNewList(newList);
        batchSynModel.setFirstVersionMap(boIdVsId);
        batchSynModel.setStrucrProjectId(structProjectId);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        Map<Long, List<TeamCoopRelBO>> orgIdVsCoopRelList = this.getOrgIdVsCoopRelBoList(otList);
        TeamCoopRelServiceImpl.getInstance().batchAddNew(orgIdVsCoopRelList, null);
    }

    @Override
    public void change(List<DynamicObject> otList, long structProjectId) {
        Map<Boolean, List<DynamicObject>> isChangeParentVsOtList = this.partitionByChangeParent(otList);
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setChgParentList(isChangeParentVsOtList.getOrDefault(true, Collections.emptyList()));
        batchSynModel.setChgInfoList(isChangeParentVsOtList.getOrDefault(false, Collections.emptyList()));
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setSaveList(BatchSynOtUtils.createNewOt4SaveList(otList));
        batchSynModel.setStrucrProjectId(structProjectId);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        TeamCoopRelServiceImpl.getInstance().batchChangeOnlyAd(this.getOrgIdVsCoopRelBoList(otList), null, null);
    }

    @Override
    public void modify(List<DynamicObject> otList, long structProjectId) {
        Map<Boolean, List<DynamicObject>> isChangeParentVsOtList = this.partitionByChangeParent(otList);
        EnablingModel enablingModel = new EnablingModel();
        enablingModel.setModifyParentList(isChangeParentVsOtList.getOrDefault(true, Collections.emptyList()));
        enablingModel.setModifyInfoList(isChangeParentVsOtList.getOrDefault(false, Collections.emptyList()));
        enablingModel.setSaveList(BatchSynOtUtils.createNewOt4SaveListPure(otList));
        enablingModel.setStructProjectId(structProjectId);
        OrgTeamEnablingService orgTeamEnablingService = new OrgTeamEnablingService();
        orgTeamEnablingService.setEnablingModel(enablingModel);
        orgTeamEnablingService.modify();
        Set parentChgBoSet = (Set)isChangeParentVsOtList.getOrDefault(true, Collections.emptyList()).stream().collect(DyCollectors.toBoIdSet());
        Map parentChgBoIdVsOt = (Map)otList.stream().filter(ot -> parentChgBoSet.contains(ot.getLong("boid"))).collect(DyCollectors.toBoIdVsDy());
        Date now = new Date();
        DynamicObject[] dbCoopRels = TeamCoopRelRepository.getInstance().loadAdCoopRelAllDataByOtBo(parentChgBoIdVsOt.keySet());
        Arrays.stream(dbCoopRels).forEach(dbCoopRel -> {
            DynamicObject ot = (DynamicObject)parentChgBoIdVsOt.get(dbCoopRel.getLong("org.id"));
            long otParentId = HAOSDynamicObjectUtil.smartGetId(ot.get("parent"));
            DynamicObjectType parentOrgDyType = HRDyObjectUtils.createDyTypeFromTargetType((DynamicObjectType)dbCoopRel.getDynamicObjectType(), (String)"cooporgteam");
            DynamicObject coopTeamDy = new DynamicObject(parentOrgDyType);
            coopTeamDy.set("id", (Object)otParentId);
            dbCoopRel.set("cooporgteam", (Object)coopTeamDy);
            dbCoopRel.set("bsed", ot.get("bsed"));
            dbCoopRel.set("modifytime", (Object)now);
        });
        SaveServiceHelper.update((DynamicObject[])dbCoopRels);
    }

    @Override
    public void enableEnabling(List<DynamicObject> otList, long structProjectId) {
        EnablingModel enablingModel = new EnablingModel();
        enablingModel.setEnableList(otList);
        enablingModel.setSaveList(otList);
        enablingModel.setStructProjectId(structProjectId);
        OrgTeamEnablingService orgTeamEnablingService = new OrgTeamEnablingService();
        orgTeamEnablingService.setEnablingModel(enablingModel);
        orgTeamEnablingService.enable();
        Set otBoSet = (Set)otList.stream().collect(DyCollectors.toBoIdSet());
        Date now = new Date();
        DynamicObject[] coopRels = TeamCoopRelRepository.getInstance().queryAffiliationAllDataByOt("id, enable, modifytime", otBoSet);
        Arrays.stream(coopRels).forEach(coopRel -> {
            coopRel.set("enable", (Object)"1");
            coopRel.set("modifytime", (Object)now);
        });
        SaveServiceHelper.update((DynamicObject[])coopRels);
    }

    @Override
    public void disable(List<DynamicObject> otList, long structProjectId) {
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setSaveList(BatchSynOtUtils.createNewOt4SaveList(otList));
        batchSynModel.setStatusChgList(BatchSynOtUtils.createNewOt4SceneList(otList));
        batchSynModel.setStrucrProjectId(structProjectId);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        this.statusChangeCoopRel(otList, "0");
    }

    @Override
    public void enable(List<DynamicObject> otList, long structProjectId) {
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setSaveList(BatchSynOtUtils.createNewOt4SaveList(otList));
        batchSynModel.setStatusChgList(BatchSynOtUtils.createNewOt4SceneList(otList));
        batchSynModel.setStrucrProjectId(structProjectId);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        this.statusChangeCoopRel(otList, "1");
    }

    private Map<Long, List<TeamCoopRelBO>> getOrgIdVsCoopRelBoList(List<DynamicObject> otList) {
        return otList.stream().map(ot -> {
            TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO();
            teamCoopRelBO.setOrgTeamId(ot.getLong("boid"));
            teamCoopRelBO.setCoopTeamId(ot.getLong("parent.id"));
            teamCoopRelBO.setCoopTypeId(1010L);
            teamCoopRelBO.setEffDate(ot.getDate("bsed"));
            teamCoopRelBO.setEnable(ot.getString("enable"));
            return teamCoopRelBO;
        }).collect(Collectors.groupingBy(TeamCoopRelBO::getOrgTeamId));
    }

    private void statusChangeCoopRel(List<DynamicObject> otList, String statusChangeType) {
        DynamicObject[] coopRelDys = TeamCoopRelRepository.getInstance().queryOriginalArray4CurrentVersionOnlyAdByOt("boid", otList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet()));
        List<Long> coopRelBoList = Arrays.stream(coopRelDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        Date bsed = otList.get(0).getDate("bsed");
        TeamCoopRelServiceImpl.getInstance().batchEnableOrDisable(coopRelBoList, statusChangeType, bsed, null);
    }

    private Map<Boolean, List<DynamicObject>> partitionByChangeParent(List<DynamicObject> otList) {
        DynamicObject[] ots = OTQueryRepository.getInstance().queryOriginalArrById("parent.id, boid", otList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet()));
        Map<Long, DynamicObject> boidVsDbOt = Arrays.stream(ots).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        return otList.stream().collect(Collectors.groupingBy(ot -> {
            long curParentId;
            DynamicObject dbOt = (DynamicObject)boidVsDbOt.get(ot.getLong("boid"));
            long dbParentId = dbOt.getLong("parent.id");
            return dbParentId != (curParentId = ot.getLong("parent.id"));
        }, Collectors.mapping(BatchSynOtUtils.createNewOt4Scene(), Collectors.toList())));
    }

    private static class OrgTeamServiceInstance {
        private static OrgTeamServiceImpl INSTANCE = new OrgTeamServiceImpl();

        private OrgTeamServiceInstance() {
        }
    }
}

