/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractOrgStaffSaveService
implements OrgStaffConstants {
    protected static final Log logger = LogFactory.getLog(AbstractOrgStaffSaveService.class);
    protected AbstractOrgStaffSaveService preStaffSaveService;
    protected AbstractOrgStaffSaveService nextStaffSaveService;
    protected String entityName;
    protected String entryName;
    protected DynamicObject[] staffDynArr;
    protected List<Long> staffIdList;
    protected List<Long> useOrgBoIdList;
    protected List<Long> noChangeIdList = Lists.newArrayListWithExpectedSize((int)16);
    protected List<Long> onlyOrgVersionChangeList = Lists.newArrayListWithExpectedSize((int)16);
    protected static List<String> ignoreFieldList = Lists.newArrayListWithExpectedSize((int)100);
    protected Map<Long, List<DynamicObject>> staffIdVsEntryDataFromDBMap;
    protected List<String> invalidIdList = Lists.newArrayListWithExpectedSize((int)16);
    private static final List<String> diffIgnoreFieldList = Arrays.asList("id", "seq", "bparentlongname", "multilanguagetext", "isGroupNode", "brealnumwithsub", "blevel", "bstaffnumwithsub", "bstaffnumwithsubnum", "byearstaffnumwithsubnum", "byearstaffnumwithsub", "bstaffnumwithsubnum", "astructlongnumber", "bstructlongnumber", "buseorgboid", "buseorgboid_id", "bhavesubentry", "buseorg", "buseorg_id");
    private static final List<String> commonIgnoreFieldList = Arrays.asList("entryentity", "directnum", "yearstaffnum", "halfyearstaff1num", "halfyearstaff2num", "quarterstaff1num", "quarterstaff2num", "quarterstaff3num", "quarterstaff4num", "monthstaff1num", "monthstaff2num", "monthstaff3num", "monthstaff4num", "monthstaff5num", "monthstaff6num", "monthstaff7num", "monthstaff8num", "monthstaff9num", "monthstaff10num", "monthstaff11num", "monthstaff12num", "useorg", "useorg_id", "dutyorg", "dutyorg_id", "orgteam", "orgteam_id");

    public AbstractOrgStaffSaveService(DynamicObject[] staffDynArr, String entityName, String entryName) {
        this.staffDynArr = staffDynArr;
        this.staffIdList = Arrays.stream(staffDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        this.useOrgBoIdList = Lists.newArrayListWithExpectedSize((int)staffDynArr.length);
        for (DynamicObject staffDyn : staffDynArr) {
            DynamicObjectCollection useOrgEntryCol = staffDyn.getDynamicObjectCollection("bentryentity");
            if (CollectionUtils.isEmpty((Collection)useOrgEntryCol)) continue;
            useOrgEntryCol.stream().forEach(entry -> this.useOrgBoIdList.add(entry.getLong("buseorg.boid")));
        }
        this.entityName = entityName;
        this.entryName = entryName;
    }

    public void setNextStaffSaveService(AbstractOrgStaffSaveService nextStaffSaveService) {
        this.nextStaffSaveService = nextStaffSaveService;
    }

    public void setPreStaffSaveService(AbstractOrgStaffSaveService preStaffSaveService) {
        this.preStaffSaveService = preStaffSaveService;
    }

    public AbstractOrgStaffSaveService getNextStaffSaveService() {
        return this.nextStaffSaveService;
    }

    public List<String> getInvalidIdList() {
        return this.invalidIdList;
    }

    public List<Long> getNoChangeIdList() {
        return this.noChangeIdList;
    }

    public List<Long> getOnlyOrgVersionChangeList() {
        return this.onlyOrgVersionChangeList;
    }

    public void invokeStaffSave(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        logger.info("invokeStaffSave.begin!staffHisParamBOs.size:{}", (Object)staffHisParamBOs.size());
        this.beforeInvokeStaff(staffDynArr);
        String enable = staffDynArr[0].getString("enable");
        if ("10".equals(enable)) {
            this.saveTempStaffInfo(staffDynArr, staffHisParamBOs);
        } else {
            this.saveStaffInfo(staffDynArr, staffHisParamBOs);
        }
        this.afterInvokeStaff(staffHisParamBOs);
        if (this.nextStaffSaveService != null) {
            this.nextStaffSaveService.invokeStaffSave(staffDynArr, staffHisParamBOs);
        }
    }

    protected abstract void beforeInvokeStaff(DynamicObject[] var1);

    protected abstract void afterInvokeStaff(List<StaffHisParamBO> var1);

    protected void saveStaffInfo(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        for (DynamicObject staffDyn : staffDynArr) {
            long staffId = staffDyn.getLong("id");
            List<DynamicObject> useOrgHisInfoList = this.updateEntryEntityValue(staffDyn);
            if (CollectionUtils.isEmpty(useOrgHisInfoList)) {
                staffHisParamBOs.add(new StaffHisParamBO(this.entityName, Lists.newArrayListWithExpectedSize((int)1), this.noChangeIdList, this.onlyOrgVersionChangeList, staffId));
                continue;
            }
            staffHisParamBOs.add(new StaffHisParamBO(this.entityName, useOrgHisInfoList, this.noChangeIdList, this.onlyOrgVersionChangeList, staffId));
        }
    }

    protected abstract void saveTempStaffInfo(DynamicObject[] var1, List<StaffHisParamBO> var2);

    protected void setSpecialField(Map<String, Object> param) {
        DynamicObject newDyn = (DynamicObject)param.get("newDyn");
        DynamicObject entry = (DynamicObject)param.get("entry");
        DynamicObject dynamicObject = (DynamicObject)param.get("dynamicObject");
        newDyn.set("staff", (Object)dynamicObject);
        newDyn.set("enable", (Object)dynamicObject.getString("enable"));
        newDyn.set("id", (Object)entry.getLong("id"));
        newDyn.set("sequence", (Object)entry.getInt("seq"));
    }

    protected Map<Long, List<DynamicObject>> getStaffInfoByStaffIdList(QFilter otherFilter) {
        HRBaseServiceHelper useOrgHelper = new HRBaseServiceHelper(this.entityName);
        QFilter staffIdFilter = new QFilter("staff", "in", this.staffIdList);
        DynamicObject[] dynArr = useOrgHelper.loadDynamicObjectArray(new QFilter[]{staffIdFilter, otherFilter});
        return Arrays.stream(dynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("staff.id")));
    }

    protected List<DynamicObject> updateEntryEntityValue(DynamicObject dynamicObject) {
        return this.updateEntryEntityValue(dynamicObject, -1);
    }

    protected List<DynamicObject> updateEntryEntityValue(DynamicObject staffDyn, int index) {
        DynamicObjectCollection entryCollFromPage;
        DynamicObject useOrgInfo = null;
        long useOrgId = 0L;
        if (index >= 0) {
            useOrgInfo = (DynamicObject)staffDyn.getDynamicObjectCollection("bentryentity").get(index);
            useOrgId = useOrgInfo.getLong("buseorg.boid");
            entryCollFromPage = useOrgInfo.getDynamicObjectCollection(this.entryName);
        } else {
            entryCollFromPage = staffDyn.getDynamicObjectCollection(this.entryName);
        }
        long staffId = staffDyn.getLong("id");
        List<DynamicObject> entryDataFromDBList = this.staffIdVsEntryDataFromDBMap.get(staffId);
        Map<Object, Object> idVsDynFromDBMap = CollectionUtils.isEmpty(entryDataFromDBList) ? Maps.newHashMapWithExpectedSize((int)0) : entryDataFromDBList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        ArrayList toSaveList = Lists.newArrayListWithExpectedSize((int)entryCollFromPage.size());
        for (DynamicObject entryFromPage : entryCollFromPage) {
            long entryIdFromPage = entryFromPage.getLong("id");
            String prefix = this.entryName.substring(0, 1);
            String keyFiledName = StaffEntryTempHelperEnum.getKeyFieldByPrefix(prefix);
            long keyFieldId = entryFromPage.getLong(prefix + keyFiledName + ".id");
            String invalidKey = this.getInvalidKey(useOrgId, keyFieldId);
            if (idVsDynFromDBMap.containsKey(entryIdFromPage)) {
                DynamicObject dynFromDB = (DynamicObject)idVsDynFromDBMap.get(entryIdFromPage);
                boolean isNoChange = StaffCommonService.compareDynamicObject(entryFromPage, dynFromDB, ignoreFieldList);
                boolean orgVersionChange = false;
                DynamicObject newUseOrgDyn = null;
                DynamicObject newDutyOrgDynForUseOrgEntry = null;
                if (HRStringUtils.equals((String)this.entityName, (String)"haos_dutyorgdetail")) {
                    newUseOrgDyn = staffDyn.getDynamicObjectCollection("aentryentity").stream().filter(dyn -> dynFromDB.getLong("dutyorg.boid") == dyn.getLong("adutyorg.boid")).map(dyn -> dyn.getDynamicObject("adutyorg")).findFirst().get();
                } else {
                    List dutyOrgDynList;
                    newUseOrgDyn = staffDyn.getDynamicObjectCollection("bentryentity").stream().filter(dyn -> dynFromDB.getLong("useorg.boid") == dyn.getLong("buseorg.boid")).map(dyn -> dyn.getDynamicObject("buseorg")).findFirst().get();
                    if (HRStringUtils.equals((String)this.entityName, (String)"haos_useorgdetail") && !CollectionUtils.isEmpty(dutyOrgDynList = staffDyn.getDynamicObjectCollection("bentryentity").stream().filter(dyn -> dynFromDB.getLong("useorg.boid") == dyn.getLong("buseorg.boid")).map(dyn -> dyn.getDynamicObject("bdutyorg")).collect(Collectors.toList()))) {
                        newDutyOrgDynForUseOrgEntry = (DynamicObject)dutyOrgDynList.get(0);
                    }
                }
                if (isNoChange) {
                    this.noChangeIdList.add(entryIdFromPage);
                    orgVersionChange = this.checkOrgVersionChange(entryIdFromPage, dynFromDB, orgVersionChange, newUseOrgDyn, newDutyOrgDynForUseOrgEntry);
                }
                if (isNoChange && !this.getInvalidIdList().contains(invalidKey) && !orgVersionChange) continue;
                DataEntityPropertyCollection properties = entryFromPage.getDynamicObjectType().getProperties();
                properties.stream().filter(prop -> !ignoreFieldList.contains(prop.getName())).forEach(prop -> {
                    if ("pid".equals(prop.getName())) {
                        dynFromDB.set(prop.getName(), entryFromPage.get(prop));
                    } else {
                        dynFromDB.set(prop.getName().substring(1), entryFromPage.get(prop));
                    }
                });
                if (Objects.nonNull(newUseOrgDyn)) {
                    if (HRStringUtils.equals((String)this.entityName, (String)"haos_dutyorgdetail")) {
                        dynFromDB.set("dutyorg", (Object)newUseOrgDyn);
                    } else {
                        dynFromDB.set("useorg", (Object)newUseOrgDyn);
                        if (HRStringUtils.equals((String)this.entityName, (String)"haos_muldimendetail")) {
                            dynFromDB.set("orgteam", (Object)newUseOrgDyn);
                        } else if (HRStringUtils.equals((String)this.entityName, (String)"haos_useorgdetail")) {
                            dynFromDB.set("dutyorg", (Object)newDutyOrgDynForUseOrgEntry);
                        }
                    }
                }
                toSaveList.add(dynFromDB);
                continue;
            }
            DataEntityPropertyCollection sourceProperties = entryFromPage.getDynamicObjectType().getProperties();
            HRBaseServiceHelper helper = new HRBaseServiceHelper(this.entityName);
            DynamicObject newdyn = helper.generateEmptyDynamicObject();
            DataEntityPropertyCollection targetProperties = newdyn.getDynamicObjectType().getProperties();
            sourceProperties.forEach(sourceProp -> {
                String fieldName = sourceProp.getName().substring(1);
                for (IDataEntityProperty targetProp : targetProperties) {
                    if (targetProp.getName().equals("pid")) {
                        newdyn.set("pid", entryFromPage.get("pid"));
                        continue;
                    }
                    if (!fieldName.equals(targetProp.getName())) continue;
                    newdyn.set(targetProp.getName(), entryFromPage.get(sourceProp.getName()));
                }
            });
            HashMap param = Maps.newHashMapWithExpectedSize((int)16);
            param.put("newDyn", newdyn);
            param.put("entry", entryFromPage);
            param.put("dynamicObject", staffDyn);
            param.put("useOrgInfo", useOrgInfo);
            this.setSpecialField(param);
            toSaveList.add(newdyn);
        }
        return toSaveList;
    }

    private boolean checkOrgVersionChange(long entryIdFromPage, DynamicObject dynFromDB, boolean orgVersionChange, DynamicObject newUseOrgDyn, DynamicObject newDutyOrgDynForUseOrgEntry) {
        if (HRStringUtils.equals((String)this.entityName, (String)"haos_dutyorgdetail")) {
            if (newUseOrgDyn.getLong("id") != dynFromDB.getLong("dutyorg.id")) {
                orgVersionChange = true;
                this.onlyOrgVersionChangeList.add(entryIdFromPage);
            } else if (HRStringUtils.equals((String)dynFromDB.getString("datastatus"), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue())) {
                orgVersionChange = true;
                this.onlyOrgVersionChangeList.add(entryIdFromPage);
            }
        } else {
            if (newUseOrgDyn.getLong("id") != dynFromDB.getLong("useorg.id")) {
                orgVersionChange = true;
                this.onlyOrgVersionChangeList.add(entryIdFromPage);
            } else if (HRStringUtils.equals((String)dynFromDB.getString("datastatus"), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue())) {
                orgVersionChange = true;
                this.onlyOrgVersionChangeList.add(entryIdFromPage);
            }
            if (HRStringUtils.equals((String)this.entityName, (String)"haos_useorgdetail") && !this.isSameIdBetweenDyn(newDutyOrgDynForUseOrgEntry, dynFromDB.getDynamicObject("dutyorg"))) {
                orgVersionChange = true;
                this.onlyOrgVersionChangeList.add(entryIdFromPage);
            }
        }
        return orgVersionChange;
    }

    private boolean isSameIdBetweenDyn(DynamicObject dyn1, DynamicObject dyn2) {
        if (dyn1 == null && dyn2 == null) {
            return true;
        }
        if (dyn1 == null || dyn2 == null) {
            return false;
        }
        return dyn1.getLong("id") == dyn2.getLong("id");
    }

    private String getInvalidKey(long useOrgId, long keyFieldId) {
        String invalidKey = String.valueOf(keyFieldId);
        if ("haos_muldimendetail".equals(this.entityName)) {
            invalidKey = useOrgId + "-" + keyFieldId;
        }
        return invalidKey;
    }

    protected void setEntryField(String keyFieldBoId, long useOrgBoId, DynamicObjectCollection entryData, Map<String, Long> boIdVsEntryIdMap) {
        if (CollectionUtils.isEmpty(boIdVsEntryIdMap)) {
            return;
        }
        for (DynamicObject entry : entryData) {
            Long id;
            String key = entry.getString(keyFieldBoId);
            if ("haos_muldimendetail".equals(this.entityName) && useOrgBoId != 0L) {
                key = useOrgBoId + "-" + key;
            }
            if ((id = boIdVsEntryIdMap.get(key)) != null) {
                entry.set("id", (Object)id);
            }
            this.setDutyOrg(entry);
        }
    }

    protected void setDutyOrg(DynamicObject entry) {
    }

    static {
        ignoreFieldList.addAll(diffIgnoreFieldList);
        List<String> prefixListExcludeDutyOrg = StaffEntryTempHelperEnum.getAllPrefix();
        for (String prefix : prefixListExcludeDutyOrg) {
            for (String commonIgnoreField : commonIgnoreFieldList) {
                ignoreFieldList.add(prefix + commonIgnoreField);
            }
        }
    }
}

