/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.service.impl.staff.AbstractOrgStaffSaveService;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

public class DutyOrgInfoSaveChain
extends AbstractOrgStaffSaveService {
    private Map<String, DynamicObject> dutyStructLongNumberMap;

    public DutyOrgInfoSaveChain(DynamicObject[] staffDynArr) {
        super(staffDynArr, "haos_dutyorgdetail", "aentryentity");
        this.staffIdVsEntryDataFromDBMap = this.getStaffInfoByStaffIdList(null);
    }

    public Map<String, DynamicObject> getDutyStructLongNumberMap() {
        return this.dutyStructLongNumberMap;
    }

    @Override
    protected void beforeInvokeStaff(DynamicObject[] staffDynArr) {
        for (DynamicObject staffDyn : staffDynArr) {
            long staffId = staffDyn.getLong("id");
            List entryDataFromDBList = (List)this.staffIdVsEntryDataFromDBMap.get(staffId);
            HashMap boEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)entryDataFromDBList)) {
                for (DynamicObject entryData : entryDataFromDBList) {
                    String dataStatus = entryData.getString("datastatus");
                    String dutyOrgBoId = entryData.getString("dutyorg.boid");
                    if (EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue().equals(dataStatus)) {
                        this.invalidIdList.add(dutyOrgBoId);
                    }
                    boEntryIdMap.put(dutyOrgBoId, entryData.getLong("id"));
                }
            }
            DynamicObjectCollection dutyOrgEntryCol = staffDyn.getDynamicObjectCollection(this.entryName);
            this.setEntryField("adutyorg.boid", 0L, dutyOrgEntryCol, boEntryIdMap);
            this.dutyStructLongNumberMap = dutyOrgEntryCol.stream().collect(Collectors.toMap(dyn -> dyn.getString("astructlongnumber"), dyn -> dyn, (v1, v2) -> v1));
        }
    }

    @Override
    protected void afterInvokeStaff(List<StaffHisParamBO> staffHisParamBOs) {
    }

    @Override
    protected void saveTempStaffInfo(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        ArrayList dutyOrgHisInfoList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList toDeleteStaffIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject staffDyn : staffDynArr) {
            DynamicObjectCollection dutyOrgInfos = staffDyn.getDynamicObjectCollection(this.entryName);
            if (CollectionUtils.isEmpty((Collection)dutyOrgInfos)) {
                toDeleteStaffIdList.add(staffDyn.getLong("id"));
            }
            DynamicObjectCollection dutyOrgInfoNew = StaffCommonService.removePrefix(dutyOrgInfos, this.entityName);
            dutyOrgInfoNew.forEach(dyn -> dyn.set("staff", (Object)staffDyn));
            dutyOrgHisInfoList.addAll(dutyOrgInfoNew);
        }
        if (!CollectionUtils.isEmpty((Collection)dutyOrgHisInfoList)) {
            staffHisParamBOs.add(new StaffHisParamBO(this.entityName, dutyOrgHisInfoList));
        }
        if (!CollectionUtils.isEmpty((Collection)toDeleteStaffIdList)) {
            QFilter staffIdFilter = new QFilter("staff", "in", (Object)toDeleteStaffIdList);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_dutyorgdetail");
            DynamicObject[] curDynArr = helper.query("vid", new QFilter[]{staffIdFilter});
            List vidList = Arrays.stream(curDynArr).map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
            helper.deleteByFilter(new QFilter[]{staffIdFilter});
            HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("haos_dutyorgdetailhis");
            QFilter vidFilter = new QFilter("id", "in", vidList);
            hisHelper.deleteByFilter(new QFilter[]{vidFilter});
        }
    }
}

