/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.service.impl.staff.AbstractUseStaffService;
import kd.hr.haos.business.domain.service.staff.IPersonChangeEventService;
import kd.hr.haos.business.util.StaffActivityHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PersonChangeEventServiceImpl
extends AbstractUseStaffService
implements IPersonChangeEventService,
OrgStaffConstants {
    protected HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_personchangeevent");

    @Override
    public void save(List<DynamicObject> personChangeEventList) {
        this.serviceHelper.save(personChangeEventList.toArray(new DynamicObject[0]));
    }

    @Override
    public DynamicObject[] queryByBizBillIds(List<Long> bizBillIds) {
        QFilter billIdsFilter = new QFilter("perevent", "in", bizBillIds);
        DynamicObject[] events = this.serviceHelper.queryOriginalArray("id,staffperson.id, orgusestaffdetail.id, changeevent.id ,perevent", new QFilter[]{billIdsFilter});
        List<Long> staffPersonIdList = Arrays.stream(events).map(event -> event.getLong("staffperson.id")).collect(Collectors.toList());
        List<Long> staffDetailIdList = Arrays.stream(events).map(event -> event.getLong("orgusestaffdetail.id")).collect(Collectors.toList());
        DynamicObject[] staffPersons = PersonStaffInfoRepository.getInstance().queryById(staffPersonIdList);
        DynamicObject[] staffDetails = OrgUseStaffDetailRepository.getInstance().queryOrgUseStaffByUidList(staffDetailIdList);
        Map<Long, DynamicObject> personIdToDynMap = Arrays.stream(staffPersons).collect(Collectors.toMap(person -> person.getLong("id"), person -> person));
        Map<Long, DynamicObject> staffDetailIdToDynMap = Arrays.stream(staffDetails).collect(Collectors.toMap(detail -> detail.getLong("id"), detail -> detail));
        Map<Long, DynamicObject> staffActivitydToDynMap = StaffActivityHelper.getStaffActivityIdToDynMap();
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)bizBillIds.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_personchangeevent");
        for (DynamicObject event2 : events) {
            DynamicObject eventNew = new DynamicObject((DynamicObjectType)dataEntityType);
            eventNew.set("id", (Object)event2.getLong("id"));
            eventNew.set("staffperson", (Object)personIdToDynMap.get(event2.getLong("staffperson.id")));
            eventNew.set("orgusestaffdetail", (Object)staffDetailIdToDynMap.get(event2.getLong("orgusestaffdetail.id")));
            eventNew.set("changeevent", (Object)staffActivitydToDynMap.get(event2.getLong("changeevent.id")));
            eventNew.set("perevent", (Object)event2.getLong("perevent"));
            eventList.add(eventNew);
        }
        return eventList.toArray(new DynamicObject[0]);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        QFilter idsFilter = new QFilter("id", "in", ids);
        this.serviceHelper.deleteByFilter(new QFilter[]{idsFilter});
    }

    @Override
    public Map<Long, Map<String, DynamicObject>> getDepEmpIdToReleasingDataMap(List<Long> depEmpIdList) {
        DynamicObject[] orgUseStaffDetails = OrgUseStaffDetailRepository.getInstance().queryAllOrgUseStaffByPersonStaffInfoIds(depEmpIdList, new String[]{"3", "4"});
        List orgUseStaffDetailIdList = Arrays.stream(orgUseStaffDetails).map(orgUseStaffDetail -> orgUseStaffDetail.getLong("id")).collect(Collectors.toList());
        QFilter orgUseStaffFilter = new QFilter("orgusestaffdetail", "in", orgUseStaffDetailIdList);
        DynamicObject[] events = this.serviceHelper.query("id,perevent,changeevent,effdt,orgusestaffdetail", new QFilter[]{orgUseStaffFilter}, "effdt desc,id desc");
        Map<Long, DynamicObject> orgUseStaffIdToEventMap = Arrays.stream(events).collect(Collectors.toMap(event -> event.getLong("orgusestaffdetail.id"), event -> event));
        HashMap depEmpIdToReleasingDataMap = Maps.newHashMapWithExpectedSize((int)orgUseStaffDetails.length);
        for (DynamicObject detail : orgUseStaffDetails) {
            DynamicObject event2;
            Long id = detail.getLong("id");
            Long depEmpId = detail.getLong("orgperson_id");
            Map releaseingData = (Map)depEmpIdToReleasingDataMap.get(depEmpId);
            if (releaseingData == null) {
                releaseingData = Maps.newHashMapWithExpectedSize((int)8);
            }
            if ((event2 = orgUseStaffIdToEventMap.get(id)) == null) continue;
            String number = event2.getDynamicObject("changeevent").getString("number");
            if (!releaseingData.containsKey(number)) {
                releaseingData.put(number, event2);
            }
            depEmpIdToReleasingDataMap.put(depEmpId, releaseingData);
        }
        return depEmpIdToReleasingDataMap;
    }

    @Override
    public DynamicObject[] queryByBizStaffPersonAndChangeEventId(List<Long> staffPersonIdList, Long changeEventId) {
        QFilter filter = new QFilter("staffperson.id", "in", staffPersonIdList);
        filter.and(new QFilter("changeevent.id", "=", (Object)changeEventId));
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }
}

