/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.staff.IStaffRuleConfigService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.util.ConcurrentIdCreator;
import kd.hr.haos.business.util.OrgMetaDataServiceHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class StaffRuleConfigServiceImpl
implements IStaffRuleConfigService,
OrgStaffConstants,
OrgStaffRuleConfigConstants {
    private static final Log logger = LogFactory.getLog(StaffRuleConfigServiceImpl.class);
    private ConcurrentIdCreator concurrentIdCreator = new ConcurrentIdCreator();

    @Override
    public void saveStaffRuleConfigForTask() {
        if (!OrgMetaDataServiceHelper.isMetaDataExist("haos_staff")) {
            return;
        }
        DynamicObject[] enablingAndEnableStaffDyns = StaffRepository.getInstance().queryEnabingAndEnableStaffDyn();
        Set orgIdSet = Arrays.stream(enablingAndEnableStaffDyns).map(dyn -> dyn.getLong("org.id")).collect(Collectors.toSet());
        logger.info("StaffRuleConfigServiceImpl#saveStaffRuleConfigForTask\uff1a orgIdSet={}", orgIdSet);
        List<Long> needSaveStaffIdList = this.getNeedSaveStaffId(enablingAndEnableStaffDyns);
        logger.info("StaffRuleConfigServiceImpl#saveStaffRuleConfigForTask\uff1aneedSaveStaffIdList={}", needSaveStaffIdList);
        List<DynamicObject> needSaveStaffDyns = this.getNeedSaveStaffDyns(enablingAndEnableStaffDyns);
        logger.info("StaffRuleConfigServiceImpl#saveStaffRuleConfigForTask\uff1aneedSaveStaffDynsListId={}", needSaveStaffDyns.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
        DynamicObject[] useOrgDetailDyns = UseOrgDetailRepository.getInstance().queryUseOrgDynArrByIdList(needSaveStaffIdList);
        Map staffIdVsUseOrgBoIdMap = Arrays.stream(useOrgDetailDyns).filter(dyn -> dyn.getLong("pid") == 0L).collect(Collectors.groupingBy(dyn -> dyn.getLong("staff.id"), Collectors.mapping(dy -> dy.getLong("useorg.boid"), Collectors.toList())));
        QFilter orgIdFilter = new QFilter("org", "in", orgIdSet);
        DynamicObject[] ruleConfigDyns = StaffRuleConfigRepository.getInstance().loadRuleConfigDynArray(new QFilter[]{orgIdFilter});
        Map<String, DynamicObject> orgIdYearVsRuleConfigDynMap = Arrays.stream(ruleConfigDyns).collect(Collectors.toMap(dyn -> "" + dyn.getLong("org.id") + HRDateTimeUtils.getYear((Date)dyn.getDate("year")), dyn -> dyn, (o1, o2) -> o2));
        ArrayList<Object[]> insertStaffRuleConfigDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateStaffRuleConfigDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertStaffRuleConfigEntryDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertStaffRuleConfigEntryOrgDataList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertStaffRuleConfigPermEntryOrgDataList = new ArrayList<Object[]>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        for (DynamicObject staffDyn : needSaveStaffDyns) {
            Long staffRuleConfigEntryId;
            long staffRuleConfigId;
            long staffId = staffDyn.getLong("id");
            List<Long> staffRootOrgIdList = staffIdVsUseOrgBoIdMap.get(staffId);
            if (CollectionUtils.isEmpty(staffRootOrgIdList)) {
                logger.info("StaffRuleConfigServiceImpl#saveStaffRuleConfigForTask\uff1astaffRootOrgIdList empty");
                continue;
            }
            DynamicObject orgDyn = staffDyn.getDynamicObject("org");
            if (Objects.isNull(orgDyn)) continue;
            Date year = staffDyn.getDate("year");
            String key = "" + orgDyn.getLong("id") + HRDateTimeUtils.getYear((Date)year);
            DynamicObject ruleConfigDynFromDB = orgIdYearVsRuleConfigDynMap.get(key);
            if (Objects.nonNull(ruleConfigDynFromDB)) {
                staffRuleConfigId = ruleConfigDynFromDB.getLong("id");
                this.buildRuleConfigUpdateParam(updateStaffRuleConfigDataList, currUserId, now, staffDyn, ruleConfigDynFromDB);
                staffRuleConfigEntryId = this.buildConfigEntryInsertParam(insertStaffRuleConfigEntryDataList, staffDyn, staffRuleConfigId);
                this.buildConfigEntryOrgInsertParam(insertStaffRuleConfigEntryOrgDataList, staffRootOrgIdList, staffRuleConfigEntryId);
                this.buildConfigPermEntryOrgInsertParam(insertStaffRuleConfigPermEntryOrgDataList, staffRootOrgIdList, staffRuleConfigId);
                continue;
            }
            staffRuleConfigId = this.concurrentIdCreator.getId();
            this.buildRuleConfigInsertParam(insertStaffRuleConfigDataList, currUserId, now, staffDyn, staffRuleConfigId);
            staffRuleConfigEntryId = this.buildConfigEntryInsertParam(insertStaffRuleConfigEntryDataList, staffDyn, staffRuleConfigId);
            this.buildConfigEntryOrgInsertParam(insertStaffRuleConfigEntryOrgDataList, staffRootOrgIdList, staffRuleConfigEntryId);
            this.buildConfigPermEntryOrgInsertParam(insertStaffRuleConfigPermEntryOrgDataList, staffRootOrgIdList, staffRuleConfigId);
        }
        String insertStaffConfigSql = "insert into t_haos_staffruleconfig(fid, fyear, forgid, fstaffcycleid, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fstatus, fenable, fissyspreset, findex, fmasterid) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        if (!CollectionUtils.isEmpty(insertStaffRuleConfigDataList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)insertStaffConfigSql, insertStaffRuleConfigDataList);
        }
        String updateStaffConfigSql = "update t_haos_staffruleconfig set fstaffcycleid = ?, fmodifierid = ?, fmodifytime = ?, fstatus = ?, fenable = ?, fissyspreset = ?, findex = ? where fid = ?";
        if (!CollectionUtils.isEmpty(updateStaffRuleConfigDataList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)updateStaffConfigSql, updateStaffRuleConfigDataList);
        }
        String insertStaffConfigEntrySql = "insert into t_haos_staffruleentry(fentryid, fid, fincludesub, fstaffprojectid, frefstaffid, fseq) values (?,?,?,?,?,?)";
        if (!CollectionUtils.isEmpty(insertStaffRuleConfigEntryDataList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)insertStaffConfigEntrySql, insertStaffRuleConfigEntryDataList);
        }
        String insertStaffConfigEntryOrgSql = "insert into t_haos_staffruleorg(fpkid, fentryid, fbasedataid) values(?, ?, ?)";
        if (!CollectionUtils.isEmpty(insertStaffRuleConfigEntryOrgDataList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)insertStaffConfigEntryOrgSql, insertStaffRuleConfigEntryOrgDataList);
        }
        String insertStaffConfigPermEntrySql = "insert into t_haos_stafforgpermentry(fid, fentryid, fseq, fstaffruleorgpermid) values(?, ?, ?, ?)";
        if (!CollectionUtils.isEmpty(insertStaffRuleConfigPermEntryOrgDataList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)insertStaffConfigPermEntrySql, insertStaffRuleConfigPermEntryOrgDataList);
        }
    }

    private void buildConfigPermEntryOrgInsertParam(List<Object[]> insertStaffRuleConfigPermEntryOrgDataList, List<Long> staffRootOrgIdList, long staffRuleConfigId) {
        for (int i = 0; i < staffRootOrgIdList.size(); ++i) {
            Object[] entryOrgInsertParamObject = new Object[]{staffRuleConfigId, this.concurrentIdCreator.getId(), i, staffRootOrgIdList.get(i)};
            insertStaffRuleConfigPermEntryOrgDataList.add(entryOrgInsertParamObject);
        }
    }

    private void buildConfigEntryOrgInsertParam(List<Object[]> insertStaffRuleConfigEntryOrgDataList, List<Long> staffRootOrgIdList, Long staffRuleConfigEntryId) {
        for (int i = 0; i < staffRootOrgIdList.size(); ++i) {
            Object[] entryOrgInsertParamObject = new Object[]{this.concurrentIdCreator.getId(), staffRuleConfigEntryId, staffRootOrgIdList.get(i)};
            insertStaffRuleConfigEntryOrgDataList.add(entryOrgInsertParamObject);
        }
    }

    private Long buildConfigEntryInsertParam(List<Object[]> insertStaffRuleConfigEntryDataList, DynamicObject staffDyn, long staffRuleConfigId) {
        Long staffRuleConfigEntryId = this.concurrentIdCreator.getId();
        Object[] entryInsertParamObject = new Object[]{staffRuleConfigEntryId, staffRuleConfigId, "1", staffDyn.getLong("staffproject.id"), staffDyn.getLong("id"), 0};
        insertStaffRuleConfigEntryDataList.add(entryInsertParamObject);
        return staffRuleConfigEntryId;
    }

    private void buildRuleConfigInsertParam(List<Object[]> insertStaffRuleConfigDataList, long currUserId, Date now, DynamicObject staffDyn, long staffRuleConfigId) {
        Object[] ruleConfigInsertParamObject = new Object[]{staffRuleConfigId, staffDyn.getDate("year"), staffDyn.getLong("org.id"), staffDyn.getLong("staffcycle.id"), currUserId, now, currUserId, now, "C", "1", "0", 0, staffRuleConfigId};
        insertStaffRuleConfigDataList.add(ruleConfigInsertParamObject);
    }

    private void buildRuleConfigUpdateParam(List<Object[]> updateStaffRuleConfigDataList, long currUserId, Date now, DynamicObject staffDyn, DynamicObject ruleConfigDynFromDB) {
        Object[] ruleConfigUpdateParamObject = new Object[]{staffDyn.getLong("staffcycle.id"), currUserId, now, "C", "1", "0", 0, ruleConfigDynFromDB.getLong("id")};
        updateStaffRuleConfigDataList.add(ruleConfigUpdateParamObject);
    }

    private DynamicObjectCollection buildStaffRuleOrgMulBaseData(Map<Long, List<Long>> staffIdVsUseOrgBoIdMap, Long staffId, DynamicObject ruleConfigEntryDyn) {
        DynamicObjectCollection staffRuleOrgDynCol = ruleConfigEntryDyn.getDynamicObjectCollection("staffruleorg");
        DynamicObjectType entryType = staffRuleOrgDynCol.getDynamicObjectType();
        List<Long> adminOrgBoIdList = staffIdVsUseOrgBoIdMap.get(staffId);
        for (Long adminOrgBoId : adminOrgBoIdList) {
            HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
            DynamicObject adminOrgDyn = adminOrgHelper.generateEmptyDynamicObject();
            adminOrgDyn.set("id", (Object)adminOrgBoId);
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)adminOrgDyn);
            staffRuleOrgDynCol.add((Object)row);
        }
        return staffRuleOrgDynCol;
    }

    private List<Long> getNeedSaveStaffId(DynamicObject[] enablingAndEnableStaffDyns) {
        List<Long> enablingAndEnableStaffId = Arrays.stream(enablingAndEnableStaffDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        List<Long> entryExistStaffId = this.getEntryExistStaffIdList();
        enablingAndEnableStaffId.removeAll(entryExistStaffId);
        return enablingAndEnableStaffId;
    }

    private List<DynamicObject> getNeedSaveStaffDyns(DynamicObject[] enablingAndEnableStaffDyns) {
        List<Long> entryExistStaffId = this.getEntryExistStaffIdList();
        return Arrays.stream(enablingAndEnableStaffDyns).filter(dyn -> !entryExistStaffId.contains(dyn.getLong("id"))).collect(Collectors.toList());
    }

    private List<Long> getEntryExistStaffIdList() {
        String selectStaffEntrySql = "select frefstaffid from t_haos_staffruleentry where 1 = 1";
        ORM orm = ORM.create();
        List<Object> entryExistStaffId = Lists.newArrayListWithExpectedSize((int)16);
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"haos_staffEntryAllSearch", (DBRoute)new DBRoute("hr"), (String)selectStaffEntrySql, null);){
            DynamicObjectCollection retDynCol = orm.toPlainDynamicObjectCollection(dataSet);
            entryExistStaffId = retDynCol.stream().filter(dyn -> dyn.getLong("frefstaffid") != 0L).map(retDyn -> retDyn.getLong("frefstaffid")).collect(Collectors.toList());
        }
        return entryExistStaffId;
    }
}

