/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.structproject;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.domain.service.structproject.IStructProjectService;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;

public class StructProjectServiceImpl
implements IStructProjectService {
    private StructProjectRepository structProjectRepository = StructProjectRepository.getInstance();

    @Override
    public DynamicObject[] queryStructProjectById(List<Long> structProjectIds) {
        String selectField = "id, number, name, otclassify, org, rootorg, isincludevirtualorg, issyspreset, description, enable";
        return this.structProjectRepository.queryByPks(selectField, structProjectIds);
    }

    @Override
    public DynamicObject[] queryAllStructProject() {
        String selectField = "id, number, name, otclassify, org, rootorg, isincludevirtualorg, issyspreset, description, enable";
        return this.structProjectRepository.queryAllStructProject(selectField);
    }

    @Override
    public Long getOldRootOrgId(Long structId) {
        DynamicObject structProject = StructProjectRepository.getInstance().queryByPk("rootorg", structId);
        return structProject.getLong("rootorg.id");
    }

    @Override
    public void doWithStructModify(DynamicObject structProject, long changeType) {
        if ("10".equals(structProject.getString("enable"))) {
            this.saveOtherStruct(structProject, "10", "modify", changeType);
        } else {
            this.saveOtherStruct(structProject, "1", "modify", changeType);
        }
    }

    @Override
    public void doWithAddNew(DynamicObject structProject) {
        this.saveOtherStruct(structProject, structProject.getString("enable"), "new", 1010L);
    }

    @Override
    public boolean isRootOrgMaintain(DynamicObject structProject) {
        Long structId = structProject.getLong("id");
        return AdminOrgStructRepository.getInstance().isRootOrgMaintain(structId);
    }

    private void saveOtherStruct(DynamicObject structProject, String enable, String saveType, long changeType) {
        OtherStructEntity otherStructEntity;
        Long rootOrgId = structProject.getLong("rootorg.id");
        DynamicObject orgDy = null;
        if ("2".equals(structProject.getString("roottype"))) {
            if (rootOrgId.equals(0L)) {
                rootOrgId = ORM.create().genLongId("haos_adminorgdetail");
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"haos_structproject");
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
                dynamicObject.set("id", (Object)rootOrgId);
                structProject.set("rootorg", (Object)dynamicObject);
            }
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_virtualorg");
            DynamicObjectType bosOrgType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
            orgDy = new DynamicObject((DynamicObjectType)dynamicObjectType);
            orgDy.set("orgid", (Object)rootOrgId);
            orgDy.set("number", structProject.get("rootnumber"));
            orgDy.set("name", structProject.get("rootname"));
            orgDy.set("description", structProject.get("rootdescription"));
            DynamicObject bosOrgDy = new DynamicObject(bosOrgType);
            bosOrgDy.set("id", (Object)structProject.getLong("org.id"));
            orgDy.set("org", (Object)bosOrgDy);
        }
        long structProjectId = structProject.getLong("id");
        if (changeType != 0L) {
            otherStructEntity = new OtherStructEntity(new OtherStructVO(rootOrgId, changeType, null));
        } else {
            otherStructEntity = new OtherStructEntity();
            otherStructEntity.setDeleteFlag(Boolean.FALSE);
        }
        if (orgDy != null) {
            otherStructEntity.setDyList(Lists.newArrayList((Object[])new DynamicObject[]{orgDy}));
        }
        otherStructEntity.setStructProjectId(structProjectId);
        otherStructEntity.setEffectDate(structProject.getDate("effdt"));
        if ("modify".equals(saveType)) {
            DynamicObject dynamicObject = StructProjectRepository.getInstance().queryOneByStructProjectId("isincludevirtualorg", structProjectId);
            otherStructEntity.setIncludeVirtual(dynamicObject.getBoolean("isincludevirtualorg"));
            if ("10".equals(enable) && (1020L == changeType || 0L == changeType)) {
                otherStructEntity.setDeleteAll(false);
            }
        }
        otherStructEntity.setEnable(enable);
        OtherStructService otherStructService = new OtherStructService(otherStructEntity);
        otherStructService.saveOtherStruct();
    }

    @Override
    public void doWithEnable(DynamicObject[] dataEntities) {
        if (dataEntities != null && dataEntities.length > 0) {
            Set<Long> structProjectIds = Arrays.stream(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            List<Long> enablingIds = this.structProjectRepository.queryEnablingByIds(structProjectIds);
            new OtherStructService().enabledByStructProject(new HashSet<Long>(enablingIds));
        }
    }

    @Override
    public void delete(Long[] ids) {
        this.structProjectRepository.deleteByIds(ids);
    }
}

