/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AdminOrgSyncTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AdminOrgSyncTask.class);
    private static final String SYNC_TYPE = "synctype";
    private static final String EXECUTE_BODY = "executebody";
    private static final String SYNC_STATUS = "syncstatus";
    private static final String RETRY_COUNT = "retrycount";
    private static final String HAOS_SYNCORG_FAILLOG = "haos_syncorgfaillog";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("kd.hr.haos.business.init.AdminOrgSyncTask start: {}", (Object)((Object)((Object)this)).getClass().getName());
        long startTime = System.currentTimeMillis();
        this.adminOrgSyncTask(map);
        LOG.info("kd.hr.haos.business.init.AdminOrgSyncTask end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void adminOrgSyncTask(Map<String, Object> map) {
        String syncType;
        switch (syncType = map.get(SYNC_TYPE).toString()) {
            case "1": {
                this.syncAddOrg(syncType);
                break;
            }
            case "2": {
                this.syncUpdateOrg(syncType);
                break;
            }
            case "3": {
                this.syncFreezeOrg(syncType);
                break;
            }
            default: {
                this.syncAddOrg("1");
                this.syncUpdateOrg("2");
                this.syncFreezeOrg("3");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddOrg(String syncType) {
        HashMap<Long, OrgParam> syncOrgIdOrgParamMap = new HashMap<Long, OrgParam>();
        HashMap<Long, DynamicObject> syncOrgIdSyncOrgMap = new HashMap<Long, DynamicObject>();
        List<OrgParam> orgParams = this.getSyncOrgParams(Collections.singletonList(syncType), syncOrgIdOrgParamMap, syncOrgIdSyncOrgMap);
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.add(orgParams);
        }
        catch (Exception e) {
            LOG.error("kd.hr.haos.business.init.AdminOrgSyncTask.syncAddOrg Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "kd.hr.haos.business.init.AdminOrgSyncTask.syncAddOrg is end. cast=" + (end - start) + "ms";
            LOG.info(logInfo);
        }
        this.updateSyncOrgFailLog(syncOrgIdSyncOrgMap, syncOrgIdOrgParamMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdateOrg(String syncType) {
        HashMap<Long, OrgParam> syncOrgIdOrgParamMap = new HashMap<Long, OrgParam>();
        HashMap<Long, DynamicObject> syncOrgIdSyncOrgMap = new HashMap<Long, DynamicObject>();
        List<OrgParam> orgParams = this.getSyncOrgParams(Collections.singletonList(syncType), syncOrgIdOrgParamMap, syncOrgIdSyncOrgMap);
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.update(orgParams);
        }
        catch (Exception e) {
            LOG.error("kd.hr.haos.business.init.AdminOrgSyncTask.syncUpdateOrg Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "kd.hr.haos.business.init.AdminOrgSyncTask.syncUpdateOrg is end. cast=" + (end - start) + "ms";
            LOG.info(logInfo);
        }
        this.updateSyncOrgFailLog(syncOrgIdSyncOrgMap, syncOrgIdOrgParamMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFreezeOrg(String syncType) {
        HashMap<Long, OrgParam> syncOrgIdOrgParamMap = new HashMap<Long, OrgParam>();
        HashMap<Long, DynamicObject> syncOrgIdSyncOrgMap = new HashMap<Long, DynamicObject>();
        List<OrgParam> orgParams = this.getSyncOrgParams(Collections.singletonList(syncType), syncOrgIdOrgParamMap, syncOrgIdSyncOrgMap);
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.freeze(orgParams);
        }
        catch (Exception e) {
            LOG.error("kd.hr.haos.business.init.AdminOrgSyncTask.syncFreezeOrg Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "kd.hr.haos.business.init.AdminOrgSyncTask.syncFreezeOrg is end. cast=" + (end - start) + "ms";
            LOG.info(logInfo);
        }
        this.updateSyncOrgFailLog(syncOrgIdSyncOrgMap, syncOrgIdOrgParamMap);
    }

    private List<OrgParam> getSyncOrgParams(List<String> syncTypes, Map<Long, OrgParam> syncOrgIdOrgParamMap, Map<Long, DynamicObject> syncOrgIdSyncOrgMap) {
        Object[] dynamicObjects = this.queryNeedSyncOrg(syncTypes);
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>();
        if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            Stream.of(dynamicObjects).forEach(dy -> {
                String executebody = dy.getString(EXECUTE_BODY);
                OrgParam orgParam = (OrgParam)SerializationUtils.fromJsonString((String)executebody, OrgParam.class);
                syncOrgIdSyncOrgMap.put(dy.getLong("id"), (DynamicObject)dy);
                OrgParam newOrgParam = this.generateOrgParam(orgParam);
                orgParams.add(newOrgParam);
                syncOrgIdOrgParamMap.put(dy.getLong("id"), newOrgParam);
            });
        }
        return orgParams;
    }

    private OrgParam generateOrgParam(OrgParam orgParam) {
        OrgParam newOrgParam = new OrgParam();
        newOrgParam.setId(orgParam.getId());
        newOrgParam.setCustomOrgId(orgParam.getCustomOrgId());
        newOrgParam.setName(orgParam.getName());
        newOrgParam.setNumber(orgParam.getNumber());
        newOrgParam.setParentId(orgParam.getParentId());
        newOrgParam.setDuty("01");
        newOrgParam.setYzjSync(true);
        newOrgParam.setDescription(orgParam.getDescription());
        return newOrgParam;
    }

    private DynamicObject[] queryNeedSyncOrg(List<String> syncTypes) {
        HRBaseServiceHelper syncOrgFailLogServiceHelper = new HRBaseServiceHelper(HAOS_SYNCORG_FAILLOG);
        QFilter syncTypeFilter = new QFilter(SYNC_TYPE, "in", syncTypes);
        QFilter syncStatusFilter = new QFilter(SYNC_STATUS, "in", Arrays.asList("R", "N"));
        QFilter retryCountFilter = new QFilter(RETRY_COUNT, "<=", (Object)3);
        return syncOrgFailLogServiceHelper.loadDynamicObjectArray(new QFilter[]{syncTypeFilter, syncStatusFilter, retryCountFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSyncOrgFailLog(Map<Long, DynamicObject> dys, Map<Long, OrgParam> orgParams) {
        ArrayList failDynList = new ArrayList();
        HRBaseServiceHelper syncOrgFailLogServiceHelper = new HRBaseServiceHelper(HAOS_SYNCORG_FAILLOG);
        orgParams.forEach((syncOrgId, orgParam) -> {
            DynamicObject dy = (DynamicObject)dys.get(syncOrgId);
            long retrycount = dy.getLong(RETRY_COUNT);
            dy.set(RETRY_COUNT, (Object)(retrycount + 1L));
            if (orgParam.isSuccess()) {
                dy.set(SYNC_STATUS, (Object)"S");
            } else {
                dy.set("errormsg", (Object)orgParam.getMsg());
                if (dy.getLong(RETRY_COUNT) > 3L) {
                    dy.set(SYNC_STATUS, (Object)"F");
                } else {
                    dy.set(SYNC_STATUS, (Object)"R");
                }
            }
            failDynList.add(dy);
        });
        try (TXHandle txHandle = TX.requiresNew();){
            syncOrgFailLogServiceHelper.update(failDynList.toArray(new DynamicObject[0]));
        }
    }
}

