/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.meta.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.hr.haos.business.meta.util.AppMenuInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class AppMenuUtil {
    private static final Log LOG = LogFactory.getLog(AppMenuUtil.class);

    public static void buildMenus(List<AppMenuElement> appMenus, AppMenuInfo appMenuInfo, String bizAppId) {
        String id = appMenuInfo.getId();
        Optional<AppMenuElement> opt = appMenus.stream().filter(val -> id.equals(val.getId())).findFirst();
        AppMenuElement appMenuElement = opt.isPresent() ? opt.get() : AppMetaServiceHelper.CreateBlankAppMenuElement();
        String permissionId = appMenuInfo.getPermissionId();
        String parentNodeId = appMenuInfo.getParentNodeId();
        String menuId = String.valueOf(DBServiceHelper.genGlobalLongId());
        appMenuElement.setId(menuId);
        HashMap values = new HashMap();
        appMenuInfo.getMenuName().forEach((key, value) -> values.put(key, value));
        appMenuElement.setName(LocaleString.fromMap(values));
        appMenuElement.setFormName(appMenuInfo.getFormName());
        appMenuElement.setFormId(appMenuInfo.getFormId());
        appMenuElement.setFormNumber(appMenuInfo.getFormNumber());
        String visible = UUID.randomUUID().toString().replace("-", "");
        String menuNumber = visible.substring(0, 10);
        appMenuElement.setNumber(menuNumber);
        appMenuElement.setDescription(new LocaleString(appMenuInfo.getDescription()));
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            appMenuElement.setParentId(bizAppId);
        } else {
            appMenuElement.setParentId(parentNodeId);
        }
        appMenuElement.setSeq((short)appMenus.size());
        appMenuElement.setVectorImage(appMenuInfo.getVectorValue());
        appMenuElement.setIconShortcut(appMenuInfo.getShortCutEntrance());
        appMenuElement.setOpenType(appMenuInfo.getOpenType());
        if (StringUtils.isNotBlank((CharSequence)permissionId)) {
            appMenuElement.setPermission(permissionId);
        } else {
            appMenuElement.setPermission(null);
        }
        appMenuElement.setVisible(appMenuInfo.getVisible());
        appMenuElement.setParameterType(appMenuInfo.getParameterType());
        appMenuElement.setCaption(new LocaleString(appMenuInfo.getCaption()));
        appMenuElement.setParameter(appMenuInfo.getParameter());
        appMenuElement.setId(appMenuInfo.getId());
        appMenus.add(appMenuElement);
        if (!CollectionUtils.isEmpty(appMenuInfo.getChildren())) {
            List<AppMenuInfo> menuInfos = appMenuInfo.getChildren();
            for (int i = 0; i < menuInfos.size(); ++i) {
                AppMenuUtil.buildMenus(appMenus, menuInfos.get(i), bizAppId);
            }
        }
    }

    public static void handleRemoveMenus(List<AppMenuElement> appMenus, AppMenuInfo appMenuInfo) {
        if (CollectionUtils.isEmpty(appMenus) || appMenuInfo == null) {
            return;
        }
        boolean isDelete = appMenuInfo.isDelete();
        List<AppMenuInfo> childs = appMenuInfo.getChildren();
        HashSet<String> delIds = new HashSet<String>(childs != null ? childs.size() : 2);
        boolean has = false;
        if (!CollectionUtils.isEmpty(childs)) {
            for (AppMenuInfo menuInfo : childs) {
                String id = menuInfo.getId();
                if (HRStringUtils.isEmpty((String)id)) continue;
                if (isDelete || menuInfo.isDelete()) {
                    delIds.add(id);
                }
                if (has || menuInfo.isDelete()) continue;
                has = true;
            }
        }
        if (isDelete || !has) {
            delIds.add(appMenuInfo.getId());
        }
        LOG.info("delIds:{}", delIds);
        if (delIds.size() > 0) {
            appMenus.removeIf(val -> delIds.contains(val.getId()));
        }
    }
}

