/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.meta.util;

import java.util.LinkedList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.meta.StructClassHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hies.api.HRImExptTemplateServiceHelper;
import kd.hr.hies.api.dto.EntityFieldConfig;
import kd.hr.hies.api.dto.HRTemplate;

public class StructTypeIETempHelper {
    private static final Log LOG = LogFactory.getLog(StructTypeIETempHelper.class);
    private static final HRBaseServiceHelper ENTITY_HELPER = new HRBaseServiceHelper("hbp_entityobject");

    public static boolean addTemplate(DynamicObject structTypeDy) {
        String prefix = StructClassHelper.getPrefixNumberByStructTypeId(structTypeDy.getLong("id"));
        LinkedList<HRTemplate> templates = new LinkedList<HRTemplate>();
        templates.add(StructTypeIETempHelper.createOrgTemplate(structTypeDy, prefix, true));
        templates.add(StructTypeIETempHelper.createOrgTemplate(structTypeDy, prefix, false));
        templates.add(StructTypeIETempHelper.createRoleTemplate(structTypeDy, prefix, true));
        templates.add(StructTypeIETempHelper.createRoleTemplate(structTypeDy, prefix, false));
        templates.add(StructTypeIETempHelper.createPersonTemplate(structTypeDy, prefix, true, true));
        templates.add(StructTypeIETempHelper.createPersonTemplate(structTypeDy, prefix, true, false));
        templates.add(StructTypeIETempHelper.createPersonTemplate(structTypeDy, prefix, false, true));
        templates.add(StructTypeIETempHelper.createPersonTemplate(structTypeDy, prefix, false, false));
        OperationResult result = HRImExptTemplateServiceHelper.addTemplate(templates);
        LOG.info("addTemplate_result:{}", (Object)result);
        return result != null && result.isSuccess();
    }

    private static HRTemplate createOrgTemplate(DynamicObject structTypeDy, String prefix, boolean isNew) {
        String type;
        String structTypeName = structTypeDy.getString("name");
        String metaNumber = "haos_cusadminorgteam_" + prefix;
        HRTemplate template = new HRTemplate();
        if (isNew) {
            template.setNumber(metaNumber + "_new");
            type = ResManager.loadKDString((String)"\u7ec4\u7ec7\u65b0\u589e", (String)"StructTypeIETempHelper_1", (String)"hrmp-haos-business", (Object[])new Object[0]);
            template.setName((ILocaleString)new LocaleString(structTypeName + type));
            template.setImporttype("new");
        } else {
            template.setNumber(metaNumber + "_update");
            type = ResManager.loadKDString((String)"\u7ec4\u7ec7\u66f4\u65b0", (String)"StructTypeIETempHelper_2", (String)"hrmp-haos-business", (Object[])new Object[0]);
            template.setName((ILocaleString)new LocaleString(structTypeName + type));
            template.setImporttype("update");
        }
        template.setMainentityuniqueval("number");
        template.setEntitytype("SE");
        template.setTmpltype("IMPT");
        DynamicObject entity = ENTITY_HELPER.generateEmptyDynamicObject();
        entity.set("id", (Object)metaNumber);
        template.setEntity(entity);
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_cusadminorgteam");
        DynamicObject org = orgHelper.generateEmptyDynamicObject();
        org.set("id", (Object)RequestContext.get().getOrgId());
        template.setOrgfield(org);
        LocaleString instruction = new LocaleString();
        instruction.setLocaleValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\r\n2\u3001\u5e26\u661f\u53f7\u201c*\u201d\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"StructTypeIETempHelper_0", (String)"hrmp-haos-business", (Object[])new Object[0]));
        template.setInstruction((ILocaleString)instruction);
        template.setAllocationpolicy("0");
        LinkedList<EntityFieldConfig> entityFieldConfigs = new LinkedList<EntityFieldConfig>();
        EntityFieldConfig numberField = new EntityFieldConfig();
        numberField.setEntityName(metaNumber);
        numberField.setParentEntityName(metaNumber);
        numberField.setFieldnumber("number");
        numberField.setIsmustinput(true);
        entityFieldConfigs.add(numberField);
        EntityFieldConfig nameField = new EntityFieldConfig();
        nameField.setEntityName(metaNumber);
        nameField.setParentEntityName(metaNumber);
        nameField.setFieldnumber("name");
        nameField.setIsmustinput(isNew);
        entityFieldConfigs.add(nameField);
        EntityFieldConfig parentField = new EntityFieldConfig();
        parentField.setEntityName(metaNumber);
        parentField.setParentEntityName(metaNumber);
        parentField.setFieldnumber("parent");
        parentField.setImptattr("number");
        parentField.setIsmustinput(isNew);
        entityFieldConfigs.add(parentField);
        EntityFieldConfig bsedField = new EntityFieldConfig();
        bsedField.setEntityName(metaNumber);
        bsedField.setParentEntityName(metaNumber);
        bsedField.setFieldnumber("bsed");
        bsedField.setIsmustinput(true);
        entityFieldConfigs.add(bsedField);
        EntityFieldConfig indexField = new EntityFieldConfig();
        indexField.setEntityName(metaNumber);
        indexField.setParentEntityName(metaNumber);
        indexField.setFieldnumber("index");
        entityFieldConfigs.add(indexField);
        EntityFieldConfig descriptionField = new EntityFieldConfig();
        descriptionField.setEntityName(metaNumber);
        descriptionField.setParentEntityName(metaNumber);
        descriptionField.setFieldnumber("description");
        entityFieldConfigs.add(descriptionField);
        template.setEntityFieldConfigs(entityFieldConfigs);
        return template;
    }

    private static HRTemplate createRoleTemplate(DynamicObject structTypeDy, String prefix, boolean isNew) {
        String type;
        String structTypeName = structTypeDy.getString("name");
        String metaNumber = "haos_customorole_" + prefix;
        HRTemplate template = new HRTemplate();
        if (isNew) {
            template.setNumber(metaNumber + "_new");
            type = ResManager.loadKDString((String)"\u89d2\u8272\u65b0\u589e", (String)"StructTypeIETempHelper_3", (String)"hrmp-haos-business", (Object[])new Object[0]);
            template.setName((ILocaleString)new LocaleString(structTypeName + type));
            template.setImporttype("new");
        } else {
            template.setNumber(metaNumber + "_update");
            type = ResManager.loadKDString((String)"\u89d2\u8272\u66f4\u65b0", (String)"StructTypeIETempHelper_4", (String)"hrmp-haos-business", (Object[])new Object[0]);
            template.setName((ILocaleString)new LocaleString(structTypeName + type));
            template.setImporttype("update");
        }
        template.setMainentityuniqueval("orgteam,number");
        template.setEntitytype("SE");
        template.setTmpltype("IMPT");
        DynamicObject entity = ENTITY_HELPER.generateEmptyDynamicObject();
        entity.set("id", (Object)metaNumber);
        template.setEntity(entity);
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_cusadminorgteam");
        DynamicObject org = orgHelper.generateEmptyDynamicObject();
        org.set("id", (Object)RequestContext.get().getOrgId());
        template.setOrgfield(org);
        LocaleString instruction = new LocaleString();
        instruction.setLocaleValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\r\n2\u3001\u5e26\u661f\u53f7\u201c*\u201d\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"StructTypeIETempHelper_0", (String)"hrmp-haos-business", (Object[])new Object[0]));
        template.setInstruction((ILocaleString)instruction);
        template.setAllocationpolicy("0");
        LinkedList<EntityFieldConfig> entityFieldConfigs = new LinkedList<EntityFieldConfig>();
        EntityFieldConfig numberField = new EntityFieldConfig();
        numberField.setEntityName(metaNumber);
        numberField.setParentEntityName(metaNumber);
        numberField.setFieldnumber("number");
        numberField.setIsmustinput(true);
        entityFieldConfigs.add(numberField);
        EntityFieldConfig parentField = new EntityFieldConfig();
        parentField.setEntityName(metaNumber);
        parentField.setParentEntityName(metaNumber);
        parentField.setFieldnumber("orgteam");
        parentField.setImptattr("number");
        parentField.setIsmustinput(true);
        entityFieldConfigs.add(parentField);
        EntityFieldConfig nameField = new EntityFieldConfig();
        nameField.setEntityName(metaNumber);
        nameField.setParentEntityName(metaNumber);
        nameField.setFieldnumber("name");
        nameField.setIsmustinput(isNew);
        entityFieldConfigs.add(nameField);
        EntityFieldConfig indexField = new EntityFieldConfig();
        indexField.setEntityName(metaNumber);
        indexField.setParentEntityName(metaNumber);
        indexField.setFieldnumber("index");
        entityFieldConfigs.add(indexField);
        template.setEntityFieldConfigs(entityFieldConfigs);
        return template;
    }

    private static HRTemplate createPersonTemplate(DynamicObject structTypeDy, String prefix, boolean isNew, boolean isInner) {
        String type;
        String structTypeName = structTypeDy.getString("name");
        String metaNumber = "haos_cusempposorgrel_" + prefix;
        HRTemplate template = new HRTemplate();
        if (isNew) {
            if (isInner) {
                template.setNumber(metaNumber + "_innew");
                type = ResManager.loadKDString((String)"\u5185\u90e8\u4eba\u5458\u65b0\u589e", (String)"StructTypeIETempHelper_5", (String)"hrmp-haos-business", (Object[])new Object[0]);
                template.setName((ILocaleString)new LocaleString(structTypeName + type));
                template.setMainentityuniqueval("depemp,orgteam,customorole");
            } else {
                template.setNumber(metaNumber + "_outnew");
                type = ResManager.loadKDString((String)"\u5916\u90e8\u4eba\u5458\u65b0\u589e", (String)"StructTypeIETempHelper_7", (String)"hrmp-haos-business", (Object[])new Object[0]);
                template.setName((ILocaleString)new LocaleString(structTypeName + type));
                template.setMainentityuniqueval("outpernumber,orgteam,customorole");
            }
            template.setImporttype("new");
        } else {
            if (isInner) {
                template.setNumber(metaNumber + "_inupdate");
                type = ResManager.loadKDString((String)"\u5185\u90e8\u4eba\u5458\u66f4\u65b0", (String)"StructTypeIETempHelper_6", (String)"hrmp-haos-business", (Object[])new Object[0]);
                template.setName((ILocaleString)new LocaleString(structTypeName + type));
                template.setMainentityuniqueval("depemp,orgteam,customorole");
            } else {
                template.setNumber(metaNumber + "_outupdate");
                type = ResManager.loadKDString((String)"\u5916\u90e8\u4eba\u5458\u66f4\u65b0", (String)"StructTypeIETempHelper_8", (String)"hrmp-haos-business", (Object[])new Object[0]);
                template.setName((ILocaleString)new LocaleString(structTypeName + type));
                template.setMainentityuniqueval("outperson,orgteam,customorole");
            }
            template.setImporttype("update");
        }
        template.setEntitytype("SE");
        template.setTmpltype("IMPT");
        DynamicObject entity = ENTITY_HELPER.generateEmptyDynamicObject();
        entity.set("id", (Object)metaNumber);
        template.setEntity(entity);
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_cusadminorgteam");
        DynamicObject org = orgHelper.generateEmptyDynamicObject();
        org.set("id", (Object)RequestContext.get().getOrgId());
        template.setOrgfield(org);
        LocaleString instruction = new LocaleString();
        instruction.setLocaleValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002\r\n2\u3001\u5e26\u661f\u53f7\u201c*\u201d\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"StructTypeIETempHelper_0", (String)"hrmp-haos-business", (Object[])new Object[0]));
        template.setInstruction((ILocaleString)instruction);
        template.setAllocationpolicy("0");
        LinkedList<EntityFieldConfig> entityFieldConfigs = new LinkedList<EntityFieldConfig>();
        EntityFieldConfig orgteamField = new EntityFieldConfig();
        orgteamField.setEntityName(metaNumber);
        orgteamField.setParentEntityName(metaNumber);
        orgteamField.setFieldnumber("orgteam");
        orgteamField.setImptattr("number");
        orgteamField.setIsmustinput(true);
        entityFieldConfigs.add(orgteamField);
        EntityFieldConfig customoroleField = new EntityFieldConfig();
        customoroleField.setEntityName(metaNumber);
        customoroleField.setParentEntityName(metaNumber);
        customoroleField.setFieldnumber("customorole");
        customoroleField.setImptattr("number");
        customoroleField.setIsmustinput(true);
        entityFieldConfigs.add(customoroleField);
        if (isInner) {
            EntityFieldConfig depempField = new EntityFieldConfig();
            depempField.setEntityName(metaNumber);
            depempField.setParentEntityName(metaNumber);
            depempField.setFieldnumber("depemp");
            depempField.setImptattr("number");
            depempField.setIsmustinput(true);
            entityFieldConfigs.add(depempField);
        } else {
            if (isNew) {
                EntityFieldConfig numberField = new EntityFieldConfig();
                numberField.setEntityName(metaNumber);
                numberField.setParentEntityName(metaNumber);
                numberField.setFieldnumber("outpernumber");
                numberField.setIsmustinput(true);
                numberField.setFieldimportdesc((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u7528\u4e8e\u5224\u65ad\u5916\u90e8\u4eba\u5458\u552f\u4e00\u6027\u7684\u5173\u952e\u503c\u3002", (String)"StructTypeIETempHelper_9", (String)"hrmp-haos-business", (Object[])new Object[0])));
                entityFieldConfigs.add(numberField);
            } else {
                EntityFieldConfig outpersonField = new EntityFieldConfig();
                outpersonField.setEntityName(metaNumber);
                outpersonField.setParentEntityName(metaNumber);
                outpersonField.setFieldnumber("outperson");
                outpersonField.setImptattr("number");
                outpersonField.setIsmustinput(true);
                entityFieldConfigs.add(outpersonField);
            }
            EntityFieldConfig nameField = new EntityFieldConfig();
            nameField.setEntityName(metaNumber);
            nameField.setParentEntityName(metaNumber);
            nameField.setFieldnumber("name");
            nameField.setIsmustinput(isNew);
            entityFieldConfigs.add(nameField);
            EntityFieldConfig genderField = new EntityFieldConfig();
            genderField.setEntityName(metaNumber);
            genderField.setParentEntityName(metaNumber);
            genderField.setFieldnumber("gender");
            genderField.setImptattr("number");
            entityFieldConfigs.add(genderField);
            EntityFieldConfig phoneField = new EntityFieldConfig();
            phoneField.setEntityName(metaNumber);
            phoneField.setParentEntityName(metaNumber);
            phoneField.setFieldnumber("phone");
            phoneField.setIsmustinput(false);
            entityFieldConfigs.add(phoneField);
            EntityFieldConfig perdescField = new EntityFieldConfig();
            perdescField.setEntityName(metaNumber);
            perdescField.setParentEntityName(metaNumber);
            perdescField.setFieldnumber("perdesc");
            entityFieldConfigs.add(perdescField);
        }
        EntityFieldConfig ischargeField = new EntityFieldConfig();
        ischargeField.setEntityName(metaNumber);
        ischargeField.setParentEntityName(metaNumber);
        ischargeField.setFieldnumber("ischarge");
        entityFieldConfigs.add(ischargeField);
        EntityFieldConfig startdateField = new EntityFieldConfig();
        startdateField.setEntityName(metaNumber);
        startdateField.setParentEntityName(metaNumber);
        startdateField.setFieldnumber("startdate");
        startdateField.setIsmustinput(isNew);
        entityFieldConfigs.add(startdateField);
        EntityFieldConfig sysenddateField = new EntityFieldConfig();
        sysenddateField.setEntityName(metaNumber);
        sysenddateField.setParentEntityName(metaNumber);
        sysenddateField.setFieldnumber("sysenddate");
        sysenddateField.setIsmustinput(false);
        if (isNew) {
            sysenddateField.setFieldimportdesc((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5982\u679c\u6ca1\u6709\u586b\u5199\uff0c\u7cfb\u7edf\u5c06\u9ed8\u8ba4\u4e3a2999.12.31\u3002", (String)"StructTypeIETempHelper_10", (String)"hrmp-haos-business", (Object[])new Object[0])));
        }
        entityFieldConfigs.add(sysenddateField);
        EntityFieldConfig descriptionField = new EntityFieldConfig();
        descriptionField.setEntityName(metaNumber);
        descriptionField.setParentEntityName(metaNumber);
        descriptionField.setFieldnumber("description");
        entityFieldConfigs.add(descriptionField);
        EntityFieldConfig indexField = new EntityFieldConfig();
        indexField.setEntityName(metaNumber);
        indexField.setParentEntityName(metaNumber);
        indexField.setFieldnumber("index");
        entityFieldConfigs.add(indexField);
        template.setEntityFieldConfigs(entityFieldConfigs);
        return template;
    }
}

