/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.rpc;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.rpc.RPCConstants;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;

public class HRPIRPCServiceHelper
implements RPCConstants {
    private static final Log LOG = LogFactory.getLog(HRPIRPCServiceHelper.class);

    public static Map<Long, List<Map<String, Object>>> getPersonCountAndChangeInfo(Collection<Long> orgIds, Date queryDate) {
        int size = orgIds.size();
        Date date = HRDateTimeUtils.dayEquals((Date)new Date(), (Date)queryDate) ? HRDateTimeUtils.truncateDate((Date)new Date()) : queryDate;
        Map<Long, List<Map<String, Object>>> personResult = new HashMap<Long, List<Map<String, Object>>>(8);
        long start = System.currentTimeMillis();
        try {
            if (size < CHARGE_PERSON_MAX_THRESHOLD) {
                personResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargePersonByOrgId", (Object[])new Object[]{new ArrayList<Long>(orgIds), date});
                LOG.info("queryChargePersonByOrgId: {}, orgIds: {}, queryDate: {}", new Object[]{JSONObject.toJSONString((Object)LogPrivacyUtil.filterPrivacyProp(personResult, Collections.singletonList("headsculpture"))), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
            } else {
                ArrayList<Long> orgList = new ArrayList<Long>(CHARGE_PERSON_MAX_THRESHOLD);
                int i = 0;
                for (Long orgId : orgIds) {
                    if (i < CHARGE_PERSON_MAX_THRESHOLD) {
                        orgList.add(orgId);
                        ++i;
                        continue;
                    }
                    Map batchResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargePersonByOrgId", (Object[])new Object[]{orgList, date});
                    LOG.info("queryChargePersonByOrgId: {}, orgIds: {}, queryDate: {}", new Object[]{JSONObject.toJSONString((Object)LogPrivacyUtil.filterPrivacyProp(personResult, Collections.singletonList("headsculpture"))), JSONObject.toJSONString(orgList), JSONObject.toJSONString((Object)queryDate)});
                    personResult.putAll(batchResult);
                    orgList.clear();
                    i = 1;
                    orgList.add(orgId);
                }
                if (orgList.size() > 0) {
                    Map batchResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargePersonByOrgId", (Object[])new Object[]{orgList, date});
                    LOG.info("queryChargePersonByOrgId: {}, orgIds: {}, queryDate: {}", new Object[]{JSONObject.toJSONString(personResult), JSONObject.toJSONString(orgList), JSONObject.toJSONString((Object)queryDate)});
                    personResult.putAll(batchResult);
                }
            }
        }
        catch (Exception e) {
            LOG.error("queryChargePersonByOrgId error ", (Throwable)e);
        }
        LOG.info("getPersonCountAndChangeInfo cost time{}", (Object)(System.currentTimeMillis() - start));
        return personResult;
    }

    public static List<Map<String, Object>> getPersonCountAndChargeInfo(List<Long> adminOrgIds, Date queryDate) {
        LOG.info("getPersonCountAndChargeInfo: orgIds: {}, queryDate: {}", (Object)JSONObject.toJSONString(adminOrgIds), (Object)queryDate);
        List personResult = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonCountAndChargeInfo", (Object[])new Object[]{adminOrgIds, queryDate});
        LOG.info("getPersonCountAndChargeInfo result: {}", (Object)JSONObject.toJSONString((Object)personResult));
        return personResult;
    }
}

