/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;

public class AdminOrgHisDynamicUtils {
    private static final Log logger = LogFactory.getLog(AdminOrgHisDynamicUtils.class);
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    public static final ThreadLocal<Date> EFFECT_DATE = new ThreadLocal();
    public static final ThreadLocal<long[]> FIRST_VERSION_IDS = ThreadLocal.withInitial(() -> null);
    public static final ThreadLocal<Map<Long, Long>> FIRST_VERSION_IDS_MAP = ThreadLocal.withInitial(() -> null);
    private static volatile AdminOrgHisDynamicUtils adminOrgHisDynamicUtils = null;

    private AdminOrgHisDynamicUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminOrgHisDynamicUtils getInstance() {
        if (adminOrgHisDynamicUtils != null) return adminOrgHisDynamicUtils;
        Class<AdminOrgHisDynamicUtils> clazz = AdminOrgHisDynamicUtils.class;
        synchronized (AdminOrgHisDynamicUtils.class) {
            if (adminOrgHisDynamicUtils != null) return adminOrgHisDynamicUtils;
            adminOrgHisDynamicUtils = new AdminOrgHisDynamicUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return adminOrgHisDynamicUtils;
        }
    }

    public static Date getDefaultBsled() {
        SimpleDateFormat sdf = threadLocal.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            return sdf.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public Set<String> getMultiLanguageIgnoreKey() {
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("multilanguagetext");
        ignoreSet.add("name");
        ignoreSet.add("simplename");
        ignoreSet.add("description");
        ignoreSet.add("fullname");
        return ignoreSet;
    }

    public HisVersionParamBo getHisVersionParam(DynamicObject[] hisDyns, String entityNumber, boolean isAtomicTrans) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        if (FIRST_VERSION_IDS.get() != null) {
            hisVersionParamBo.setFirstVersionIds(FIRST_VERSION_IDS.get());
            FIRST_VERSION_IDS.remove();
        }
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setAtomicTrans(isAtomicTrans);
        hisVersionParamBo.setHisDyns(hisDyns);
        return hisVersionParamBo;
    }

    public HisVersionParamBo getHisVersionParam(DynamicObject[] hisDyns, String entityNumber, boolean isAtomicTrans, List<Map<String, Object>> customizedFiledValue) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        if (FIRST_VERSION_IDS.get() != null) {
            hisVersionParamBo.setFirstVersionIds(FIRST_VERSION_IDS.get());
            FIRST_VERSION_IDS.remove();
        }
        if (customizedFiledValue != null) {
            hisVersionParamBo.setCustomizedFiledValue(customizedFiledValue);
        }
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setAtomicTrans(isAtomicTrans);
        hisVersionParamBo.setHisDyns(hisDyns);
        return hisVersionParamBo;
    }

    public static Date dateWithoutTime(Date date) {
        SimpleDateFormat sdf = threadLocal.get();
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            return sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

