/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgHisServiceHelper {
    public static final HRBaseServiceHelper ADMIN_ORG = new HRBaseServiceHelper("haos_adminorgdetail");
    public static final HRBaseServiceHelper ADMIN_GROUP = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey());
    public static final HRBaseServiceHelper ADMIN_COMPANY = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
    public static final HRBaseServiceHelper ADMIN_DEP = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
    public static final HRBaseServiceHelper ORGTEAMCOOPREL_HELPER = new HRBaseServiceHelper("haos_orgteamcooprel");
    public static final ThreadLocal<long[]> FIRST_VERSION_IDS = ThreadLocal.withInitial(() -> null);

    public static Map<Long, List<TeamCoopRelBO>> getCurBatchOrgCoopRelBOMap(DynamicObject[] dysArrays) {
        HashMap<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = new HashMap<Long, List<TeamCoopRelBO>>(dysArrays.length);
        for (DynamicObject dynamicObject : dysArrays) {
            DynamicObject parentOrg;
            long orgTeamId = dynamicObject.getLong("id");
            Date effDate = dynamicObject.getDate("bsed");
            String billenable = dynamicObject.getString("billenable");
            DynamicObjectCollection coopRelEntryEntity = dynamicObject.getDynamicObjectCollection("cooprelentryentity");
            ArrayList<TeamCoopRelBO> coopRelBOList = new ArrayList<TeamCoopRelBO>(4);
            if (!ObjectUtils.isEmpty((Object)coopRelEntryEntity)) {
                int index = 1;
                for (DynamicObject coopRelDyn : coopRelEntryEntity) {
                    long coopTypeId = coopRelDyn.getLong("coopreltyp.id");
                    long coopTeamId = coopRelDyn.getLong("cooporgteam.boid");
                    long boId = coopRelDyn.getLong("cooprelid");
                    TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, coopTypeId, coopTeamId, index);
                    teamCoopRelBO.setBoId(boId);
                    teamCoopRelBO.setEffDate(effDate);
                    if (billenable != null) {
                        teamCoopRelBO.setEnable(billenable);
                    }
                    coopRelBOList.add(teamCoopRelBO);
                    ++index;
                }
            }
            if (Objects.nonNull(parentOrg = dynamicObject.getDynamicObject("parentorg"))) {
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, 1010L, parentOrg.getLong("id"), 0);
                teamCoopRelBO.setEffDate(effDate);
                if (billenable != null) {
                    teamCoopRelBO.setEnable(billenable);
                }
                coopRelBOList.add(teamCoopRelBO);
            }
            orgCoopRelBOMap.put(orgTeamId, coopRelBOList);
        }
        return orgCoopRelBOMap;
    }

    public static String getCurOrgIndex(DynamicObject dynamicObject) {
        DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
        if (HRObjectUtils.isEmpty((Object)parentOrg)) {
            return "1";
        }
        QFilter filter = new QFilter("parentorg", "=", (Object)parentOrg.getLong("id"));
        filter.and("datastatus", "in", Arrays.asList("0", "1", "2"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"haos_adminorgdetail", (String)"index", (QFilter[])new QFilter[]{filter}, (String)"index DESC", (int)1);
        if (dynamicObjects.length == 0) {
            return "1";
        }
        return String.valueOf(dynamicObjects[0].getInt("index") + 1);
    }

    public static DynamicObject buildNewHisDynamicObject(DynamicObject dynamicObject, String entityName) {
        return AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, entityName, null);
    }

    public static DynamicObject buildNewHisDynamicObject(DynamicObject dynamicObject, String entityName, Map<String, Map<Long, DynamicObject>> adminOrgInfoMap) {
        DynamicObject dyn;
        long id;
        long adminOrgId = dynamicObject.getLong("id");
        DynamicObject oldHisInfo = null;
        if (adminOrgInfoMap != null) {
            Map<Long, DynamicObject> entityInfoMap = adminOrgInfoMap.get(entityName);
            oldHisInfo = entityInfoMap.get(adminOrgId);
        }
        Long boId = null;
        if (oldHisInfo != null) {
            id = oldHisInfo.getLong("id");
            boId = oldHisInfo.getLong("boid");
            dyn = oldHisInfo;
        } else {
            dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            id = ORM.create().genLongId(entityName);
        }
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyn);
        if (HRStringUtils.equals((String)entityName, (String)AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey())) {
            dyn.set("companyname", dynamicObject.get("name"));
        }
        dyn.set("adminorg", (Object)dynamicObject);
        dyn.set("boid", (Object)boId);
        dyn.set("id", (Object)id);
        return dyn;
    }

    public static DynamicObject getBelongCompany(DynamicObject curOrgDyn) {
        DynamicObject parentOrg = curOrgDyn.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrg)) {
            return null;
        }
        long parentOrgTypeId = parentOrg.getLong("adminorgtype.id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        DynamicObject parentOrgTypeDyn = serviceHelper.queryOne((Object)parentOrgTypeId);
        long parentOrgId = parentOrg.getLong("id");
        long parentOrgTypeStdId = parentOrgTypeDyn.getLong("adminorgtypestd.id");
        if (parentOrgTypeStdId == AdminOrgType.COMPANY.getId() || parentOrgTypeStdId == AdminOrgType.GROUP.getId()) {
            return parentOrg;
        }
        String parentOrgStructLongNumber = AdminOrgHisServiceHelper.getOrgStructLongNumberByOrgId(parentOrgId);
        String[] structNumberArray = parentOrgStructLongNumber.split("!");
        if (structNumberArray.length == 1) {
            return null;
        }
        String[] copyStructNumberArr = Arrays.copyOfRange(structNumberArray, 0, structNumberArray.length - 1);
        Object[] dynamicObjects = AdminOrgHisServiceHelper.getOrgByStructNumberAndOrgType(copyStructNumberArr, Arrays.asList(AdminOrgType.GROUP.getId(), AdminOrgType.COMPANY.getId()));
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        Map<String, DynamicObject> structNumberMapOrgId = Stream.of(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getString("structnumber"), dyn -> dyn));
        for (int i = copyStructNumberArr.length - 1; i >= 0; --i) {
            if (!structNumberMapOrgId.containsKey(copyStructNumberArr[i])) continue;
            return structNumberMapOrgId.get(copyStructNumberArr[i]);
        }
        return null;
    }

    public static String getOrgStructLongNumberByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("structlongnumber", new QFilter[]{filter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return "";
        }
        return dynamicObjects[0].getString("structlongnumber");
    }

    public static DynamicObject[] getOrgByStructNumberAndOrgType(String[] structNumberArr, List<Long> orgType) {
        HRBaseServiceHelper adminOrgServiceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        QFilter qFilter = new QFilter("structnumber", "in", (Object)structNumberArr);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("adminorgtype", "in", orgType);
        return adminOrgServiceHelper.query("id,structnumber,boid", new QFilter[]{qFilter});
    }

    public static HisVersionParamBo buildDisableHisVersionParam(DynamicObject[] orgDynArrays, Long eventId, String entityNumber, String adminOrg) {
        Map<Long, Date> effDateAndDynMap = Arrays.stream(orgDynArrays).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getDate("bsed")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(adminOrg, "in", effDateAndDynMap.keySet());
        DynamicObject[] hisDynArrays = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        Arrays.stream(hisDynArrays).forEach(dyn -> {
            Long orgId = dyn.getLong("id");
            dyn.set("enable", (Object)"0");
            dyn.set("disabledate", effDateAndDynMap.get(orgId));
            dyn.set("bsed", effDateAndDynMap.get(orgId));
            dyn.set("id", null);
        });
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(hisDynArrays, entityNumber, false);
    }

    public static Map<Long, DynamicObject> batchGetOrgParentStructDynObj(Map<Long, Long> orgIdMapParentId, String structEntityName, String orgFieldName) {
        if (CollectionUtils.isEmpty(orgIdMapParentId)) {
            return new HashMap<Long, DynamicObject>(2);
        }
        return AdminOrgHisServiceHelper.getStructDynMap(structEntityName, orgFieldName, new HashSet<Long>(orgIdMapParentId.values()));
    }

    public static Map<Long, DynamicObject> getStructDynMap(String structEntityName, String orgFieldName, Set<Long> orgTeamIdSet) {
        QFilter filter = new QFilter(orgFieldName, "in", orgTeamIdSet);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityName);
        DynamicObject[] dynamicObjectArray = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(8);
        if (dynamicObjectArray == null) {
            return map;
        }
        for (DynamicObject dyn : dynamicObjectArray) {
            map.put(dyn.getLong(orgFieldName), dyn);
        }
        return map;
    }

    public static Map<Long, DynamicObject> getEntityInfoByOrgId(List<Long> orgIdList, String entityName, String orgFieldName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter filter = new QFilter(orgFieldName, "in", orgIdList);
        filter.and("iscurrentversion", "=", (Object)"1");
        Object[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dyn -> {
            Object obj = dyn.get(orgFieldName);
            if (obj instanceof Long) {
                return (Long)obj;
            }
            return ((DynamicObject)obj).getLong("id");
        }, dyn -> dyn));
    }

    public static Map<Long, List<TeamCoopRelBO>> batchGetOldOrgCoopRelMapOnlyAd(Set<Long> orgIdSet) {
        DynamicObject[] dynamicObjects = TeamCoopRelRepository.getInstance().loadAdCoopRel(orgIdSet);
        Map<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = AdminOrgHisServiceHelper.createOrgIdVsCoopRelBo(dynamicObjects);
        return oldOrgTeamCoopRelMap;
    }

    private static Map<Long, List<TeamCoopRelBO>> createOrgIdVsCoopRelBo(DynamicObject[] dynamicObjects) {
        HashMap<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = new HashMap<Long, List<TeamCoopRelBO>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long orgTeamId = dynamicObject.getLong("org.id");
            long coopTypeId = dynamicObject.getLong("coopreltype.id");
            long coopTeamId = dynamicObject.getLong("cooporgteam.id");
            int index = dynamicObject.getInt("index");
            long boId = dynamicObject.getLong("boid");
            TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, coopTypeId, coopTeamId, index);
            teamCoopRelBO.setBoId(boId);
            teamCoopRelBO.setOldTeamCoopRelDyn(dynamicObject);
            teamCoopRelBO.setEnable(dynamicObject.getString("enable"));
            ArrayList<TeamCoopRelBO> teamCoopRelBOS = (ArrayList<TeamCoopRelBO>)oldOrgTeamCoopRelMap.get(orgTeamId);
            if (Objects.isNull(teamCoopRelBOS)) {
                teamCoopRelBOS = new ArrayList<TeamCoopRelBO>(4);
            }
            teamCoopRelBOS.add(teamCoopRelBO);
            oldOrgTeamCoopRelMap.put(orgTeamId, teamCoopRelBOS);
        }
        return oldOrgTeamCoopRelMap;
    }

    public static Map<Long, List<TeamCoopRelBO>> batchGetOldOrgCoopRelMap(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return AdminOrgHisServiceHelper.createOrgIdVsCoopRelBo(dynamicObjects);
    }

    public static Map<Long, List<TeamCoopRelBO>> batchGetOldOrgCoopRelMapIgnoreEnable(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return AdminOrgHisServiceHelper.createOrgIdVsCoopRelBo(dynamicObjects);
    }

    public static DynamicObject enableOrDisableEntity(DynamicObject entity, String entityNumber, String enable, Date bsed) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        HRDynamicObjectUtils.copy((DynamicObject)entity, (DynamicObject)dynamicObject, AdminOrgHisServiceHelper.getIgnoreKeys());
        long currUserId = RequestContext.get().getCurrUserId();
        dynamicObject.set("bsed", (Object)bsed);
        dynamicObject.set("enable", (Object)enable);
        if (HRStringUtils.equals((String)"0", (String)enable)) {
            dynamicObject.set("disabledate", (Object)new Date());
            dynamicObject.set("disabler", (Object)currUserId);
        }
        return dynamicObject;
    }

    public static Set<String> getIgnoreKeys() {
        HashSet<String> keySet = new HashSet<String>(20);
        keySet.add("bsed");
        keySet.add("bsled");
        keySet.add("bred");
        keySet.add("brled");
        keySet.add("brfd");
        keySet.add("sourcevid");
        keySet.add("ismodify");
        keySet.add("firstbsed");
        keySet.add("changebsed");
        keySet.add("datastatus");
        keySet.add("modifier");
        keySet.add("modifytime");
        keySet.add("disabledate");
        keySet.add("disabler");
        return keySet;
    }

    public static HisVersionParamListBo constructBatchSaveHisVersionParamBO(List<HisVersionParamBo> listHisVersionParamBo, Long eventId) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(eventId);
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        return hisVersionParamListBo;
    }

    public static DynamicObject[] batchGetTeamCoopRelByIds(List<Long> coopRelIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", coopRelIdList)});
    }

    public static List<String> filterUnNecessaryStructLongNumber(List<String> structLongNumberList) {
        structLongNumberList.sort(Comparator.comparing(String::length));
        ArrayList<String> filteredStructLongNumber = new ArrayList<String>(structLongNumberList.size());
        AdminOrgHisServiceHelper.filterStructLongNumber(structLongNumberList, filteredStructLongNumber);
        return filteredStructLongNumber;
    }

    private static void filterStructLongNumber(List<String> structLongNumberList, List<String> filteredStructLongNumber) {
        String leastLengthStructLongNumber = structLongNumberList.get(0);
        filteredStructLongNumber.add(leastLengthStructLongNumber);
        List<String> collect = structLongNumberList.stream().filter(strcNum -> !strcNum.contains(leastLengthStructLongNumber)).collect(Collectors.toList());
        if (collect.size() == 0) {
            return;
        }
        AdminOrgHisServiceHelper.filterStructLongNumber(collect, filteredStructLongNumber);
    }

    public static DynamicObject[] batchGetStructLongNumber(List<Long> orgIdList, Date date, String entityNumber, String orgFieldName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter(orgFieldName, "in", orgIdList);
        QFilter dateFilter = AdminOrgHisServiceHelper.hisDateQueryFilter(date);
        if (AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey().equals(entityNumber)) {
            dateFilter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        } else if ("haos_adminorgstructure".equals(entityNumber)) {
            dateFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
        }
        dateFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return serviceHelper.query("structlongnumber", new QFilter[]{filter, dateFilter});
    }

    public static DynamicObject[] batchGetOrgHisInfo(Date startDate, Date endDate, List<Long> boIdList) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter boIdfilter = new QFilter("boid", "in", boIdList);
        QFilter dateFilter = AdminOrgHisServiceHelper.hisDateQueryFilter(startDate, endDate);
        dateFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        String queryFieldStr = "id, boid, enable, datastatus, number, name, adminorgtype, belongcompany, establishmentdate, parentorg, corporateorg, companyarea, city, bsed, bsled,isvirtualorg";
        return adminOrgHelper.query(queryFieldStr, new QFilter[]{boIdfilter, dateFilter});
    }

    public static QFilter hisDateQueryFilter(Date statDate, Date endDate) {
        Date startdateWithoutTime = AdminOrgHisDynamicUtils.dateWithoutTime(statDate);
        Date endDateWithoutTime = AdminOrgHisDynamicUtils.dateWithoutTime(endDate);
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)endDateWithoutTime);
        dateFilter.and("bsled", ">=", (Object)startdateWithoutTime).and("iscurrentversion", "=", (Object)"0").and("datastatus", "in", Arrays.asList("1", "2"));
        return dateFilter;
    }

    public static QFilter hisDateQueryFilter(Date date) {
        Date dateWithoutTime = AdminOrgHisDynamicUtils.dateWithoutTime(date);
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)dateWithoutTime);
        dateFilter.and("bsled", ">=", (Object)dateWithoutTime).and("iscurrentversion", "=", (Object)"0").and("datastatus", "in", Arrays.asList("1", "2"));
        return dateFilter;
    }

    public static Set<String> getChangeOrgCopyIgnoreKeys() {
        HashSet<String> ignoreKeys = new HashSet<String>();
        ignoreKeys.add("masterid");
        ignoreKeys.add("boid");
        ignoreKeys.add("structnumber");
        ignoreKeys.add("enable");
        ignoreKeys.add("status");
        ignoreKeys.add("createtime");
        ignoreKeys.add("creator");
        return ignoreKeys;
    }

    public static HisVersionParamBo getHisVersionParam(DynamicObject[] hisDyns, String entityNumber, boolean isAtomicTrans) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setAtomicTrans(isAtomicTrans);
        hisVersionParamBo.setHisDyns(hisDyns);
        if (FIRST_VERSION_IDS.get() != null) {
            hisVersionParamBo.setFirstVersionIds(FIRST_VERSION_IDS.get());
            FIRST_VERSION_IDS.remove();
        }
        hisVersionParamBo.setEffImmediately(true);
        return hisVersionParamBo;
    }

    public static HisVersionParamBo getHisVersionParam(DynamicObject[] hisDyns, String entityNumber, boolean isAtomicTrans, List<Map<String, Object>> customizedFiledValue) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setAtomicTrans(isAtomicTrans);
        hisVersionParamBo.setHisDyns(hisDyns);
        if (customizedFiledValue != null) {
            hisVersionParamBo.setCustomizedFiledValue(customizedFiledValue);
        }
        if (FIRST_VERSION_IDS.get() != null) {
            hisVersionParamBo.setFirstVersionIds(FIRST_VERSION_IDS.get());
            FIRST_VERSION_IDS.remove();
        }
        hisVersionParamBo.setEffImmediately(true);
        return hisVersionParamBo;
    }

    public static void constructOrgStructLongNumberOrSortCode(Map<Long, DynamicObject> orgIdDynMap, Map<Long, DynamicObject> idStructLongNumMap, Map<Long, String> orgIdStructLongNumberMap, String fieldKey, String fieldKeyInOrgInfo, int recursionDepth) {
        if (CollectionUtils.isEmpty(orgIdDynMap)) {
            return;
        }
        if (recursionDepth > AdminOrgConstants.MAX_ORG_LEVEL) {
            Set orgIdSets = orgIdDynMap.values().stream().map(dy -> dy.getLong("parentorg.id")).collect(Collectors.toSet());
            throw new KDBizException("The list org don't have struct long number or sort code, Please check! orgIds[" + orgIdSets + "]");
        }
        Iterator<Map.Entry<Long, DynamicObject>> iterator = orgIdDynMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> entry = iterator.next();
            Long orgId = entry.getKey();
            DynamicObject orgDyn = entry.getValue();
            DynamicObject parentOrg = orgDyn.getDynamicObject("parentorg");
            String indexOrStructNumber = orgDyn.getString(fieldKeyInOrgInfo);
            if (HRStringUtils.equalsIgnoreCase((String)fieldKeyInOrgInfo, (String)"index")) {
                indexOrStructNumber = AdminOrgHisServiceHelper.fillIndexWithZero(indexOrStructNumber);
            }
            if (Objects.isNull(parentOrg)) {
                orgIdStructLongNumberMap.put(orgId, indexOrStructNumber);
            } else {
                long parentOrgId = parentOrg.getLong("id");
                if (!idStructLongNumMap.containsKey(parentOrgId) && !orgIdStructLongNumberMap.containsKey(parentOrgId)) continue;
                String parentStructLongNumber = "";
                if (idStructLongNumMap.containsKey(parentOrgId)) {
                    DynamicObject parentStructDyn = idStructLongNumMap.get(parentOrgId);
                    parentStructLongNumber = parentStructDyn.getString(fieldKey);
                }
                if (orgIdStructLongNumberMap.containsKey(parentOrgId)) {
                    parentStructLongNumber = orgIdStructLongNumberMap.get(parentOrgId);
                }
                orgIdStructLongNumberMap.put(orgId, parentStructLongNumber + "!" + indexOrStructNumber);
            }
            iterator.remove();
        }
        AdminOrgHisServiceHelper.constructOrgStructLongNumberOrSortCode(orgIdDynMap, idStructLongNumMap, orgIdStructLongNumberMap, fieldKey, fieldKeyInOrgInfo, recursionDepth + 1);
    }

    public static String fillIndexWithZero(String index) {
        int length = index.length();
        StringBuilder indexBuilder = new StringBuilder(index);
        for (int i = 0; i < 5 - length; ++i) {
            indexBuilder.insert(0, "0");
        }
        return indexBuilder.toString();
    }

    public static Map<Long, Integer> batchGetMaxIndexUnderOrg(Set<Long> orgIdSets) {
        if (orgIdSets == null || orgIdSets.size() == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        StringBuilder sqlBuilder = new StringBuilder("select max(t.findex) as indx,t.fparentid as parentid from t_haos_adminorg as t where t.fparentid in (");
        orgIdSets.forEach(id -> sqlBuilder.append("?,"));
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(") group by t.fparentid");
        HashMap maxIndexUnderOrg = Maps.newHashMapWithExpectedSize((int)orgIdSets.size());
        try (DataSet rs = HRDBUtil.queryDataSet((String)"hr_haos_batchGetMaxIndexUnderOrg", (DBRoute)new DBRoute("haos"), (String)sqlBuilder.toString(), (Object[])orgIdSets.toArray());){
            rs.forEach(data -> maxIndexUnderOrg.put(data.getLong("parentid"), data.getInteger("indx") + 1));
        }
        orgIdSets.forEach(id -> {
            if (!maxIndexUnderOrg.containsKey(id)) {
                maxIndexUnderOrg.put(id, 1);
            }
        });
        return maxIndexUnderOrg;
    }

    public static Map<Long, DynamicObject> batchQueryOrgHisData(Set<Long> orgHisIds) {
        if (CollectionUtils.isEmpty(orgHisIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter qFilter = new QFilter("id", "in", orgHisIds);
        DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Arrays.stream(objects).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
    }

    public static DynamicObject findBelongCompany(Map<Long, DynamicObject> allParentOrgMap, DynamicObject currentOrg) {
        DynamicObject parentOrg = currentOrg.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrg)) {
            return null;
        }
        DynamicObject parent = allParentOrgMap.get(parentOrg.getLong("id"));
        long parentOrgTypeStdId = parent.getLong("adminorgtype.adminorgtypestd.id");
        if (parentOrgTypeStdId == AdminOrgType.COMPANY.getId() || parentOrgTypeStdId == AdminOrgType.GROUP.getId()) {
            return parent;
        }
        return AdminOrgHisServiceHelper.findBelongCompany(allParentOrgMap, parent);
    }

    public static Map<Long, DynamicObject> getAllParentOrgs(DynamicObject[] dysArrays) {
        HashSet parentIds = new HashSet();
        HashMap numberOrgMap = new HashMap();
        Stream.of(dysArrays).forEach(org -> {
            numberOrgMap.put(org.getLong("id"), org);
            DynamicObject parentOrg = org.getDynamicObject("parentorg");
            if (parentOrg != null) {
                parentIds.add(parentOrg.getLong("id"));
            }
        });
        HRBaseServiceHelper adminorgStructServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        Object[] adminorgStructs = adminorgStructServiceHelper.query("structlongnumber", new QFilter[]{new QFilter("adminorg", "in", parentIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        HashSet<String> allStrucNumbers = new HashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])adminorgStructs)) {
            Stream.of(adminorgStructs).forEach(adminorgStruct -> allStrucNumbers.addAll(Arrays.asList(adminorgStruct.getString("structlongnumber").split("!"))));
        }
        Map<Long, DynamicObject> parentOrgs = AdminOrgHisServiceHelper.getOrgInfoByStructNumber(allStrucNumbers);
        parentOrgs.putAll(numberOrgMap);
        return parentOrgs;
    }

    private static Map<Long, DynamicObject> getOrgInfoByStructNumber(Collection<String> structNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] adminorgs = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("structnumber", "in", structNumbers), new QFilter("iscurrentversion", "=", (Object)"1")});
        return Stream.of(adminorgs).collect(Collectors.toMap(dy -> dy.getLong("id"), dt -> dt));
    }

    public static QFilter queryHisQFilter(Date queryDate, boolean hisAndCur) {
        LocalDate queryLocalDate = TimeConvertUtil.date2LocalDate(queryDate);
        QFilter qFilter = null;
        if (queryLocalDate.isBefore(LocalDate.now())) {
            qFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            if (!hisAndCur) {
                qFilter.and("bsed", "<=", (Object)queryDate);
            }
            qFilter.and("bsled", ">=", (Object)queryDate);
            qFilter.and("datastatus", "in", Arrays.asList("1", "2"));
        } else {
            qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            qFilter.and("datastatus", "=", (Object)"1");
        }
        return qFilter;
    }
}

