/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.application.impl.adminorg.AdminOrgApplicationImpl;
import kd.hr.haos.business.service.adminorg.AdminOrgBasicInfoService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.IOpService;
import kd.hr.haos.business.service.adminorg.sortcode.AdminOrgSortCodeService;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgStructService;
import kd.hr.haos.common.constants.TeamCoopRelConstants;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgOpService
implements IOpService {
    private static final Log logger = LogFactory.getLog(AdminOrgOpService.class);
    private static AdminOrgOpService service = new AdminOrgOpService();

    private AdminOrgOpService() {
    }

    public static AdminOrgOpService getInstance() {
        return service;
    }

    @Override
    @Deprecated
    public HisResponse<BatchVersionChangeRespData> saveNew(DynamicObject[] dysArrays, Long eventId) {
        return null;
    }

    @Override
    @Deprecated
    public HisResponse<BatchVersionChangeRespData> enable(Map<Long, Date> idDateMap, Long eventId) {
        return null;
    }

    @Override
    @Deprecated
    public HisResponse<BatchVersionChangeRespData> disable(Map<Long, Date> orgIdDisableDateMap, Long eventId) {
        return null;
    }

    public HisVersionParamBo enableOrgTransaction(Map<Long, Date> orgIdDisableDateMap, String mainKey, String entityNumber) {
        DynamicObject[] dynArrays;
        if (ObjectUtils.isEmpty(orgIdDisableDateMap)) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter adTypeFilter = new QFilter("coopreltype", "=", (Object)TeamCoopRelConstants.AFFILIATION_ID);
        filter.and(new QFilter(mainKey, "in", orgIdDisableDateMap.keySet()));
        for (DynamicObject dyn : dynArrays = helper.loadDynamicObjectArray(new QFilter[]{filter, adTypeFilter})) {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)mainKey);
            dyn.set("enable", (Object)"1");
            dyn.set("bsed", (Object)orgIdDisableDateMap.get(orgId));
        }
        ArrayList<DynamicObject> orgDynList = new ArrayList<DynamicObject>(dynArrays.length);
        Date nowDate = new Date();
        for (DynamicObject dyn : dynArrays) {
            DynamicObject newDyn = new DynamicObject(dyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newDyn);
            newDyn.set("createtime", (Object)nowDate);
            orgDynList.add(newDyn);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgDynList.toArray(new DynamicObject[0]), entityNumber, false);
    }

    public HisVersionParamBo disableOrgTransaction(Map<Long, Date> orgIdDisableDateMap, String mainKey, String entityNumber, Map<Long, Long> boVsNewId) {
        DynamicObject[] dynArrays;
        if (ObjectUtils.isEmpty(orgIdDisableDateMap)) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter(mainKey, "in", orgIdDisableDateMap.keySet()));
        for (DynamicObject dyn : dynArrays = helper.loadDynamicObjectArray(new QFilter[]{filter})) {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)mainKey);
            dyn.set("enable", (Object)"0");
            dyn.set("disabledate", (Object)orgIdDisableDateMap.get(orgId));
            dyn.set("bsed", (Object)orgIdDisableDateMap.get(orgId));
        }
        ArrayList<DynamicObject> orgDynList = new ArrayList<DynamicObject>(dynArrays.length);
        boolean projIndex = false;
        Date nowDate = new Date();
        for (DynamicObject dyn : dynArrays) {
            DynamicObject newDyn = new DynamicObject(dyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newDyn);
            if ("haos_adminorgteam".equals(entityNumber)) {
                long id = boVsNewId.get(newDyn.getLong("boid"));
                newDyn.set("id", (Object)id);
            }
            newDyn.set("createtime", (Object)nowDate);
            orgDynList.add(newDyn);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgDynList.toArray(new DynamicObject[0]), entityNumber, false);
    }

    public void saveTemporary(DynamicObject[] dysArrays, Long eventId) {
        this.saveTemporary(dysArrays, eventId, true);
    }

    public void saveTemporary(DynamicObject[] dysArrays, Long eventId, boolean queryTempFlag) {
        long startTime = System.currentTimeMillis();
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        Map<String, Map<Long, DynamicObject>> adminOrgInfoMap = queryTempFlag ? AdminOrgBasicInfoService.getInstance().buildTempInfoMap(dysArrays) : null;
        List<HisVersionParamBo> listHisVersionParamBo = AdminOrgBasicInfoService.getInstance().buildTempNewHisParam(dysArrays, adminOrgInfoMap);
        HisVersionParamBo orgStructHisParam = AdminOrgStructService.getInstance().buildTempNewHisParam(dysArrays, adminOrgInfoMap);
        listHisVersionParamBo.add(orgStructHisParam);
        HisVersionParamBo orgSortCodeHisParam = AdminOrgSortCodeService.getInstance().buildTempNewHisParam(dysArrays, adminOrgInfoMap);
        listHisVersionParamBo.add(orgSortCodeHisParam);
        long secondTimeMill = System.currentTimeMillis();
        logger.info(String.format(Locale.ROOT, "saveTemporary construct hisVersionParam cost %s milliseconds", secondTimeMill - startTime));
        for (HisVersionParamBo hisVersionParamBo : listHisVersionParamBo) {
            DynamicObject[] hisDyns;
            hisVersionParamBo.setOperateType("SAVE_VERSION");
            for (DynamicObject dynamicObject : hisDyns = hisVersionParamBo.getHisDyns()) {
                dynamicObject.set("datastatus", (Object)"-3");
            }
            hisVersionParamBo.setEffImmediately(false);
            HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        }
        logger.info(String.format(Locale.ROOT, "saveTemporary call his change interface cost %s milliseconds", System.currentTimeMillis() - secondTimeMill));
    }

    public void batchSaveTemp(DynamicObject[] dysArrays) {
        AdminOrgApplicationImpl.getInstance().batchSaveTemp(dysArrays);
    }
}

