/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.businessfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.IOpService;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgBusinessFileService
implements IOpService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("haos_orgbusinessfile");
    private static volatile AdminOrgBusinessFileService adminOrgBusinessFileService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminOrgBusinessFileService getInstance() {
        if (adminOrgBusinessFileService != null) return adminOrgBusinessFileService;
        Class<AdminOrgBusinessFileService> clazz = AdminOrgBusinessFileService.class;
        synchronized (AdminOrgBusinessFileService.class) {
            if (adminOrgBusinessFileService != null) return adminOrgBusinessFileService;
            adminOrgBusinessFileService = new AdminOrgBusinessFileService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return adminOrgBusinessFileService;
        }
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> saveNew(DynamicObject[] dysArrays, Long eventId) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        ArrayList<HisVersionParamBo> paramBoArrayList = new ArrayList<HisVersionParamBo>();
        hisVersionParamListBo.setListHisVersionParamBo(paramBoArrayList);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        paramBoArrayList.add(AdminOrgBusinessFileService.buildAddNewHisParam(dysArrays));
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public static HisVersionParamBo buildAddNewHisParam(DynamicObject[] adminOrgDys) {
        ArrayList<DynamicObject> businessFileDynList = new ArrayList<DynamicObject>(adminOrgDys.length);
        long[] ids = ORM.create().genLongIds("haos_orgbusinessfile", adminOrgDys.length);
        for (int i = 0; i < adminOrgDys.length; ++i) {
            DynamicObject businessFileObj = AdminOrgBusinessFileService.createAddNewBusinessFile(adminOrgDys[i]);
            businessFileObj.set("id", (Object)ids[i]);
            businessFileDynList.add(businessFileObj);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(businessFileDynList.toArray(new DynamicObject[0]), "haos_orgbusinessfile", false);
    }

    public static DynamicObject createAddNewBusinessFile(DynamicObject adminOrgDy) {
        DynamicObject businessFileObj = SERVICE_HELPER.generateEmptyDynamicObject();
        businessFileObj.set("bsed", adminOrgDy.get("bsed"));
        businessFileObj.set("bsled", adminOrgDy.get("bsled"));
        businessFileObj.set("adminorg", (Object)adminOrgDy);
        businessFileObj.set("bussinessfield", (Object)1050L);
        businessFileObj.set("org", adminOrgDy.get("org"));
        businessFileObj.set("enable", adminOrgDy.get("enable"));
        businessFileObj.set("status", (Object)"C");
        AdminOrgBusinessFileService.setInitField(adminOrgDy, businessFileObj);
        return businessFileObj;
    }

    public HisVersionParamBo buildDisableHisParam(DynamicObject[] adminOrgDys) {
        Map<Long, DynamicObject> adminOrgBoIdVsDy = Arrays.stream(adminOrgDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        QFilter adminOrgIdFilter = new QFilter("adminorg", "in", adminOrgBoIdVsDy.keySet());
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] businessFiles = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{adminOrgIdFilter, currentVersionFilter});
        Arrays.stream(businessFiles).forEach(dy -> dy.set("enable", (Object)"0"));
        Map<Long, DynamicObject> adminOrgIdVsBusinessFile = Arrays.stream(businessFiles).collect(Collectors.toMap(dy -> dy.getLong("adminorg"), dy -> dy, (dy, dy2) -> dy));
        ArrayList<DynamicObject> businessFileDynList = new ArrayList<DynamicObject>(adminOrgDys.length);
        long[] ids = ORM.create().genLongIds("haos_orgbusinessfile", adminOrgDys.length);
        int index = 0;
        for (DynamicObject dbBusinessFile : adminOrgIdVsBusinessFile.values()) {
            DynamicObject newBusinessFileObj = SERVICE_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dbBusinessFile, (DynamicObject)newBusinessFileObj);
            newBusinessFileObj.set("id", (Object)ids[index++]);
            DynamicObject adminOrg = adminOrgBoIdVsDy.get(dbBusinessFile.getLong("adminorg"));
            newBusinessFileObj.set("bsed", adminOrg.get("bsed"));
            newBusinessFileObj.set("bsled", adminOrg.get("bsled"));
            newBusinessFileObj.set("enable", (Object)"0");
            businessFileDynList.add(newBusinessFileObj);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(businessFileDynList.toArray(new DynamicObject[0]), "haos_orgbusinessfile", false);
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> enable(Map<Long, Date> idDateMap, Long eventId) {
        return null;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> disable(Map<Long, Date> idDateMap, Long eventId) {
        return null;
    }

    public void disable(DynamicObject[] dysArrays, Date effDt) {
        List adminOrgIdList = Arrays.stream(dysArrays).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        QFilter adminOrgIdFilter = new QFilter("adminorg", "in", adminOrgIdList);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] businessFiles = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{adminOrgIdFilter, currentVersionFilter});
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber("haos_orgbusinessfile");
        hisBaseBo.setBoIdList(Arrays.stream(businessFiles).map(dy -> dy.getLong("boid")).collect(Collectors.toList()));
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        hisEnableParamBo.setDisabled(true);
        hisEnableParamBo.setEffectDate(effDt);
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        HisModelController.getInstance().disableOrEnableBo(hisEnableParamBo);
    }

    private static void setInitField(DynamicObject source, DynamicObject target) {
        Object initDataSource = source.get("initdatasource");
        Object initBatch = source.get("initbatch");
        Object initStatus = source.get("initstatus");
        target.set("initdatasource", initDataSource != null ? initDataSource : "0");
        target.set("initbatch", initBatch != null ? initBatch : Long.valueOf(0L));
        target.set("initstatus", initStatus != null ? initStatus : "2");
    }
}

