/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.fourlayermodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.service.adminorg.fourlayermodel.OrgInfoExpression;
import kd.hr.haos.business.service.adminorg.fourlayermodel.OrgTypeChangeService;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class FourLayerModelService {
    private static final FourLayerModelService INSTANCE = new FourLayerModelService();

    private FourLayerModelService() {
    }

    public static FourLayerModelService getInstance() {
        return INSTANCE;
    }

    public List<HisVersionParamBo> buildAddNewHisVersionParam(DynamicObject[] dysArrays) {
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dysArrays) {
            this.addGroupCompDepDynByOrgType(dynamicObject, groupDynList, companyDynList, departmentDynList);
        }
        return this.constructOrgBasicInfoHisParam(groupDynList, companyDynList, departmentDynList);
    }

    public List<HisVersionParamBo> buildChangeHisVersionParam(DynamicObject[] dynArrays) {
        List<Long> orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id");
        Map<Long, DynamicObject> oldGroupInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg");
        Map<Long, DynamicObject> oldCompInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg");
        Map<Long, DynamicObject> oldDepartmentInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg");
        OrgInfoExpression expression = new OrgInfoExpression(oldOrgInfoDynMap, oldGroupInfoDynMap, oldCompInfoDynMap, oldDepartmentInfoDynMap);
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>(4);
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>(4);
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>(4);
        for (DynamicObject newDyn : dynArrays) {
            long orgId = newDyn.getLong("id");
            DynamicObject oldDyn = oldOrgInfoDynMap.get(orgId);
            long newOrgType = newDyn.getLong("adminorgtype.adminorgtypestd.id");
            long oldOrgType = oldDyn.getLong("adminorgtype.adminorgtypestd.id");
            Pair<AdminOrgType, AdminOrgType> typePair = new Pair<AdminOrgType, AdminOrgType>(AdminOrgType.getById((long)oldOrgType), AdminOrgType.getById((long)newOrgType));
            expression.setCurOrg(newDyn);
            expression.setTypePair(typePair);
            Map<String, DynamicObject> result = OrgTypeChangeService.RuleEngine.process(expression);
            result.forEach((key, value) -> {
                if (HRStringUtils.equals((String)key, (String)AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey())) {
                    groupDynList.add((DynamicObject)value);
                } else if (HRStringUtils.equals((String)key, (String)AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey())) {
                    companyDynList.add((DynamicObject)value);
                } else {
                    departmentDynList.add((DynamicObject)value);
                }
            });
        }
        return this.constructOrgBasicInfoHisParam(groupDynList, companyDynList, departmentDynList);
    }

    private void addGroupCompDepDynByOrgType(DynamicObject dynamicObject, List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList) {
        long adminOrgTypeId = dynamicObject.getLong("adminorgtype.adminorgtypestd.id");
        switch (Objects.requireNonNull(AdminOrgType.getById((long)adminOrgTypeId))) {
            case GROUP: {
                DynamicObject groupDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey());
                groupDynList.add(groupDyn);
                DynamicObject companyDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
                companyDynList.add(companyDyn);
                break;
            }
            case COMPANY: {
                DynamicObject company = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
                companyDynList.add(company);
                break;
            }
            case DEPARTMENT: {
                DynamicObject departmentDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
                departmentDynList.add(departmentDyn);
                break;
            }
            case REGION: {
                break;
            }
        }
    }

    private List<HisVersionParamBo> constructOrgBasicInfoHisParam(List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList) {
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(16);
        if (!CollectionUtils.isEmpty(groupDynList)) {
            HisVersionParamBo groupHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(groupDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), false);
            listHisVersionParamBo.add(groupHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(companyDynList)) {
            HisVersionParamBo companyHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(companyDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), false);
            listHisVersionParamBo.add(companyHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(departmentDynList)) {
            HisVersionParamBo departmentHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(departmentDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), false);
            listHisVersionParamBo.add(departmentHisVersionParam);
        }
        return listHisVersionParamBo;
    }
}

