/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.strategy;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.bean.StrategyChangeBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;

public class OrgStrategyService {
    private static final Log LOGGER = LogFactory.getLog(OrgStrategyService.class);
    private static final String ENTITY_ADMIN_ORG = "haos_adminorghr";
    private static volatile OrgStrategyService orgStrategyService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrgStrategyService getInstance() {
        if (orgStrategyService != null) return orgStrategyService;
        Class<OrgStrategyService> clazz = OrgStrategyService.class;
        synchronized (OrgStrategyService.class) {
            if (orgStrategyService != null) return orgStrategyService;
            orgStrategyService = new OrgStrategyService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return orgStrategyService;
        }
    }

    public void addOrgStrategy(List<DynamicObject> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            LOGGER.info("success with empty param");
            return;
        }
        LOGGER.info(String.format("param: %s", orgList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList())));
        try {
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"addStrategyByNewOrg", (Object[])new Object[]{orgList});
            if (hrmServiceResult.isSuccess()) {
                LOGGER.info("success");
            } else {
                LOGGER.info(String.format("fail by %s", hrmServiceResult.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void changeOrgStrategy(List<StrategyChangeBo> strategyChangeBoList) {
        if (CollectionUtils.isEmpty(strategyChangeBoList)) {
            LOGGER.info("success with empty param");
            return;
        }
        LOGGER.info(String.format("param: %s", strategyChangeBoList));
        List param = strategyChangeBoList.stream().map(StrategyChangeBo::toMap).collect(Collectors.toList());
        try {
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"batchModifyStrategyByOrg", (Object[])new Object[]{param});
            if (hrmServiceResult.isSuccess()) {
                LOGGER.info("success");
            } else {
                LOGGER.info(String.format("fail by %s", hrmServiceResult.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void disableOrgStrategy(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            LOGGER.info("success with empty param");
            return;
        }
        LOGGER.info(String.format("param: %s", orgIdList));
        try {
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"disableStrategy", (Object[])new Object[]{orgIdList});
            if (hrmServiceResult.isSuccess()) {
                LOGGER.info("success");
            } else {
                LOGGER.info(String.format("fail by %s", hrmServiceResult.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void enableOrgStrategy(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            LOGGER.info("success with empty param");
            return;
        }
        LOGGER.info(String.format("param: %s", orgIdList));
        try {
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"enableStrategy", (Object[])new Object[]{orgIdList});
            if (hrmServiceResult.isSuccess()) {
                LOGGER.info("success");
            } else {
                LOGGER.info(String.format("fail by %s", hrmServiceResult.getMessage()));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void addStrategy4Init(List<DynamicObject> orgList) {
        List<DynamicObject> collect = orgList.stream().map(this::convert4Init).collect(Collectors.toList());
        this.addOrgStrategy(collect);
    }

    private DynamicObject convert4Init(DynamicObject newAdminOrg) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITY_ADMIN_ORG);
        DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
        dynamicObject.set("id", newAdminOrg.get("boid"));
        dynamicObject.set("parent", newAdminOrg.get("parentorg"));
        return dynamicObject;
    }
}

