/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.struct;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgChgStructService {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgChgStructService.class);
    private static AdminOrgChgStructService service = new AdminOrgChgStructService();

    private AdminOrgChgStructService() {
    }

    public static AdminOrgChgStructService getInstance() {
        return service;
    }

    public List<DynamicObject> getChgStructByOrgId(DynamicObject[] dynArrays) {
        List parentIdList = Stream.of(dynArrays).map(dyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"parentorg")).collect(Collectors.toList());
        List orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        ArrayList idLists = Lists.newArrayListWithCapacity((int)(parentIdList.size() << 2));
        idLists.addAll(parentIdList);
        idLists.addAll(orgIdList);
        Map<Long, DynamicObject> allOrgLists = AdminOrgHisServiceHelper.getEntityInfoByOrgId(idLists, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg");
        Map<Long, DynamicObject> parentInfoStructDynMap = allOrgLists.entrySet().stream().filter(entry -> parentIdList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Long, DynamicObject> oldOrgStructInfoDynMap = allOrgLists.entrySet().stream().filter(entry -> orgIdList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList newStructList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dyn2 : dynArrays) {
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn2, (String)"parentorg");
            Long orgId = dyn2.getLong("id");
            Long oldParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)oldOrgStructInfoDynMap.get(orgId), (String)"parentorg");
            Date effectDate = dyn2.getDate("bsed");
            List<DynamicObject> childStructSortDynList = this.getChildStructSortDynList(orgId, oldOrgStructInfoDynMap);
            if (parentId.equals(oldParentId)) continue;
            newStructList.addAll(this.chgStructInfo(dyn2, parentInfoStructDynMap, childStructSortDynList, effectDate));
        }
        return newStructList;
    }

    public List<DynamicObject> getChgSortByOrgId(DynamicObject[] dynArrays) {
        List<Long> parentIdList = Stream.of(dynArrays).map(dyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"parentorg")).collect(Collectors.toList());
        Map<Long, DynamicObject> parentInfoSortDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(parentIdList, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), "adminorg");
        List<Long> orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgStructInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg");
        ArrayList newSortList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dyn2 : dynArrays) {
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn2, (String)"parentorg");
            Long orgId = dyn2.getLong("id");
            Long oldParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)oldOrgStructInfoDynMap.get(orgId), (String)"parentorg");
            String newIndex = dyn2.getString("index");
            String oldIndex = oldOrgStructInfoDynMap.get(orgId).getString("index");
            Date effectDate = dyn2.getDate("bsed");
            List<DynamicObject> childStructSortDynList = this.getChildStructSortDynList(orgId, oldOrgStructInfoDynMap);
            if (parentId.equals(oldParentId) && newIndex.equals(oldIndex)) continue;
            newSortList.addAll(this.chgSortInfo(newIndex, dyn2, parentInfoSortDynMap, childStructSortDynList, effectDate));
        }
        return newSortList;
    }

    public List<DynamicObject> getChgBelongCompanyByOrgId(DynamicObject[] dynArrays, List<HisVersionParamBo> hisVersionParamBos) {
        Map<Long, Long> belongCompany = this.getBelongCompany(hisVersionParamBos);
        List<Long> orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgStructInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg");
        Map<Long, DynamicObject> oldOrgInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id");
        ArrayList newOrgList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dyn2 : dynArrays) {
            Long newBelongComId;
            Long orgId = dyn2.getLong("id");
            Date effectDate = dyn2.getDate("bsed");
            List<DynamicObject> childStructSortDynList = this.getChildStructSortDynList(orgId, oldOrgStructInfoDynMap);
            Long oldBelongComId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)oldOrgInfoDynMap.get(orgId), (String)"belongcompany");
            if (oldBelongComId.equals(newBelongComId = belongCompany.get(orgId))) continue;
            newOrgList.addAll(this.chgNewOrgInfo(dyn2, belongCompany, childStructSortDynList, effectDate));
        }
        return newOrgList;
    }

    private List<DynamicObject> chgNewOrgInfo(DynamicObject orgDyn, Map<Long, Long> belongCompany, List<DynamicObject> childStructSortDynList, Date effectDate) {
        List<Long> childOrgIdList = childStructSortDynList.stream().map(childStructDyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childStructDyn, (String)"adminorg")).collect(Collectors.toList());
        Map<Long, DynamicObject> childOrgDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(childOrgIdList, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id");
        ArrayList newOrgList = Lists.newArrayListWithCapacity((int)childOrgIdList.size());
        Long orgId = orgDyn.getLong("id");
        Long belongComId = belongCompany.get(orgId);
        ArrayList nBelongList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject childDyn : childStructSortDynList) {
            Long adminOrgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"adminorg");
            DynamicObject orgChildDyn = childOrgDynMap.get(adminOrgId);
            Long adminOrgParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"parentorg");
            if (AdminOrgType.GROUP.getId() == orgDyn.getLong("adminorgtype.adminorgtypestd.id") || AdminOrgType.COMPANY.getId() == orgDyn.getLong("adminorgtype.adminorgtypestd.id") || nBelongList.contains(adminOrgParentId)) {
                nBelongList.add(adminOrgId);
                continue;
            }
            if (adminOrgId.equals(orgId)) continue;
            orgChildDyn.set("belongcompany", (Object)belongComId);
            orgChildDyn.set("bsed", (Object)effectDate);
            DynamicObject newDyn = new DynamicObject(orgChildDyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)orgChildDyn, (DynamicObject)newDyn);
            newOrgList.add(newDyn);
        }
        return newOrgList;
    }

    private List<DynamicObject> chgSortInfo(String index, DynamicObject orgDyn, Map<Long, DynamicObject> parentInfoSortDynMap, List<DynamicObject> childStructSortDynList, Date effectDate) {
        List<Long> childOrgIdList = childStructSortDynList.stream().map(childStructDyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childStructDyn, (String)"adminorg")).collect(Collectors.toList());
        LOGGER.info(String.format(Locale.ROOT, "chgSortInfo() childOrgIdList: %s", childOrgIdList));
        Map<Long, DynamicObject> childSortDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(childOrgIdList, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), "adminorg");
        LOGGER.info(String.format(Locale.ROOT, "chgSortInfo() childSortDynMap.keySet(): %s", childSortDynMap.keySet()));
        ArrayList newSortList = Lists.newArrayListWithCapacity((int)childOrgIdList.size());
        Long parentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)orgDyn, (String)"parentorg");
        Long orgId = orgDyn.getLong("id");
        for (DynamicObject childDyn : childStructSortDynList) {
            Long adminOrgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"adminorg");
            DynamicObject sortDyn = childSortDynMap.get(adminOrgId);
            Long adminOrgParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"parentorg");
            if (adminOrgId.equals(orgId)) {
                adminOrgParentId = parentId;
                sortDyn.set("index", (Object)index);
            } else {
                LOGGER.info(String.format(Locale.ROOT, "chgSortInfo() adminOrgId: %s, sortDyn: %s", adminOrgId, sortDyn));
                String childSort = sortDyn.getString("sortcode");
                index = childSort.substring(childSort.lastIndexOf(33) + 1);
            }
            DynamicObject parentSortDyn = parentInfoSortDynMap.get(adminOrgParentId);
            if (ObjectUtils.isEmpty((Object)parentSortDyn)) continue;
            String sortCode = this.getSortCodeByIndex(parentSortDyn.getString("sortcode"), index);
            sortDyn.set("sortcode", (Object)sortCode);
            sortDyn.set("bsed", (Object)effectDate);
            parentInfoSortDynMap.put(adminOrgId, sortDyn);
            DynamicObject newDyn = new DynamicObject(sortDyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)sortDyn, (DynamicObject)newDyn, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            newSortList.add(newDyn);
        }
        return newSortList;
    }

    private List<DynamicObject> chgStructInfo(DynamicObject orgDyn, Map<Long, DynamicObject> parentInfoStructDynMap, List<DynamicObject> childStructSortDynList, Date effectDate) {
        ArrayList newStructList = Lists.newArrayListWithCapacity((int)childStructSortDynList.size());
        for (DynamicObject childDyn : childStructSortDynList) {
            DynamicObject parentDyn;
            Long adminOrgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"adminorg");
            Long adminOrgParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"parentorg");
            if (adminOrgId.equals(orgDyn.getLong("id"))) {
                adminOrgParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)orgDyn, (String)"parentorg");
            }
            if (ObjectUtils.isEmpty((Object)(parentDyn = parentInfoStructDynMap.get(adminOrgParentId)))) continue;
            DynamicObject newDyn = new DynamicObject(childDyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)childDyn, (DynamicObject)newDyn);
            newDyn.set("parentorg", parentDyn.get("adminorg"));
            newDyn.set("structlongnumber", (Object)this.getStructLongNumber(childDyn.getString("structlongnumber"), parentDyn.getString("structlongnumber")));
            newDyn.set("level", (Object)(parentDyn.getInt("level") + 1));
            newDyn.set("bsed", (Object)effectDate);
            parentInfoStructDynMap.put(adminOrgId, newDyn);
            newStructList.add(newDyn);
        }
        return newStructList;
    }

    private List<DynamicObject> getChildStructSortDynList(Long orgId, Map<Long, DynamicObject> oldOrgStructInfoDynMap) {
        String structLongNumber = Optional.ofNullable(oldOrgStructInfoDynMap.get(orgId)).map(dynamicObject -> dynamicObject.getString("structlongnumber")).orElse("");
        if (StringUtils.isEmpty((CharSequence)structLongNumber)) {
            return Lists.newArrayList();
        }
        QFilter qFilter = this.getLikeQFilterByStructLongNumber(structLongNumber);
        DynamicObject[] childStructDynArrays = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()).loadDynamicObjectArray(new QFilter[]{qFilter});
        return Stream.of(childStructDynArrays).sorted(Comparator.comparingInt(o -> o.getInt("level"))).collect(Collectors.toList());
    }

    private Map<Long, Long> getBelongCompany(List<HisVersionParamBo> hisVersionParamBos) {
        List filterList = hisVersionParamBos.stream().filter(hisVersionParamBo -> AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey().equals(hisVersionParamBo.getEntityNumber())).collect(Collectors.toList());
        HashMap belongCompanyMap = Maps.newHashMapWithExpectedSize((int)16);
        for (HisVersionParamBo hisVersionParamBo2 : filterList) {
            belongCompanyMap.putAll(Arrays.stream(hisVersionParamBo2.getHisDyns()).collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"belongcompany"))));
        }
        return belongCompanyMap;
    }

    public QFilter getLikeQFilterByStructLongNumber(String structLongNumber) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        qFilter.and("structlongnumber", "like", (Object)(structLongNumber + "%"));
        return qFilter;
    }

    public String getStructLongNumber(String orgStructLongNumber, String parentStructLongNumber) {
        return parentStructLongNumber + "!" + orgStructLongNumber.substring(orgStructLongNumber.lastIndexOf(33) + 1);
    }

    private String getSortCodeByIndex(String sortCode, String index) {
        String fillIndex = AdminOrgHisServiceHelper.fillIndexWithZero(index);
        return sortCode + "!" + fillIndex;
    }
}

