/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.struct;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class AdminOrgStructService {
    private static final Log logger = LogFactory.getLog(AdminOrgStructService.class);
    private static final AdminOrgStructService orgStructService = new AdminOrgStructService();

    public static AdminOrgStructService getInstance() {
        return orgStructService;
    }

    public HisVersionParamBo buildSaveTempHisParam(DynamicObject[] dynamicObjects) {
        Map<Long, String> orgIdStructLongNumberMap = this.buildOrgStructLongNumber(dynamicObjects);
        ArrayList<DynamicObject> structDynVersionSaveList = new ArrayList<DynamicObject>(16);
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject adminStruct = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)adminStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            adminStruct.set("id", (Object)ids[index++]);
            adminStruct.set("boid", null);
            adminStruct.set("adminorg", (Object)dynamicObject);
            long curOrgId = dynamicObject.getLong("id");
            String curOrgStructLongNumber = orgIdStructLongNumberMap.get(curOrgId);
            adminStruct.set("structlongnumber", (Object)curOrgStructLongNumber);
            if (orgIdStructLongNumberMap.containsKey(curOrgId)) {
                adminStruct.set("isleaf", (Object)"0");
            }
            adminStruct.set("level", (Object)curOrgStructLongNumber.split("!").length);
            adminStruct.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            structDynVersionSaveList.add(adminStruct);
            if (!HRObjectUtils.isEmpty((Object)adminStruct.getDynamicObject("structproject"))) continue;
            adminStruct.set("structproject", (Object)1010L);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(structDynVersionSaveList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
    }

    public HisVersionParamBo buildTempNewHisParam(DynamicObject[] dynamicObjects, Map<String, Map<Long, DynamicObject>> adminOrgInfoMap) {
        if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        Set parentBoIdSet = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).map(dynamicObject -> dynamicObject.getLong("parentorg.id")).collect(Collectors.toSet());
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        currentFilter.and("adminorg", "in", parentBoIdSet);
        DynamicObject[] structInfoArr = structHelper.queryOriginalArray("adminorg, structlongnumber", new QFilter[]{currentFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        Map<Long, String> boStructLongNumberMap = Arrays.stream(structInfoArr).collect(Collectors.toMap(structInfo -> structInfo.getLong("adminorg"), structInfo -> structInfo.getString("structlongnumber"), (o1, o2) -> o1));
        ArrayList<DynamicObject> structDynVersionSaveList = new ArrayList<DynamicObject>(16);
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            long id;
            long adminOrgId = dynamicObject2.getLong("id");
            DynamicObject structInfo2 = null;
            if (adminOrgInfoMap != null) {
                Map<Long, DynamicObject> entityInfoMap = adminOrgInfoMap.get(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
                structInfo2 = entityInfoMap.get(adminOrgId);
            }
            Long boId = null;
            if (structInfo2 != null) {
                id = structInfo2.getLong("id");
                boId = structInfo2.getLong("boid");
            } else {
                id = ids[index++];
                structInfo2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
            }
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject2, (DynamicObject)structInfo2, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            structInfo2.set("id", (Object)id);
            structInfo2.set("boid", (Object)boId);
            structInfo2.set("adminorg", (Object)dynamicObject2);
            DynamicObject parentDynObj = dynamicObject2.getDynamicObject("parentorg");
            String structLongNumber = dynamicObject2.getString("structnumber");
            if (Objects.nonNull(parentDynObj)) {
                long parentId = parentDynObj.getLong("id");
                structInfo2.set("parentorg", (Object)parentDynObj);
                String parentStructLongNumber = boStructLongNumberMap.get(parentId);
                structLongNumber = parentStructLongNumber + "!" + structLongNumber;
                boStructLongNumberMap.put(adminOrgId, structLongNumber);
            }
            structInfo2.set("structlongnumber", (Object)structLongNumber);
            if (HRObjectUtils.isEmpty((Object)structInfo2.getDynamicObject("structproject"))) {
                structInfo2.set("structproject", (Object)1010L);
            }
            structInfo2.set("isleaf", (Object)"1");
            structInfo2.set("level", (Object)structLongNumber.split("!").length);
            structDynVersionSaveList.add(structInfo2);
            logger.info(String.format(Locale.ROOT, "buildTempNewHisParam structDynVersionSaveList size = %s", structDynVersionSaveList.size()));
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(structDynVersionSaveList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
    }

    public HisVersionParamBo buildAddNewHisParam(DynamicObject[] dynamicObjects) {
        if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        Map<Long, Long> orgIdMapParentId = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getDynamicObject("parentorg").getLong("id")));
        Map<Long, DynamicObject> idStructLongNumMap = AdminOrgHisServiceHelper.batchGetOrgParentStructDynObj(orgIdMapParentId, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg.id");
        ArrayList<DynamicObject> structDynVersionSaveList = new ArrayList<DynamicObject>(16);
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            long id = dynamicObject2.getLong("id");
            if (id == 0L) {
                id = ids[index];
            }
            DynamicObject adminStruct = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject2, (DynamicObject)adminStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            adminStruct.set("id", (Object)id);
            adminStruct.set("adminorg", (Object)dynamicObject2);
            DynamicObject parentDynObj = dynamicObject2.getDynamicObject("parentorg");
            Long parentId = null;
            if (Objects.nonNull(parentDynObj)) {
                parentId = parentDynObj.getLong("id");
                adminStruct.set("parentorg", (Object)parentDynObj);
            }
            DynamicObject parentStructDyn = idStructLongNumMap.get(parentId);
            String structLongNumber = dynamicObject2.getString("structnumber");
            if (Objects.nonNull(parentStructDyn)) {
                String parentStructLongNumber = parentStructDyn.getString("structlongnumber");
                structLongNumber = parentStructLongNumber + "!" + structLongNumber;
                boolean isLeaf = parentStructDyn.getBoolean("isleaf");
                if (isLeaf) {
                    parentStructDyn.set("isleaf", (Object)"0");
                    parentStructDyn.set("bsed", (Object)adminStruct.getDate("bsed"));
                    structDynVersionSaveList.add(parentStructDyn);
                }
            }
            adminStruct.set("structlongnumber", (Object)structLongNumber);
            adminStruct.set("isleaf", (Object)"1");
            adminStruct.set("level", (Object)structLongNumber.split("!").length);
            structDynVersionSaveList.add(adminStruct);
        }
        logger.info(String.format(Locale.ROOT, "111111AdminOrgStructService.buildAddNewHisParam() structDynVersionSaveList size = %s", structDynVersionSaveList.size()));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(structDynVersionSaveList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
    }

    private Map<Long, String> buildOrgStructLongNumber(DynamicObject[] dynamicObjects) {
        Map<Long, Long> orgIdMapParentId = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getDynamicObject("parentorg").getLong("id")));
        Map<Long, DynamicObject> orgIdMapDyn = Stream.of(dynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        Map<Long, DynamicObject> idStructLongNumMap = AdminOrgHisServiceHelper.batchGetOrgParentStructDynObj(orgIdMapParentId, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg.id");
        HashMap orgIdStructLongNumberMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        AdminOrgHisServiceHelper.constructOrgStructLongNumberOrSortCode(orgIdMapDyn, idStructLongNumMap, orgIdStructLongNumberMap, "structlongnumber", "structnumber", 0);
        return orgIdStructLongNumberMap;
    }
}

