/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.teamcoop;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamCoopRelService {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamCoopRelService.class);
    private static final OrgTeamCoopRelService orgTeamCoopRelService = new OrgTeamCoopRelService();

    public static OrgTeamCoopRelService getInstance() {
        return orgTeamCoopRelService;
    }

    public HisVersionParamBo buildAddNewHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap) {
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList<DynamicObject> orgTeamCoopRelList = new ArrayList<DynamicObject>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> TeamCoopRelBOList = orgTeamCoopRelEntry.getValue();
            for (TeamCoopRelBO teamCoopRelBO : TeamCoopRelBOList) {
                this.constructAndAddNewCoopRelDyn(orgTeamCoopRelList, teamCoopRelBO);
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    private void constructAndAddNewCoopRelDyn(List<DynamicObject> orgTeamCoopRelList, TeamCoopRelBO teamCoopRelBO) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
        long id = ORM.create().genLongId("haos_orgteamcooprel");
        dyn.set("id", (Object)id);
        dyn.set("enable", (Object)teamCoopRelBO.getEnable());
        dyn.set("status", (Object)"C");
        dyn.set("bsed", (Object)teamCoopRelBO.getEffDate());
        dyn.set("org", (Object)teamCoopRelBO.getOrgTeamId());
        dyn.set("coopreltype", (Object)teamCoopRelBO.getCoopTypeId());
        dyn.set("cooporgteam", (Object)teamCoopRelBO.getCoopTeamId());
        dyn.set("index", (Object)teamCoopRelBO.getIndex());
        dyn.set("initstatus", (Object)"2");
        orgTeamCoopRelList.add(dyn);
    }

    public HisVersionParamBo buildChangeHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effectDate) {
        return this.buildChangeHisParam(orgTeamCoopRelMap, effectDate, false);
    }

    public HisVersionParamBo buildChangeHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effectDate, boolean rootChangeFlag) {
        Map<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = AdminOrgHisServiceHelper.batchGetOldOrgCoopRelMap(orgTeamCoopRelMap.keySet());
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList<DynamicObject> orgTeamCoopRelList = new ArrayList<DynamicObject>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> newTeamCoopRelBOS = orgTeamCoopRelEntry.getValue();
            Map<Long, TeamCoopRelBO> changeIdTeamCoopRelMap = newTeamCoopRelBOS.stream().filter(teamCoopRelBO -> !teamCoopRelBO.getBoId().equals(0L)).collect(Collectors.toMap(TeamCoopRelBO::getBoId, teamCoopRelBO -> teamCoopRelBO));
            Long orgTeamId = orgTeamCoopRelEntry.getKey();
            List<TeamCoopRelBO> oldTeamCoopRelBOS = oldOrgTeamCoopRelMap.get(orgTeamId);
            LOGGER.info(String.format(Locale.ROOT, "buildChangeHisParam() orgTeamId: %s, and the size of oldTeamCoopRelBOS is %s", orgTeamId, oldTeamCoopRelBOS == null ? null : Integer.valueOf(oldTeamCoopRelBOS.size())));
            if (oldTeamCoopRelBOS == null) {
                oldTeamCoopRelBOS = new ArrayList<TeamCoopRelBO>(16);
                oldOrgTeamCoopRelMap.put(orgTeamId, oldTeamCoopRelBOS);
            }
            Map<Long, TeamCoopRelBO> oldIdTeamCoopRelBOMap = oldTeamCoopRelBOS.stream().collect(Collectors.toMap(TeamCoopRelBO::getBoId, teamCoopRelBO -> teamCoopRelBO));
            for (TeamCoopRelBO newTeamCoopRelBO : newTeamCoopRelBOS) {
                TeamCoopRelBO oldTeamCoopRelBO2;
                Long teamCoopRelId = newTeamCoopRelBO.getBoId();
                if (teamCoopRelId == 0L && (rootChangeFlag || newTeamCoopRelBO.getCoopTypeId() != 1010L)) {
                    this.constructAndAddNewCoopRelDyn(orgTeamCoopRelList, newTeamCoopRelBO);
                    continue;
                }
                if (newTeamCoopRelBO.getCoopTypeId().equals(1010L)) {
                    Optional<TeamCoopRelBO> oldOptionalTeamCoopRelBO = oldTeamCoopRelBOS.stream().filter(teamCoopRelBO -> teamCoopRelBO.getCoopTypeId().equals(1010L)).findFirst();
                    oldOptionalTeamCoopRelBO.ifPresent(oldTeamCoopRelBO -> {
                        if (!oldTeamCoopRelBO.getCoopTeamId().equals(newTeamCoopRelBO.getCoopTeamId()) || !HRStringUtils.equals((String)newTeamCoopRelBO.getEnable(), (String)oldTeamCoopRelBO.getEnable())) {
                            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
                            HRDynamicObjectUtils.copy((DynamicObject)oldTeamCoopRelBO.getOldTeamCoopRelDyn(), (DynamicObject)dynamicObject);
                            dynamicObject.set("cooporgteam", (Object)this.newDynamicOBjectWithId("haos_adminorgteam", newTeamCoopRelBO.getCoopTeamId()));
                            dynamicObject.set("bsed", (Object)effectDate);
                            dynamicObject.set("enable", (Object)newTeamCoopRelBO.getEnable());
                            orgTeamCoopRelList.add(dynamicObject);
                        }
                    });
                    continue;
                }
                if (!oldIdTeamCoopRelBOMap.containsKey(teamCoopRelId) || (oldTeamCoopRelBO2 = oldIdTeamCoopRelBOMap.get(teamCoopRelId)).getCoopTypeId().equals(newTeamCoopRelBO.getCoopTypeId()) && oldTeamCoopRelBO2.getCoopTeamId().equals(newTeamCoopRelBO.getCoopTeamId())) continue;
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
                HRDynamicObjectUtils.copy((DynamicObject)oldTeamCoopRelBO2.getOldTeamCoopRelDyn(), (DynamicObject)dynamicObject);
                dynamicObject.set("cooporgteam", (Object)this.newDynamicOBjectWithId("haos_adminorgteam", newTeamCoopRelBO.getCoopTeamId()));
                dynamicObject.set("coopreltype", (Object)this.newDynamicOBjectWithId("haos_teamcoopreltype", newTeamCoopRelBO.getCoopTypeId()));
                dynamicObject.set("bsed", (Object)effectDate);
                orgTeamCoopRelList.add(dynamicObject);
            }
            if (rootChangeFlag) {
                return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
            }
            for (TeamCoopRelBO oldTeamCoopRelBO3 : oldTeamCoopRelBOS) {
                if (changeIdTeamCoopRelMap.containsKey(oldTeamCoopRelBO3.getBoId()) || oldTeamCoopRelBO3.getCoopTypeId().equals(1010L)) continue;
                DynamicObject dynamicObject = AdminOrgHisServiceHelper.enableOrDisableEntity(oldTeamCoopRelBO3.getOldTeamCoopRelDyn(), "haos_orgteamcooprel", "0", effectDate);
                orgTeamCoopRelList.add(dynamicObject);
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    public HisVersionParamBo buildChangeHisParamOpenApi(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effectDate) {
        Map<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = AdminOrgHisServiceHelper.batchGetOldOrgCoopRelMapIgnoreEnable(orgTeamCoopRelMap.keySet());
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList orgTeamCoopRelList = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> newTeamCoopRelBOS = orgTeamCoopRelEntry.getValue();
            Long orgTeamId = orgTeamCoopRelEntry.getKey();
            List<TeamCoopRelBO> oldTeamCoopRelBOS = oldOrgTeamCoopRelMap.get(orgTeamId);
            LOGGER.info(String.format(Locale.ROOT, "buildChangeHisParam() orgTeamId: %s, and the size of oldTeamCoopRelBOS is %s", orgTeamId, oldTeamCoopRelBOS == null ? null : Integer.valueOf(oldTeamCoopRelBOS.size())));
            if (oldTeamCoopRelBOS == null) {
                oldTeamCoopRelBOS = new ArrayList<TeamCoopRelBO>(16);
                oldOrgTeamCoopRelMap.put(orgTeamId, oldTeamCoopRelBOS);
            }
            for (TeamCoopRelBO newTeamCoopRelBO : newTeamCoopRelBOS) {
                if (!newTeamCoopRelBO.getCoopTypeId().equals(1010L)) continue;
                Optional<TeamCoopRelBO> oldOptionalTeamCoopRelBO = oldTeamCoopRelBOS.stream().filter(teamCoopRelBO -> teamCoopRelBO.getCoopTypeId().equals(1010L)).findFirst();
                oldOptionalTeamCoopRelBO.ifPresent(oldTeamCoopRelBO -> {
                    if (!oldTeamCoopRelBO.getCoopTeamId().equals(newTeamCoopRelBO.getCoopTeamId()) || !HRStringUtils.equals((String)newTeamCoopRelBO.getEnable(), (String)oldTeamCoopRelBO.getEnable())) {
                        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
                        HRDynamicObjectUtils.copy((DynamicObject)oldTeamCoopRelBO.getOldTeamCoopRelDyn(), (DynamicObject)dynamicObject);
                        dynamicObject.set("cooporgteam", (Object)this.newDynamicOBjectWithId("haos_adminorgteam", newTeamCoopRelBO.getCoopTeamId()));
                        dynamicObject.set("bsed", (Object)effectDate);
                        dynamicObject.set("enable", (Object)newTeamCoopRelBO.getEnable());
                        orgTeamCoopRelList.add(dynamicObject);
                    }
                });
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    private DynamicObject newDynamicOBjectWithId(String entityNumber, long id) {
        DynamicObject newDynObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        newDynObj.set("id", (Object)id);
        return newDynObj;
    }
}

