/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgchangetransaction.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeOperateDetail;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeTransactionBaseModel;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeTransactionDetail;
import kd.hr.haos.business.service.orgchangetransaction.bean.FieldConvert;
import kd.hr.haos.business.service.orgchangetransaction.bean.MergeSplitDetail;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelInitHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelMergeHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelProjectHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelSimpleHandler;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ChangeTransactionContext {
    private static final Log logger = LogFactory.getLog(ChangeTransactionContext.class);
    private static final Map<String, TransactionModelHandler> entityHandlerMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Date createDate = new Date();
    private long boId = 0L;
    private DynamicObject[] orgChangeData;
    private DynamicObject[] mergeSplitDys;
    private long eventId;
    private long otClassifyId;
    private boolean isInit;
    private boolean isRetainAll = false;
    private long creator;
    private Date changeDate;
    private Map<Long, Long> beforeOrgId = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Long> afterOrgId = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<Long>> sceneSubMap;
    private List<ChangeTransactionBaseModel> transactionBaseModels;
    private Map<Long, ChangeTransactionBaseModel> operateDetailMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, ChangeTransactionBaseModel> changeTranDetailMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, ChangeTransactionBaseModel> changeTranSumMap = Maps.newHashMapWithExpectedSize((int)16);

    public static Map<String, TransactionModelHandler> getEntityHandlerMap() {
        return entityHandlerMap;
    }

    public ChangeTransactionContext(Long otClassifyId, Long eventId, boolean isInit, DynamicObject[] dynamicObjects, Map<Long, List<Long>> sceneSubMap) {
        this.orgChangeData = dynamicObjects;
        this.otClassifyId = otClassifyId;
        this.eventId = eventId;
        this.isInit = isInit;
        this.sceneSubMap = sceneSubMap;
        this.transactionBaseModels = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
    }

    public ChangeTransactionContext(Long otClassifyId, Long eventId, DynamicObject[] dynamicObjects, Map<Long, List<Long>> sceneSubMap, DynamicObject[] mergeSplitDys) {
        this(otClassifyId, eventId, false, dynamicObjects, sceneSubMap);
        this.mergeSplitDys = mergeSplitDys;
    }

    private TransactionModelHandler getTransactionHandler(String entityName) {
        if ("homs_ocbmergsplitentry".equals(entityName)) {
            this.isRetainAll = true;
        }
        if (this.isInit) {
            return new TransactionModelInitHandler();
        }
        return entityHandlerMap.get(entityName);
    }

    public boolean isRetainAll() {
        return this.isRetainAll && !CollectionUtils.isEmpty(this.transactionBaseModels);
    }

    public void buildTransactionModel() {
        for (int i = 0; i < this.orgChangeData.length; ++i) {
            DynamicObject dynamicObject = this.orgChangeData[i];
            String entityName = dynamicObject.getDataEntityType().getName();
            TransactionModelHandler transactionHandler = this.getTransactionHandler(entityName);
            if (transactionHandler == null) {
                logger.info(String.format("unknown entity name : %s for transaction model", entityName));
                continue;
            }
            this.creator = dynamicObject.getLong("creator.id");
            this.transactionBaseModels.addAll(transactionHandler.build(this, i));
        }
        this.transactionBaseModels.forEach(model -> {
            if (model instanceof ChangeOperateDetail) {
                this.operateDetailMap.put(model.getId(), (ChangeTransactionBaseModel)model);
            } else if (model instanceof ChangeTransactionDetail) {
                this.changeTranDetailMap.put(model.getId(), (ChangeTransactionBaseModel)model);
            } else {
                this.changeTranSumMap.put(model.getId(), (ChangeTransactionBaseModel)model);
            }
        });
    }

    public void buildTransactionModel2() {
        if (this.mergeSplitDys == null || this.mergeSplitDys.length == 0) {
            this.buildTransactionModel();
            return;
        }
        this.creator = this.mergeSplitDys[0].getLong("creator.id");
        Map<Long, DynamicObject> orgChangeDataMap = Arrays.stream(this.orgChangeData).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy));
        HashMap<Long, DynamicObject> multipleChangeTypeDyMap = new HashMap<Long, DynamicObject>(this.mergeSplitDys.length);
        HashMap<Long, MergeSplitDetail> mergeSplitDetailMap = new HashMap<Long, MergeSplitDetail>(this.mergeSplitDys.length);
        for (DynamicObject dy2 : this.mergeSplitDys) {
            MergeSplitDetail detail;
            Long orgId;
            this.buildMap(dy2.getLong("adminorg.id"), orgChangeDataMap, multipleChangeTypeDyMap);
            Long changeTypeId = dy2.getLong("changetype.id");
            if (changeTypeId.equals(ChangeTransactionConstants.CHANGE_TYPE_SPLIT)) {
                orgId = dy2.getLong("beforesplitorgid");
                detail = mergeSplitDetailMap.computeIfAbsent(orgId, k -> this.buildMergeSplitDetail(orgId, changeTypeId, dy2));
                if (0L == dy2.getLong("aftersplitorgid")) continue;
                detail.getSourceOrgIdList().add(dy2.getLong("aftersplitorgid"));
                continue;
            }
            orgId = dy2.getLong("aftermergeorgid");
            detail = mergeSplitDetailMap.computeIfAbsent(orgId, k -> this.buildMergeSplitDetail(orgId, changeTypeId, dy2));
            if (0L == dy2.getLong("beforemergeorgid")) continue;
            detail.getSourceOrgIdList().add(dy2.getLong("beforemergeorgid"));
        }
        this.transactionBaseModels.addAll(new TransactionModelMergeHandler(multipleChangeTypeDyMap, mergeSplitDetailMap.values()).build(this, 0));
        this.orgChangeData = orgChangeDataMap.values().toArray(new DynamicObject[0]);
        this.buildTransactionModel();
    }

    private void buildMap(Long adminOrgId, Map<Long, DynamicObject> orgChangeDataMap, Map<Long, DynamicObject> multipleChangeTypeDyMap) {
        DynamicObject dy = orgChangeDataMap.remove(adminOrgId);
        if (dy != null) {
            multipleChangeTypeDyMap.put(adminOrgId, dy);
        }
    }

    private MergeSplitDetail buildMergeSplitDetail(Long orgId, Long changeTypeId, DynamicObject dy) {
        return new MergeSplitDetail(orgId, changeTypeId, dy.getLong("changescene.id"), dy.getLong("changereason.id"), dy.getDate("bsed"));
    }

    public void transactionModelMerge() {
    }

    public void transactionModelSave() {
        HRBaseServiceHelper operateDetailHelper = new HRBaseServiceHelper("haos_changeoperdetail");
        HRBaseServiceHelper transactionDetailHelper = new HRBaseServiceHelper("haos_changetrandetail");
        HRBaseServiceHelper transactionSumHelper = new HRBaseServiceHelper("haos_changetransum");
        List<DynamicObject> operateDetailList = this.modelToDynamicObject(new ArrayList<ChangeTransactionBaseModel>(this.operateDetailMap.values()), operateDetailHelper);
        List<DynamicObject> changeTranDetailList = this.modelToDynamicObject(new ArrayList<ChangeTransactionBaseModel>(this.changeTranDetailMap.values()), transactionDetailHelper);
        List<DynamicObject> changeTranSumList = this.modelToDynamicObject(new ArrayList<ChangeTransactionBaseModel>(this.changeTranSumMap.values()), transactionSumHelper);
        if (!CollectionUtils.isEmpty(operateDetailList)) {
            operateDetailHelper.save(operateDetailList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(changeTranDetailList)) {
            transactionDetailHelper.save(changeTranDetailList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(changeTranSumList)) {
            transactionSumHelper.save(changeTranSumList.toArray(new DynamicObject[0]));
        }
    }

    public List<DynamicObject> modelToDynamicObject(List<ChangeTransactionBaseModel> modelList, HRBaseServiceHelper serviceHelper) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)modelList.size());
        try {
            for (ChangeTransactionBaseModel model : modelList) {
                Field[] fields;
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                for (Field field : fields = this.getAllFields(model.getClass())) {
                    DynamicObjectCollection mulBaseDate;
                    List values;
                    if (!field.isAnnotationPresent(FieldConvert.class)) continue;
                    String fieldName = field.getName();
                    String methodName = field.getType() == Boolean.TYPE ? fieldName : "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Method readMethod = model.getClass().getMethod(methodName, new Class[0]);
                    FieldConvert fieldConvert = field.getAnnotation(FieldConvert.class);
                    if (field.getType().isPrimitive() || field.getType() == Date.class) {
                        dynamicObject.set(fieldConvert.name(), readMethod.invoke((Object)model, new Object[0]));
                        continue;
                    }
                    if (field.getType() != List.class || CollectionUtils.isEmpty((Collection)(values = (List)readMethod.invoke((Object)model, new Object[0]))) || (mulBaseDate = dynamicObject.getDynamicObjectCollection(fieldConvert.name())) == null) continue;
                    DynamicObjectType objectType = mulBaseDate.getDynamicObjectType();
                    values.forEach(item -> {
                        DynamicObject dyn = new DynamicObject(objectType);
                        dyn.set("fbasedataid", item);
                        mulBaseDate.add((Object)dyn);
                    });
                }
                result.add(dynamicObject);
            }
        }
        catch (Exception error) {
            logger.error("TransactionModelService modelToDynamicObject error:" + error);
        }
        return result;
    }

    private Field[] getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    public void setModelCommonField(ChangeTransactionBaseModel model) {
        model.setId(this.getId());
        if (this.getCreator() != 0L) {
            model.setCreatorId(this.getCreator());
        } else {
            model.setCreatorId(RequestContext.get().getCurrUserId());
        }
        model.setCreateDate(this.getCreateDate());
        model.setEventId(this.getEventId());
        model.setChangeDate(this.getChangeDate());
        model.setBeforeOrgId(this.getBeforeOrgId(this.boId));
        model.setAfterOrgId(this.getAfterOrgId(this.boId));
        model.setOtClassifyId(this.getOtClassifyId());
        model.setDataSource(this.isInit ? 0L : 1L);
    }

    private Long getId() {
        return ID.genLongId();
    }

    public DynamicObject[] getOrgChangeData() {
        return this.orgChangeData;
    }

    public DynamicObject[] getMergeSplitDys() {
        return this.mergeSplitDys;
    }

    public long getOtClassifyId() {
        return this.otClassifyId;
    }

    public long getEventId() {
        return this.eventId;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public long getCreator() {
        return this.creator;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public long getBeforeOrgId() {
        return this.beforeOrgId.get(0L);
    }

    public long getBeforeOrgId(long boId) {
        return this.beforeOrgId.getOrDefault(boId, 0L);
    }

    public void setBeforeOrgId(long beforeOrgId) {
        this.beforeOrgId.put(0L, beforeOrgId);
    }

    public void setBeforeOrgId(Map<Long, Long> beforeOrgIdMap) {
        this.beforeOrgId = beforeOrgIdMap;
    }

    public void setBeforeOrgId(long boId, long beforeOrgId) {
        this.beforeOrgId.put(boId, beforeOrgId);
    }

    public void setAfterOrgId(long afterOrgId) {
        this.afterOrgId.put(0L, afterOrgId);
    }

    public void setAfterOrgId(Map<Long, Long> afterOrgIdMap) {
        this.afterOrgId = afterOrgIdMap;
    }

    public void setAfterOrgId(long boId, long afterOrgId) {
        this.afterOrgId.put(boId, afterOrgId);
    }

    public long getAfterOrgId(long boId) {
        return this.afterOrgId.getOrDefault(boId, 0L);
    }

    public long getAfterOrgId() {
        return this.afterOrgId.get(0L);
    }

    public Map<Long, List<Long>> getSceneSubMap() {
        return this.sceneSubMap;
    }

    public long getBoId() {
        return this.boId;
    }

    public void setBoId(long boId) {
        this.boId = boId;
    }

    static {
        entityHandlerMap.put("homs_batchorgentity", new TransactionModelSimpleHandler());
        entityHandlerMap.put("haos_projectgroupchange", new TransactionModelProjectHandler());
        entityHandlerMap.put("haos_projectgroupadd", new TransactionModelProjectHandler());
        entityHandlerMap.put("haos_projectgroupforbidde", new TransactionModelProjectHandler());
        entityHandlerMap.put("haos_projectgroupbase", new TransactionModelProjectHandler());
        entityHandlerMap.put("haos_projteambaseinfo", new TransactionModelProjectHandler());
        entityHandlerMap.put("haos_projteamcooprelalter", new TransactionModelProjectHandler());
    }
}

