/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgchangetransaction.service;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.orgchangetransaction.service.ChangeTransactionContext;
import kd.hr.haos.business.service.orgchangetransaction.service.IOpService;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class TransactionModelService
implements IOpService,
ProjectGroupMDConstants {
    private static final Log logger = LogFactory.getLog(TransactionModelService.class);
    private ChangeTransactionContext context;

    public TransactionModelService() {
    }

    public TransactionModelService(Long otClassifyId, Long eventId, boolean isInit, DynamicObject[] dynamicObjects, Map<Long, List<Long>> sceneSubMap) {
        this.context = new ChangeTransactionContext(otClassifyId, eventId, isInit, dynamicObjects, sceneSubMap);
        this.setBeforeAndAfterId(this.context);
    }

    @Override
    public ChangeTransactionContext getChangeTransactionContext() {
        return this.context;
    }

    @Override
    public void changeTransactionSave(Long otClassifyId, Long eventId, boolean isInit, DynamicObject[] dynamicObjects, Map<Long, List<Long>> sceneSubMap) {
        if (this.context == null) {
            this.context = new ChangeTransactionContext(otClassifyId, eventId, isInit, dynamicObjects, sceneSubMap);
        }
        String logInfo = String.format("change transaction save otClassifyId:%s, eventId:%s, isInit:%s", otClassifyId, eventId, isInit);
        logger.info(logInfo);
        this.changeTransactionSave();
    }

    @Override
    public void changeTransactionSave(Long otClassifyId, Long eventId, DynamicObject[] dynamicObjects, Map<Long, List<Long>> sceneSubMap) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        if (this.context == null) {
            Map<Boolean, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("changetype.id") == ChangeTransactionConstants.CHANGE_TYPE_SPLIT.longValue() || dy.getLong("changetype.id") == ChangeTransactionConstants.CHANGE_TYPE_MERGE.longValue()));
            DynamicObject[] mergeAndSplitDys = map.getOrDefault(Boolean.TRUE, Collections.emptyList()).toArray(new DynamicObject[0]);
            DynamicObject[] otherDys = map.getOrDefault(Boolean.FALSE, Collections.emptyList()).toArray(new DynamicObject[0]);
            this.context = new ChangeTransactionContext(otClassifyId, eventId, otherDys, sceneSubMap, mergeAndSplitDys);
        }
        this.context.buildTransactionModel2();
        this.context.transactionModelSave();
    }

    @Override
    public void changeTransactionSave() {
        if (this.context != null && this.context.getOrgChangeData() != null && this.context.getOrgChangeData().length != 0) {
            this.context.buildTransactionModel();
            if (this.context.isRetainAll()) {
                this.context.transactionModelMerge();
            }
            this.context.transactionModelSave();
        }
    }

    private void setBeforeAndAfterId(ChangeTransactionContext context) {
        String entity = context.getOrgChangeData()[0].getDataEntityType().getName();
        Set<String> entitys = ChangeTransactionContext.getEntityHandlerMap().keySet();
        if (entitys.stream().noneMatch(s -> s.startsWith("haos_project"))) {
            return;
        }
        long boId = context.getOrgChangeData()[0].getLong("boid");
        HashMap beforeProjectId = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dataEntity : context.getOrgChangeData()) {
            beforeProjectId.put(boId, dataEntity.getLong("sourcevid"));
        }
        context.setBeforeOrgId(beforeProjectId);
        Set boIds = Arrays.stream(context.getOrgChangeData()).map(s -> s.getLong("boid")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        QFilter idFilter = new QFilter("id", "in", boIds);
        String select = String.join((CharSequence)",", "sourcevid", "id");
        DynamicObject[] array = serviceHelper.queryOriginalArray(select, new QFilter[]{idFilter});
        Map<Long, Long> sourceMap = Arrays.stream(array).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("sourcevid")));
        context.setAfterOrgId(sourceMap);
    }
}

