/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.business.util.cascade.CycleCheckTree;
import kd.hr.haos.common.model.cascade.CycleCheckBo;
import kd.hr.haos.common.model.cascade.CycleCheckBoWithType;
import kd.hr.haos.common.model.cascade.CycleCheckResult;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;

public class CycleChecker {
    public CycleCheckResult check(List<CycleCheckBo> cycleCheckBoList) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        CycleCheckTree cycleCheckTree = CycleCheckTree.create(cycleCheckBoList);
        cycleCheckTree.traverse();
        CycleCheckResult result = cycleCheckTree.getResult();
        timeLogger.check("CycleChecker");
        return result;
    }

    public CycleCheckResult check(List<? extends CycleCheckBo> cycleCheckBoList, List<Long> startBoList) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        CycleCheckTree cycleCheckTree = CycleCheckTree.create(cycleCheckBoList);
        cycleCheckTree.traverse(startBoList);
        timeLogger.check("CycleChecker");
        return cycleCheckTree.getResult();
    }

    public List<CycleCheckResultWithType> checkWithType(List<CycleCheckBoWithType> cycleCheckBoWithTypeList, List<Long> startBoList) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        Map<Long, List<CycleCheckBoWithType>> relTypeVsCycleCheckBoList = cycleCheckBoWithTypeList.stream().collect(Collectors.groupingBy(CycleCheckBoWithType::getRelTypeId));
        List<CycleCheckResultWithType> result = relTypeVsCycleCheckBoList.entrySet().stream().map(entry -> {
            CycleCheckResult cycleCheckResult = this.check((List)entry.getValue(), startBoList);
            return new CycleCheckResultWithType(cycleCheckResult, ((Long)entry.getKey()).longValue());
        }).collect(Collectors.toList());
        timeLogger.check("CycleChecker");
        return result;
    }
}

