/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.util.BatchSynOtUtils;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.model.orgteam.EnablingModel;
import kd.hr.haos.common.util.DyCollectors;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OrgTeamEnablingService {
    public static final String OT_QUERY_FIELDS = "id, otclassify, createtime, sourcevid, boid, parent.id, parentid, bsed, bsled, structnumber, status, enable, initbatch, initdatasource, initstatus, billenable";
    private EnablingModel enablingModel;
    private DynamicObject structProjectDy;

    public void add() {
    }

    HisResponse<BatchVersionChangeRespData> synByParentChange(Set<Long> parentOtBoSet, long structProjectId) {
        DynamicObject[] ots = OTQueryRepository.getInstance().queryCurrentByParent(OT_QUERY_FIELDS, parentOtBoSet);
        if (ots.length == 0) {
            return new HisResponse();
        }
        this.enablingModel = new EnablingModel();
        this.enablingModel.setModifyParentList(Arrays.asList(ots));
        this.enablingModel.setSaveList(Arrays.asList(ots));
        this.enablingModel.setStructProjectId(structProjectId);
        if (this.getModifyParentList().size() != 0) {
            return this.modifyStruct();
        }
        return new HisResponse();
    }

    public HisResponse<BatchVersionChangeRespData> modify() {
        this.updateOt();
        if (this.getModifyParentList().size() != 0) {
            return this.modifyStruct();
        }
        return new HisResponse();
    }

    public void enable() {
        Date now = new Date();
        List otList = this.enablingModel.getSaveList();
        Set otBoSet = (Set)otList.stream().collect(DyCollectors.toBoIdSet());
        DynamicObject[] ots = OTQueryRepository.getInstance().queryAllDataByBo("id, enable, modifytime", otBoSet);
        Arrays.stream(ots).forEach(ot -> {
            ot.set("enable", (Object)"1");
            ot.set("modifytime", (Object)now);
        });
        SaveServiceHelper.update((DynamicObject[])ots);
        DynamicObject[] structs = OTStructRepository.getInstance().queryAllDataByOtBo("id, enable, modifytime", otBoSet, this.getStructProjectIdList4Query());
        Arrays.stream(structs).forEach(struct -> {
            struct.set("enable", (Object)"1");
            struct.set("modifytime", (Object)now);
        });
        SaveServiceHelper.update((DynamicObject[])structs);
    }

    private void updateOt() {
        Date now = new Date();
        List saveList = this.enablingModel.getSaveList();
        Map boIdVsOt = (Map)saveList.stream().collect(DyCollectors.toBoIdVsDy());
        DynamicObject[] dbOts = OTQueryRepository.getInstance().loadAllDataByBo(boIdVsOt.keySet());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgteam");
        Set propNameSet = dataEntityType.getProperties().stream().map(prop -> prop.getName()).collect(Collectors.toSet());
        Arrays.stream(dbOts).forEach(dbOt -> {
            DynamicObject ot = (DynamicObject)boIdVsOt.get(dbOt.getLong("boid"));
            dbOt.set("name", ot.get("name"));
            dbOt.set("number", ot.get("number"));
            dbOt.set("org", ot.get("org"));
            dbOt.set("parent", ot.get("parent"));
            dbOt.set("bsed", ot.get("bsed"));
            dbOt.set("firstbsed", ot.get("bsed"));
            dbOt.set("firstbsed", ot.get("bsed"));
            dbOt.set("modifytime", (Object)now);
            HRDynamicObjectUtils.copy((DynamicObject)ot, (DynamicObject)dbOt, (Set)propNameSet);
        });
        SaveServiceHelper.save((DynamicObject[])dbOts);
    }

    private HisResponse<BatchVersionChangeRespData> modifyStruct() {
        Map boIdVsOt = (Map)this.enablingModel.getSaveList().stream().collect(DyCollectors.toBoIdVsDy());
        DynamicObject[] structDys = OTStructRepository.getInstance().queryOriginalCurDataCascadeByOtBo("id, orgteam.id, structlongnumber", boIdVsOt.keySet(), this.getStructProjectIdList4Query());
        Set parentChgBoIdSet = (Set)this.getModifyParentList().stream().collect(DyCollectors.toBoIdSet());
        Set<String> parentChgSLN = Arrays.stream(structDys).filter(dy -> parentChgBoIdSet.contains(dy.getLong("orgteam.id"))).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
        DynamicObjectCollection cascadeStructDyCol = OTStructRepository.getInstance().queryAllEnablingDataColBySLN("id, boid, orgteam.id, parentorgteam.id, structlongnumber, bsed, bsled, structproject.id", parentChgSLN, this.getStructProjectIdList4Query());
        Set<Long> otBoSet = cascadeStructDyCol.stream().map(struct -> struct.getLong("orgteam.id")).collect(Collectors.toSet());
        if (cascadeStructDyCol.size() == 0) {
            return new HisResponse();
        }
        OTStructRepository.getInstance().deleteDataByOtBo(otBoSet, this.getStructProjectIdList4Query());
        DynamicObject[] cascadeOts = OTQueryRepository.getInstance().queryOrgById(OT_QUERY_FIELDS, otBoSet);
        Arrays.stream(cascadeOts).forEach(ot -> ot.set("parentid", (Object)ot.getLong("parent.id")));
        Map structProjectIdVsOtBoSet = cascadeStructDyCol.stream().collect(Collectors.groupingBy(dy -> dy.getLong("structproject.id"), Collectors.mapping(dy -> dy.getLong("orgteam.id"), Collectors.toSet())));
        structProjectIdVsOtBoSet.entrySet().stream().filter(entry -> (Long)entry.getKey() != 0L).forEach(entry -> {
            Long structProjectId = (Long)entry.getKey();
            Set otSet = (Set)entry.getValue();
            this.synOnlyStruct(parentChgBoIdSet, cascadeOts, otSet, structProjectId);
        });
        return null;
    }

    private void synOnlyStruct(Set<Long> parentChgBoIdSet, DynamicObject[] cascadeOts, Set<Long> curStructProjectIdOtBoSet, long structProjectId) {
        List modifyParentOtList4Scene = this.enablingModel.getSaveList().stream().filter(dy -> parentChgBoIdSet.contains(dy.getLong("boid"))).filter(dy -> curStructProjectIdOtBoSet.contains(dy.getLong("boid"))).map(BatchSynOtUtils.createNewOt4Scene()).collect(Collectors.toList());
        List notInChgParentCascadeOtList = Arrays.stream(cascadeOts).filter(dy -> !parentChgBoIdSet.contains(dy.getLong("boid"))).filter(dy -> curStructProjectIdOtBoSet.contains(dy.getLong("boid"))).collect(Collectors.toList());
        ArrayList saveList = new ArrayList();
        saveList.addAll(notInChgParentCascadeOtList);
        saveList.addAll(this.enablingModel.getSaveList().stream().filter(dy -> curStructProjectIdOtBoSet.contains(dy.getLong("boid"))).collect(Collectors.toList()));
        ArrayList newList = new ArrayList();
        newList.addAll(modifyParentOtList4Scene);
        newList.addAll(notInChgParentCascadeOtList);
        Map<Long, Long> firstVersionMap = Arrays.stream(cascadeOts).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("sourcevid")));
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        BatchSynModel batchSynModel = new BatchSynModel();
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        batchSynModel.setSaveList(saveList);
        batchSynModel.setNewList(newList);
        batchSynModel.setFirstVersionMap(firstVersionMap);
        batchSynModel.setStrucrProjectId(structProjectId);
        orgTeamBatchSynService.synOnlyStruct();
    }

    private List<DynamicObject> getModifyParentList() {
        return this.getNonNullOrEmptyList(this.enablingModel.getModifyParentList());
    }

    private List<DynamicObject> getModifyInfoList() {
        return this.getNonNullOrEmptyList(this.enablingModel.getModifyInfoList());
    }

    private List<DynamicObject> getEnableList() {
        return this.getNonNullOrEmptyList(this.enablingModel.getEnableList());
    }

    private List<DynamicObject> getNonNullOrEmptyList(List<DynamicObject> dynamicObjectList) {
        return dynamicObjectList == null ? Collections.emptyList() : dynamicObjectList;
    }

    public void setEnablingModel(EnablingModel enablingModel) {
        this.enablingModel = enablingModel;
    }

    private DynamicObject getStructProject() {
        if (this.structProjectDy == null) {
            this.structProjectDy = StructProjectRepository.getInstance().loadByIds(Collections.singletonList(this.enablingModel.getStructProjectId()))[0];
        }
        return this.structProjectDy;
    }

    private List<Long> getStructProjectIdList4Query() {
        long id = this.getStructProject().getLong("id");
        long relyOnStructProjectId = this.getStructProject().getLong("relyonstructproject.id");
        if (id == 1010L) {
            return Arrays.asList(1010L, 1020L, 1030L);
        }
        return Arrays.asList(id, relyOnStructProjectId);
    }
}

