/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.orgteam.OtherTeamStructService;
import kd.hr.haos.business.service.orgteam.model.OtCascadeBo;
import kd.hr.haos.business.service.orgteam.model.OtStructBo;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.cascade.MultiVersionTree;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OrgTeamReviseService {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamReviseService.class);
    private final BatchSynModel batchSynModel;

    public OrgTeamReviseService(BatchSynModel batchSynModel) {
        this.batchSynModel = batchSynModel;
    }

    public void revise() {
        List orgTeamDyList = this.batchSynModel.getSaveList();
        if (CollectionUtils.isEmpty((Collection)orgTeamDyList)) {
            LOGGER.info("no data");
            return;
        }
        List<DynamicObject> structDyList = this.buildStructDyList();
        structDyList = this.splitStructAndSetHisId(orgTeamDyList, structDyList);
        this.setDefaultValue(structDyList);
        OtherTeamStructService otherTeamStructService = new OtherTeamStructService();
        List<DynamicObject> otherStructList = otherTeamStructService.getOtherStructByOt(orgTeamDyList);
        structDyList.addAll(otherStructList);
        this.batchHisVersionChange(this.buildParamBoList(orgTeamDyList, structDyList));
        this.reviseFirstDate();
    }

    private List<DynamicObject> splitStructAndSetHisId(List<DynamicObject> orgTeamDyList, List<DynamicObject> structDyList) {
        Map<Long, List<DynamicObject>> structMap = structDyList.stream().collect(Collectors.groupingBy(struct -> struct.getLong("orgteam.id")));
        for (DynamicObject orgTeamDy : orgTeamDyList) {
            List<DynamicObject> list = structMap.get(orgTeamDy.getLong("boid"));
            if (CollectionUtils.isEmpty(list)) {
                throw new KDBizException("no find struct data---orgTeamId=" + orgTeamDy.getLong("boid"));
            }
            this.splitStructAndSetHisId(orgTeamDy, list);
        }
        return structMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void splitStructAndSetHisId(DynamicObject orgTeamDy, List<DynamicObject> structDyList) {
        LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(orgTeamDy);
        ListIterator<DynamicObject> it = structDyList.listIterator();
        while (it.hasNext()) {
            DynamicObject structDy = it.next();
            LocalDateRange structEffectRange = LocalDateRangeUtils.getEffectRange(structDy);
            if (!structEffectRange.overlaps(effectRange)) continue;
            if (effectRange.encloses(structEffectRange)) {
                structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
                continue;
            }
            this.splitStructData(it, structDy, effectRange, structEffectRange);
            structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
            if (structEffectRange.encloses(effectRange)) {
                LocalDateRangeUtils.setEffectRange(structDy, effectRange);
                return;
            }
            LocalDateRangeUtils.setEffectRange(structDy, structEffectRange.intersection(effectRange));
        }
    }

    private void splitStructData(ListIterator<DynamicObject> it, DynamicObject structDy, LocalDateRange effectRange, LocalDateRange structEffectRange) {
        List<LocalDateRange> list = this.splitEffectRange(effectRange, structEffectRange);
        for (LocalDateRange dateRange : list) {
            DynamicObject newDy = new DynamicObject(structDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newDy);
            LocalDateRangeUtils.setEffectRange(newDy, dateRange);
            it.add(newDy);
        }
    }

    private List<LocalDateRange> splitEffectRange(LocalDateRange effectRange, LocalDateRange structEffectRange) {
        ArrayList<LocalDateRange> list = new ArrayList<LocalDateRange>(2);
        if (structEffectRange.getStart().compareTo(effectRange.getStart()) < 0) {
            list.add(LocalDateRange.of((LocalDate)structEffectRange.getStart(), (LocalDate)effectRange.getStart()));
        }
        if (structEffectRange.getEnd().compareTo(effectRange.getEnd()) > 0) {
            list.add(LocalDateRange.of((LocalDate)effectRange.getEnd(), (LocalDate)structEffectRange.getEnd()));
        }
        return list;
    }

    private void reviseFirstDate() {
        DynamicObject[] orgTeamDys;
        Map esDateBoIdMap = this.batchSynModel.getEsDateBoIdMap();
        if (CollectionUtils.isEmpty((Map)esDateBoIdMap)) {
            return;
        }
        for (DynamicObject orgTeamDy : orgTeamDys = OTQueryRepository.getInstance().queryByBoIdAndDataStatus("id,boid,firstbsed", esDateBoIdMap.keySet(), Arrays.asList(EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()))) {
            orgTeamDy.set("firstbsed", esDateBoIdMap.get(orgTeamDy.getLong("boid")));
        }
        OTQueryRepository.getInstance().save(orgTeamDys);
    }

    private List<HisVersionParamBo> buildParamBoList(List<DynamicObject> orgTeamDyList, List<DynamicObject> structDyList) {
        ArrayList<HisVersionParamBo> hisBoList = new ArrayList<HisVersionParamBo>(2);
        HisVersionParamBo paramBo = AdminOrgHisServiceHelper.getHisVersionParam(orgTeamDyList.toArray(new DynamicObject[0]), "haos_adminorgteam", false);
        paramBo.setNeedProcessAttachment(false);
        hisBoList.add(paramBo);
        paramBo = AdminOrgHisServiceHelper.getHisVersionParam(structDyList.toArray(new DynamicObject[0]), "haos_adminorgstructure", false);
        paramBo.setNeedProcessAttachment(false);
        hisBoList.add(paramBo);
        return hisBoList;
    }

    private List<DynamicObject> buildStructDyList() {
        if (CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgParentList())) {
            return this.buildOtherStructDyList();
        }
        CascadeResult result = this.getCascadeResult();
        Set<Long> idSet = result.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
        Map<Long, DynamicObject> map = Arrays.stream(OTStructRepository.getInstance().loadByIds(idSet)).collect(Collectors.toMap(struct -> struct.getLong("id"), obj -> obj));
        DynamicObject orgTeamDy = (DynamicObject)this.batchSynModel.getChgParentList().get(0);
        List<DynamicObject> structDyList = result.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(partBo -> {
            OtStructBo structBo = (OtStructBo)((Object)partBo);
            DynamicObject hisDy = (DynamicObject)map.get(structBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            LocalDateRangeUtils.setEffectRange(newDy, partBo.getEffectRange());
            newDy.set("structlongnumber", (Object)structBo.getSLN());
            newDy.set("sourcevid", (Object)structBo.getVid());
            if (orgTeamDy.getLong("boid") == newDy.getLong("orgteam.id")) {
                this.setParent(newDy, orgTeamDy.getLong("parent.id"));
            }
            return newDy;
        }).collect(Collectors.toList());
        this.addNoParentData(structDyList, orgTeamDy);
        return structDyList;
    }

    private List<DynamicObject> buildOtherStructDyList() {
        if (CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgInfoList())) {
            return new ArrayList<DynamicObject>(0);
        }
        DynamicObject chgInfoDy = (DynamicObject)this.batchSynModel.getChgInfoList().get(0);
        Long orgTeamId = chgInfoDy.getLong("boid");
        List orgTeamDyList = this.batchSynModel.getSaveList();
        Set<Long> orgTeamIdSet = orgTeamDyList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        DynamicObject[] hisStructs = OTStructRepository.getInstance().loadHisByBoDate(orgTeamIdSet, chgInfoDy.getDate("bsed"), chgInfoDy.getDate("bsled"));
        List<DynamicObject> newStructList = Arrays.stream(hisStructs).map(hisDy -> {
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            newDy.set("sourcevid", (Object)hisDy.getLong("id"));
            return newDy;
        }).collect(Collectors.toList());
        Date esDate = this.getEsDate(orgTeamId);
        if (esDate == null) {
            return newStructList;
        }
        Map<Long, List<DynamicObject>> hisStructMap = newStructList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        this.setStartDate(esDate, hisStructMap.get(orgTeamId));
        orgTeamDyList = orgTeamDyList.stream().filter(dy -> dy.getLong("boid") == orgTeamId.longValue()).collect(Collectors.toList());
        DynamicObject firstDy = hisStructMap.get(orgTeamId).get(0);
        if (firstDy.getString("structlongnumber").equals(((DynamicObject)orgTeamDyList.get(0)).getString("structnumber"))) {
            return newStructList;
        }
        Optional<DynamicObject> orgTeamOp = orgTeamDyList.stream().filter(dy -> dy.get("parent") == null).findFirst();
        if (orgTeamOp.isPresent()) {
            DynamicObject noParentDy = orgTeamOp.get();
            DynamicObject newDy = new DynamicObject(firstDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)firstDy, (DynamicObject)newDy);
            newDy.set("bsled", (Object)noParentDy.getDate("bsled"));
            newDy.set("structlongnumber", (Object)noParentDy.getString("structnumber"));
            newDy.set("parentorgteam", null);
            firstDy.set("bsed", (Object)HRDateTimeUtils.addDay((Date)noParentDy.getDate("bsled"), (long)1L));
            newStructList.add(newDy);
        }
        return newStructList;
    }

    private void addNoParentData(List<DynamicObject> structDyList, DynamicObject orgTeamDy) {
        Date esDate = this.getEsDate(orgTeamDy.getLong("boid"));
        if (esDate == null) {
            return;
        }
        List chgParentStructList = structDyList.stream().filter(structDy -> orgTeamDy.getLong("boid") == structDy.getLong("orgteam.id")).sorted(Comparator.comparing(o -> o.getDate("bsed"))).collect(Collectors.toList());
        DynamicObject firstDy = (DynamicObject)chgParentStructList.get(0);
        if (firstDy.getDate("bsed").compareTo(esDate) > 0) {
            DynamicObject newDy = new DynamicObject(firstDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)firstDy, (DynamicObject)newDy);
            newDy.set("bsed", (Object)esDate);
            newDy.set("bsled", (Object)HRDateTimeUtils.addDay((Date)firstDy.getDate("bsed"), (long)-1L));
            newDy.set("structlongnumber", (Object)orgTeamDy.getString("structnumber"));
            newDy.set("parentorgteam", null);
            structDyList.add(newDy);
        }
    }

    private void setParent(DynamicObject newDy, Long boId) {
        DynamicObject parentAdminOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgstructure"));
        parentAdminOrg.set("id", (Object)boId);
        parentAdminOrg.set("boid", (Object)boId);
        newDy.set("parentorgteam", (Object)parentAdminOrg);
    }

    private CascadeResult getCascadeResult() {
        List<OtCascadeBo> otCascadeBoList = this.getOtCascadeBoList();
        MultiVersionTree multiVersionTree = MultiVersionTree.create(otCascadeBoList);
        multiVersionTree.traverse();
        return multiVersionTree.getResult();
    }

    private List<OtCascadeBo> getOtCascadeBoList() {
        DynamicObjectCollection hisStructList = this.queryStructCol();
        return hisStructList.stream().map(structDy -> {
            String structLongNumber = structDy.getString("structlongnumber");
            OtCascadeBo otCascadeBo = new OtCascadeBo();
            otCascadeBo.setBo(structDy.getLong("orgteam.id"));
            otCascadeBo.setParentBo(structDy.getLong("parentorgteam.id"));
            otCascadeBo.setEffectRange(LocalDateRangeUtils.getEffectRange(structDy));
            int i = structLongNumber.lastIndexOf("!");
            otCascadeBo.setStructNumber(i != -1 ? structLongNumber.substring(i + 1) : structLongNumber);
            OtStructBo otStructBo = new OtStructBo();
            otStructBo.setVid(structDy.getLong("id"));
            otStructBo.setEffectRange(otCascadeBo.getEffectRange());
            otStructBo.setSLN(structLongNumber);
            ArrayList<OtStructBo> otStructBoList = new ArrayList<OtStructBo>();
            otStructBoList.add(otStructBo);
            otCascadeBo.setOtStructBoList(otStructBoList);
            return otCascadeBo;
        }).collect(Collectors.toList());
    }

    private DynamicObjectCollection queryStructCol() {
        DynamicObject dy = (DynamicObject)this.batchSynModel.getChgParentList().get(0);
        Long orgTeamId = dy.getLong("boid");
        Date esDate = this.getEsDate(orgTeamId);
        Date startDate = esDate == null ? dy.getDate("bsed") : esDate;
        Date endDate = dy.getDate("bsled");
        DynamicObjectCollection structCol = OTStructRepository.getInstance().queryHisColByBoDate(Sets.newHashSet((Object[])new Long[]{orgTeamId, dy.getLong("parent.id")}), startDate, endDate);
        Map booleanMap = structCol.stream().collect(Collectors.groupingBy(struct -> dy.getLong("boid") == struct.getLong("orgteam.id"), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
        DynamicObjectCollection allStructCol = OTStructRepository.getInstance().queryHisColBySLN(booleanMap.get(Boolean.TRUE), booleanMap.get(Boolean.FALSE), startDate, endDate);
        List<DynamicObject> chgParentStructList = allStructCol.stream().filter(structDy -> dy.getLong("boid") == structDy.getLong("orgteam.id")).collect(Collectors.toList());
        this.setStartDate(esDate, chgParentStructList);
        chgParentStructList.forEach(structDy -> {
            structDy.set("parentorgteam.id", (Object)dy.getLong("parent.id"));
            if (structDy.getDate("bsled").compareTo(endDate) > 0) {
                structDy.set("bsled", (Object)endDate);
            }
            if (structDy.getDate("bsed").compareTo(startDate) < 0) {
                structDy.set("bsed", (Object)startDate);
            }
        });
        return allStructCol;
    }

    private void setStartDate(Date esDate, List<DynamicObject> list) {
        if (esDate == null || CollectionUtils.isEmpty(list)) {
            return;
        }
        list.sort(Comparator.comparing(o -> o.getDate("bsed")));
        list.get(0).set("bsed", (Object)esDate);
    }

    private Date getEsDate(Long boId) {
        return CollectionUtils.isEmpty((Map)this.batchSynModel.getEsDateBoIdMap()) ? null : (Date)this.batchSynModel.getEsDateBoIdMap().get(boId);
    }

    private void batchHisVersionChange(List<HisVersionParamBo> hisBoList) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(Long.valueOf(this.batchSynModel.getEventId()));
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private void setDefaultValue(List<DynamicObject> structDyList) {
        Date date = new Date();
        structDyList.forEach(structDy -> {
            structDy.set("createtime", (Object)date);
            structDy.set("level", (Object)structDy.getString("structlongnumber").split("!").length);
        });
    }
}

