/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgChgStructService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.util.StructLongNumberUtil;
import kd.hr.haos.common.util.tree.Tree;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import org.apache.commons.collections4.CollectionUtils;

public class OrgTeamSynService
implements ProjectGroupMDConstants {
    private static final String PAGE_HAOS_NUMBERPREFIX_CACHE_KEY = "haos_numberprefix";
    private static final String APP_KEY = "haos";
    private static final String PAGE_HSS_NUMBERPREFIX = "hbss_numberprefix";
    private static final String TYPE = "type";
    private static final String TEAMTYPE = "teamtype";
    private static final String ORGTYPE = "orgtype";
    private static final String NUMBER_PREFIX = "numberprefix";
    private static OrgTeamSynService service = new OrgTeamSynService();
    public static final OrgTeamBasicInfoBO PRJ_ORG_TEAM_BASIC_INFO_BO = new OrgTeamBasicInfoBO(1010L, 1020L, 1020L, 1020L, "orgteam.id", "parentorg");

    public static OrgTeamSynService getInstance() {
        return service;
    }

    public List<HisVersionParamBo> addNewSync(DynamicObject[] orgDynamicObjects, DynamicObject[] orgStructDynamicObjects, Long eventId, OrgTeamBasicInfoBO teamBasicInfoBO) {
        List<Long> newOrgIdList = Stream.of(orgDynamicObjects).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        HisVersionParamBo orgTeamHisParam = this.buildAddNewOrgTeamHisParam(orgDynamicObjects, teamBasicInfoBO);
        HisVersionParamBo orgTeamStructHisParam = this.buildAddNewOrgTeamStructHisParam(orgStructDynamicObjects, newOrgIdList, teamBasicInfoBO);
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        ArrayList<HisVersionParamBo> hisVersionParamBoLis = new ArrayList<HisVersionParamBo>();
        hisVersionParamBoLis.add(orgTeamHisParam);
        hisVersionParamBoLis.add(orgTeamStructHisParam);
        hisVersionParamListBo.setListHisVersionParamBo(hisVersionParamBoLis);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        return hisVersionParamBoLis;
    }

    public void syncNewOrgTeam(List<DynamicObject> mainOrgTeamDynList, Long eventId, OrgTeamBasicInfoBO orgTeamBasicInfoBO) {
        if (mainOrgTeamDynList == null || mainOrgTeamDynList.size() == 0) {
            return;
        }
        HisVersionParamListBo hisVersionParamListBos = new HisVersionParamListBo();
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBos.setEventId(eventId);
        }
        long[] dataVerIdArr = AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.get();
        hisVersionParamListBos.setAtomicTrans(false);
        ArrayList<HisVersionParamBo> hisParamBoList = new ArrayList<HisVersionParamBo>(mainOrgTeamDynList.size());
        HisVersionParamBo orgTeamHisParam = OrgTeamSynService.getInstance().buildAddNewOrgTeamHisParam(mainOrgTeamDynList.toArray(new DynamicObject[0]), orgTeamBasicInfoBO);
        HashMap<Long, Long> idVsPidMap = new HashMap<Long, Long>(mainOrgTeamDynList.size());
        HashSet<Long> needQueryPIdSet = new HashSet<Long>(mainOrgTeamDynList.size());
        HashMap<Long, DynamicObject> curOrgTeamDynMap = new HashMap<Long, DynamicObject>(mainOrgTeamDynList.size());
        for (DynamicObject dyn : mainOrgTeamDynList) {
            Long pId = dyn.getLong("parent.id");
            Long id = dyn.getLong("id");
            idVsPidMap.put(id, pId);
            needQueryPIdSet.add(pId);
            curOrgTeamDynMap.put(id, dyn);
        }
        for (Long id : idVsPidMap.keySet()) {
            needQueryPIdSet.remove(id);
        }
        Map<Long, DynamicObject> structDynMap = AdminOrgHisServiceHelper.getStructDynMap("haos_adminorgstructure", "orgteam.id", needQueryPIdSet);
        Tree tree = new Tree(idVsPidMap);
        List orgTeamIdOrderList = tree.levelTraverse();
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgteam");
        HashMap<Long, DynamicObject> allStructDynMap = new HashMap<Long, DynamicObject>(mainOrgTeamDynList.size());
        Date effectDate = mainOrgTeamDynList.get(0).getDate("bsed");
        ArrayList<DynamicObject> structDynList = new ArrayList<DynamicObject>(16);
        long[] ids = ORM.create().genLongIds("haos_adminorgstructure", mainOrgTeamDynList.size());
        int index = 0;
        ArrayList customizedFiledValueList = new ArrayList(16);
        HRBaseServiceHelper otClassifyHelper = new HRBaseServiceHelper("haos_otclassify");
        DynamicObject otClassifyDyn = otClassifyHelper.generateEmptyDynamicObject();
        otClassifyDyn.set("id", (Object)orgTeamBasicInfoBO.getOtClassify());
        for (Long orgTeamId : orgTeamIdOrderList) {
            DynamicObject curMainDyn = (DynamicObject)curOrgTeamDynMap.get(orgTeamId);
            Long newPId = curMainDyn.getLong("parent.id");
            DynamicObject parentDyn = structDynMap.get(newPId);
            if (null == parentDyn) {
                parentDyn = (DynamicObject)allStructDynMap.get(newPId);
            }
            DynamicObject newCurStructDyn = this.getNewOrgTeamStructDyn(structHelper, orgTeamHelper, effectDate, orgTeamId, curMainDyn, parentDyn);
            newCurStructDyn.set("id", (Object)ids[index]);
            newCurStructDyn.set("orgteamhisid", (Object)orgTeamId);
            newCurStructDyn.set("otclassify", (Object)otClassifyDyn);
            allStructDynMap.put(orgTeamId, newCurStructDyn);
            structDynList.add(newCurStructDyn);
            HashMap<String, Long> customizedFiledValueMap = new HashMap<String, Long>(8);
            customizedFiledValueMap.put("orgteamhisid", dataVerIdArr[index]);
            customizedFiledValueList.add(customizedFiledValueMap);
            ++index;
        }
        HisVersionParamBo structHis = this.getHisVersionParam(structDynList.toArray(new DynamicObject[0]), "haos_adminorgstructure", false);
        hisParamBoList.add(orgTeamHisParam);
        hisParamBoList.add(structHis);
        structHis.setCustomizedFiledValue(customizedFiledValueList);
        structHis.setFirstVersionIds(dataVerIdArr);
        hisVersionParamListBos.setListHisVersionParamBo(hisParamBoList);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBos);
    }

    private DynamicObject getNewOrgTeamStructDyn(HRBaseServiceHelper structHelper, HRBaseServiceHelper orgTeamHelper, Date effectDate, Long orgTeamId, DynamicObject curMainDyn, DynamicObject parentDyn) {
        DynamicObject newCurStructDyn = structHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)parentDyn, (DynamicObject)newCurStructDyn);
        String dbParentLongNumber = parentDyn.getString("structlongnumber");
        String newLongNumber = dbParentLongNumber + "!" + curMainDyn.getString("structnumber");
        newCurStructDyn.set("structlongnumber", (Object)newLongNumber);
        newCurStructDyn.set("parentorgteam", (Object)parentDyn.getDynamicObject("orgteam"));
        newCurStructDyn.set("level", (Object)newLongNumber.split("!").length);
        newCurStructDyn.set("bsed", (Object)effectDate);
        newCurStructDyn.set("firstbsed", (Object)effectDate);
        DynamicObject orgTeamDyn = orgTeamHelper.generateEmptyDynamicObject();
        orgTeamDyn.set("id", (Object)orgTeamId);
        newCurStructDyn.set("orgteam", (Object)orgTeamDyn);
        newCurStructDyn.set("boid", null);
        newCurStructDyn.set("enable", (Object)"1");
        newCurStructDyn.set("status", (Object)"C");
        newCurStructDyn.set("initstatus", (Object)"2");
        newCurStructDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        newCurStructDyn.set("createtime", (Object)new Date());
        newCurStructDyn.set("initbatch", (Object)0L);
        newCurStructDyn.set("initdatasource", (Object)"0");
        newCurStructDyn.set("structproject", (Object)1020L);
        newCurStructDyn.set("structproject_id", (Object)1020L);
        newCurStructDyn.set("sourcevid", (Object)0L);
        return newCurStructDyn;
    }

    public HisVersionParamBo getHisVersionParam(DynamicObject[] hisDynArr, String entityNumber, boolean isAtomicTrans) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(entityNumber);
        hisVersionParamBo.setAtomicTrans(isAtomicTrans);
        hisVersionParamBo.setHisDyns(hisDynArr);
        return hisVersionParamBo;
    }

    public void disableSync(DynamicObject[] orgDynArrays, Long eventId) {
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>();
        HisVersionParamBo orgTeamDisableHisParamBo = AdminOrgHisServiceHelper.buildDisableHisVersionParam(orgDynArrays, eventId, "haos_adminorgteam", "id");
        listHisVersionParamBo.add(orgTeamDisableHisParamBo);
        HisVersionParamBo orgTeamStructHisParamBo = AdminOrgHisServiceHelper.buildDisableHisVersionParam(orgDynArrays, eventId, "haos_adminorgstructure", "orgteam");
        listHisVersionParamBo.add(orgTeamStructHisParamBo);
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        hisVersionParamListBo.setAtomicTrans(false);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public HisVersionParamBo buildAddNewOrgTeamHisParam(DynamicObject[] dysArrays, OrgTeamBasicInfoBO orgTeamBasicInfoBO) {
        DynamicObject[] adminOrgTeamArr = new DynamicObject[dysArrays.length];
        String orgTeamNumberPrefix = OrgTeamSynService.getNumberByPrefixId(orgTeamBasicInfoBO.getPrefixId());
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject orgTeam;
            adminOrgTeamArr[i] = orgTeam = this.createAddNewOrgTeam(dysArrays[i], orgTeamBasicInfoBO, orgTeamNumberPrefix);
        }
        if (AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.get() != null) {
            Map<Long, Long> boIdToVid = AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.get();
            long[] firstVersionIds = new long[adminOrgTeamArr.length];
            for (Map.Entry<Long, Long> entry : boIdToVid.entrySet()) {
                Long key = entry.getKey();
                Long value = entry.getValue();
                for (int idx = 0; idx < adminOrgTeamArr.length; ++idx) {
                    if (!key.equals(adminOrgTeamArr[idx].getLong("id"))) continue;
                    firstVersionIds[idx] = value;
                }
            }
            AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(adminOrgTeamArr, "haos_adminorgteam", false);
    }

    public DynamicObject createAddNewOrgTeam(DynamicObject mainDyn, OrgTeamBasicInfoBO orgTeamBasicInfoBO, String numberPrefix) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        DynamicObject adminOrgTeam = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)mainDyn, (DynamicObject)adminOrgTeam);
        adminOrgTeam.set("id", (Object)mainDyn.getLong("id"));
        adminOrgTeam.set("number", (Object)(numberPrefix + "_" + mainDyn.getString("number")));
        adminOrgTeam.set("boid", null);
        adminOrgTeam.set(TEAMTYPE, (Object)orgTeamBasicInfoBO.getTeamType());
        adminOrgTeam.set(ORGTYPE, (Object)orgTeamBasicInfoBO.getOrgType());
        adminOrgTeam.set("parent", mainDyn.get(orgTeamBasicInfoBO.getParentKeyField()));
        adminOrgTeam.set("otclassify", (Object)orgTeamBasicInfoBO.getOtClassify());
        adminOrgTeam.set("bsed", (Object)mainDyn.getDate("bsed"));
        adminOrgTeam.set("firstbsed", (Object)mainDyn.getDate("firstbsed"));
        adminOrgTeam.set("enable", (Object)mainDyn.getString("enable"));
        adminOrgTeam.set("status", (Object)"C");
        adminOrgTeam.set("initstatus", (Object)mainDyn.getString("initstatus"));
        adminOrgTeam.set("org", mainDyn.get("org"));
        return adminOrgTeam;
    }

    public static String getOrgTeamNumberPrefix(Long numberPrefix) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_HSS_NUMBERPREFIX);
        DynamicObject dynamicObject = serviceHelper.queryOne(NUMBER_PREFIX, (Object)numberPrefix);
        return dynamicObject.getString(NUMBER_PREFIX);
    }

    public HisVersionParamBo buildAddNewOrgTeamStructHisParam(DynamicObject[] dynamicObjects, List<Long> newOrgIdList, OrgTeamBasicInfoBO teamBasicInfoBO) {
        ArrayList<DynamicObject> orgTeamStructDynObjList = new ArrayList<DynamicObject>();
        long[] ids = ORM.create().genLongIds("haos_adminorgstructure", dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!newOrgIdList.contains(dynamicObject.getLong(teamBasicInfoBO.getKeyField()))) continue;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            DynamicObject orgTeamStruct = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)orgTeamStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            orgTeamStruct.set("id", (Object)ids[index++]);
            orgTeamStruct.set("boid", null);
            orgTeamStruct.set("orgteam", (Object)dynamicObject.getLong(teamBasicInfoBO.getKeyField()));
            orgTeamStruct.set("orgteamhisid", (Object)(AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.get() != null ? AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.get().get(dynamicObject.getLong("adminorg.id")) : Long.valueOf(0L)));
            orgTeamStruct.set("otclassify", (Object)1010L);
            DynamicObject parentOrgDyn = dynamicObject.getDynamicObject(teamBasicInfoBO.getParentKeyField());
            long parentOrgId = 0L;
            if (Objects.nonNull(parentOrgDyn)) {
                parentOrgId = parentOrgDyn.getLong("id");
                orgTeamStruct.set("parentorgteam", (Object)parentOrgId);
            }
            orgTeamStructDynObjList.add(orgTeamStruct);
        }
        List customizedFiledValue = null;
        if (AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP != null) {
            Map[] customizedFiledValueArray = new Map[orgTeamStructDynObjList.size()];
            Map<Long, Long> boIdToId = AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.get();
            for (Map.Entry<Long, Long> entry : boIdToId.entrySet()) {
                Long key = entry.getKey();
                Long value = entry.getValue();
                for (int idx = 0; idx < orgTeamStructDynObjList.size(); ++idx) {
                    if (!key.equals(((DynamicObject)orgTeamStructDynObjList.get(idx)).getLong("orgteam"))) continue;
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put("orgteamhisid", value);
                    ((DynamicObject)orgTeamStructDynObjList.get(idx)).set("orgteamhisid", (Object)key);
                    customizedFiledValueArray[idx] = map;
                }
            }
            customizedFiledValue = Arrays.stream(customizedFiledValueArray).collect(Collectors.toList());
            AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.remove();
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamStructDynObjList.toArray(new DynamicObject[0]), "haos_adminorgstructure", false, customizedFiledValue);
    }

    public void orgChgSync(DynamicObject[] dynArrays, List<HisVersionParamBo> hisVersionParamBos, String caller) {
        Long numberPrefix = this.getNumberPrefix(caller);
        List<DynamicObject> orgTeamChgInfo = this.orgChgInfo(dynArrays, numberPrefix);
        List<DynamicObject> orgTeamChgParentInfo = this.orgChgParentInfo(dynArrays);
        if (!ObjectUtils.isEmpty(orgTeamChgParentInfo)) {
            hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamChgParentInfo.toArray(new DynamicObject[0]), "haos_adminorgstructure", false));
        }
        if (!ObjectUtils.isEmpty(orgTeamChgInfo)) {
            hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamChgInfo.toArray(new DynamicObject[0]), "haos_adminorgteam", false));
        }
    }

    public void orgTeamChgSync(DynamicObject[] dynArrays, DynamicObject[] allChildDynArr, List<HisVersionParamBo> hisVersionParamBos, String type, Long teamTypeID, Long orgTypeID, Long prefixId, String parentFiledName, boolean isChgStruct) {
        List<DynamicObject> orgTeamChgParentInfo;
        if (ObjectUtils.isEmpty((Object[])dynArrays)) {
            return;
        }
        HashMap<Long, Long> idVsPidMap = new HashMap<Long, Long>();
        ArrayList<Long> curOrgIdList = new ArrayList<Long>(16);
        Arrays.stream(dynArrays).forEach(dyn -> {
            if (isChgStruct) {
                idVsPidMap.put(dyn.getLong("id"), dyn.getLong(parentFiledName));
            }
            curOrgIdList.add(dyn.getLong("boid"));
        });
        Date effectDate = dynArrays[0].getDate("bsed");
        List<DynamicObject> orgTeamChgInfo = null;
        if (!ObjectUtils.isEmpty(curOrgIdList)) {
            orgTeamChgInfo = this.getOrgTeamChgMainDyn(dynArrays, curOrgIdList, type, teamTypeID, orgTypeID, prefixId);
        }
        if (!ObjectUtils.isEmpty(orgTeamChgParentInfo = this.getOrgTeamParentChgStructDyn(idVsPidMap, allChildDynArr, effectDate))) {
            hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamChgParentInfo.toArray(new DynamicObject[0]), "haos_adminorgstructure", false));
        }
        if (orgTeamChgInfo != null) {
            hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamChgInfo.toArray(new DynamicObject[0]), "haos_adminorgteam", false));
        }
    }

    private Long getNumberPrefix(String caller) {
        Long numberPrefix = 0L;
        if (caller.equals("adminorg")) {
            numberPrefix = 1010L;
        } else if (caller.equals("projectgroup")) {
            numberPrefix = 1020L;
        }
        return numberPrefix;
    }

    private List<DynamicObject> orgChgParentInfo(DynamicObject[] dynArrays) {
        if (dynArrays.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        List<Long> orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgStructInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, "haos_adminorgstructure", "orgteam");
        HRBaseServiceHelper orgTeamStructHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter idFilter = new QFilter("orgteam", "in", orgIdList);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dyns = orgTeamStructHelper.queryOriginalArray("id, parentorgteam", new QFilter[]{idFilter, isCurrentVersionFilter});
        List<Long> oldParentOrgList = Arrays.stream(dyns).map(dyn -> dyn.getLong("parentorgteam")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldParentOrgStructInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(oldParentOrgList, "haos_adminorgstructure", "orgteam");
        QFilter parentOrgFilter = new QFilter("parentorgteam", "in", oldParentOrgList);
        DynamicObject[] idParentIdDyns = orgTeamStructHelper.queryOriginalArray("orgteam, parentorgteam", new QFilter[]{parentOrgFilter, isCurrentVersionFilter});
        HashMap parentIdMap = Maps.newHashMapWithExpectedSize((int)oldParentOrgList.size());
        Arrays.stream(idParentIdDyns).forEach(dyn -> {
            long parentId = dyn.getLong("parentorgteam");
            if (CollectionUtils.isEmpty((Collection)((Collection)parentIdMap.get(parentId)))) {
                ArrayList childIdList = Lists.newArrayListWithExpectedSize((int)idParentIdDyns.length);
                childIdList.add(dyn.getLong("orgteam"));
                parentIdMap.put(parentId, childIdList);
            } else {
                List childIdList = (List)parentIdMap.get(parentId);
                childIdList.add(dyn.getLong("orgteam"));
                parentIdMap.put(parentId, childIdList);
            }
        });
        List<Long> parentIdList = Stream.of(dynArrays).map(dyn -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn, (String)"parentorg")).collect(Collectors.toList());
        Map<Long, DynamicObject> parentInfoStructDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(parentIdList, "haos_adminorgstructure", "orgteam");
        ArrayList newStructList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dyn2 : dynArrays) {
            String structLongNumber;
            boolean isLeaf;
            DynamicObject parentDyn;
            Long orgId;
            Long oldParentId;
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dyn2, (String)"parentorg");
            if (parentId.equals(oldParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)oldOrgStructInfoDynMap.get(orgId = Long.valueOf(dyn2.getLong("id"))), (String)"parentorgteam")) || (parentDyn = parentInfoStructDynMap.get(parentId)) == null) continue;
            DynamicObject oldParentAdminStructDyn = oldParentOrgStructInfoDynMap.get(oldParentId);
            if (Objects.nonNull(oldParentAdminStructDyn)) {
                List childIdList = (List)parentIdMap.get(oldParentId);
                childIdList.remove(dyn2.getLong("id"));
                if (childIdList.size() == 0) {
                    oldParentAdminStructDyn.set("isleaf", (Object)"1");
                    DynamicObject parentStruct = orgTeamStructHelper.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)oldParentAdminStructDyn, (DynamicObject)parentStruct);
                    newStructList.add(parentStruct);
                }
            }
            if (isLeaf = parentDyn.getBoolean("isleaf")) {
                parentDyn.set("isleaf", (Object)"0");
                parentDyn.set("bsed", (Object)dyn2.getDate("bsed"));
                parentInfoStructDynMap.put(parentId, parentDyn);
                DynamicObject newParentDyn = orgTeamStructHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)parentDyn, (DynamicObject)newParentDyn);
                newStructList.add(newParentDyn);
            }
            if (StringUtils.isEmpty((CharSequence)(structLongNumber = Optional.ofNullable(oldOrgStructInfoDynMap.get(orgId)).map(dynamicObject -> dynamicObject.getString("structlongnumber")).orElse("")))) continue;
            QFilter qFilter = AdminOrgChgStructService.getInstance().getLikeQFilterByStructLongNumber(structLongNumber);
            DynamicObject[] childStructDynArrays = orgTeamStructHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
            List childStructSortDynList = Stream.of(childStructDynArrays).sorted(Comparator.comparingInt(o -> o.getInt("level"))).collect(Collectors.toList());
            for (DynamicObject childDyn : childStructSortDynList) {
                DynamicObject newParentDyn;
                Long adminOrgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"orgteam");
                Long adminOrgParentId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)childDyn, (String)"parentorgteam");
                Date effectDate = dyn2.getDate("bsed");
                if (adminOrgId.equals(orgId)) {
                    adminOrgParentId = parentId;
                }
                if (ObjectUtils.isEmpty((Object)(newParentDyn = parentInfoStructDynMap.get(adminOrgParentId)))) continue;
                DynamicObject newDyn = new DynamicObject(childDyn.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)childDyn, (DynamicObject)newDyn);
                newDyn.set("parentorgteam", newParentDyn.get("orgteam"));
                newDyn.set("structlongnumber", (Object)AdminOrgChgStructService.getInstance().getStructLongNumber(childDyn.getString("structlongnumber"), newParentDyn.getString("structlongnumber")));
                newDyn.set("level", (Object)(newParentDyn.getInt("level") + 1));
                newDyn.set("bsed", (Object)effectDate);
                parentInfoStructDynMap.put(adminOrgId, newDyn);
                newStructList.add(newDyn);
            }
        }
        return newStructList;
    }

    private List<DynamicObject> orgChgInfo(DynamicObject[] dynArrays, Long numberPrefix) {
        List<Long> orgIdList = Stream.of(dynArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldOrgInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(orgIdList, "haos_adminorgteam", "id");
        ArrayList orgTeamDynList = Lists.newArrayListWithCapacity((int)dynArrays.length);
        String orgTeamNumberPrefix = OrgTeamSynService.getOrgTeamNumberPrefix(numberPrefix);
        for (DynamicObject dyn2 : dynArrays) {
            Long orgId = dyn2.getLong("id");
            DynamicObject oldOrgDyn = oldOrgInfoDynMap.get(orgId);
            if (null == oldOrgDyn) continue;
            DynamicObject newDyn = new DynamicObject(oldOrgDyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)oldOrgDyn, (DynamicObject)newDyn);
            this.synOrgTeamBizFields(newDyn, dyn2, orgTeamNumberPrefix);
            newDyn.set("bsed", (Object)dyn2.getDate("bsed"));
            orgTeamDynList.add(newDyn);
        }
        return orgTeamDynList;
    }

    public void synOrgTeamBizFields(DynamicObject orgTeam, DynamicObject subOrg, String orgTeamNumberPrefix) {
        orgTeam.set("name", subOrg.get("name"));
        orgTeam.set("number", (Object)(orgTeamNumberPrefix + "_" + subOrg.getString("number")));
        orgTeam.set("bsed", subOrg.get("bsed"));
        orgTeam.set("bsled", subOrg.get("bsled"));
        orgTeam.set("org", subOrg.get("org"));
    }

    public void synOrgTeamStructBizFields(DynamicObject orgTeamStruct, DynamicObject adminOrgStruct) {
        orgTeamStruct.set("parentorgteam", adminOrgStruct.get("parentorg.id"));
        orgTeamStruct.set("parentorgteam_id", adminOrgStruct.get("parentorg.id"));
        orgTeamStruct.set("structlongnumber", adminOrgStruct.get("structlongnumber"));
        orgTeamStruct.set("level", adminOrgStruct.get("level"));
        orgTeamStruct.set("isleaf", adminOrgStruct.get("isleaf"));
        orgTeamStruct.set("bsed", adminOrgStruct.get("bsed"));
        orgTeamStruct.set("bsled", adminOrgStruct.get("bsled"));
    }

    public static String getNumberByPrefixId(Long prefixId) {
        Map<String, String> modelMap = OrgTeamSynService.initNumberPrefixCache();
        return modelMap.get(String.valueOf(prefixId));
    }

    public static Map<String, String> initNumberPrefixCache() {
        HashMap<String, String> modelMap = new HashMap();
        if (HRAppCache.get((String)APP_KEY).get(PAGE_HAOS_NUMBERPREFIX_CACHE_KEY, Map.class) == null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_HSS_NUMBERPREFIX);
            DynamicObject[] dynamicObject = serviceHelper.query("numberprefix,type,teamtype,orgtype,number", null);
            for (int i = 0; i < dynamicObject.length; ++i) {
                String key = dynamicObject[i].getString("id");
                String value = dynamicObject[i].get(NUMBER_PREFIX).toString();
                modelMap.put(key, value);
            }
            HRAppCache.get((String)APP_KEY).put(PAGE_HAOS_NUMBERPREFIX_CACHE_KEY, modelMap);
        }
        modelMap = (Map)HRAppCache.get((String)APP_KEY).get(PAGE_HAOS_NUMBERPREFIX_CACHE_KEY, Map.class);
        return modelMap;
    }

    private List<DynamicObject> getOrgTeamChgMainDyn(DynamicObject[] dynArrays, List<Long> curOrgIdList, String type, Long teamTypeID, Long orgTypeID, Long prefixId) {
        ArrayList orgTeamDynList = Lists.newArrayListWithCapacity((int)16);
        if (ObjectUtils.isEmpty((Object[])dynArrays)) {
            return orgTeamDynList;
        }
        Map<Long, DynamicObject> oldOrgInfoDynMap = AdminOrgHisServiceHelper.getEntityInfoByOrgId(curOrgIdList, "haos_adminorgteam", "id");
        String orgTeamNumberPrefix = OrgTeamSynService.getNumberByPrefixId(prefixId);
        for (DynamicObject dyn : dynArrays) {
            Long orgId = dyn.getLong("id");
            DynamicObject oldOrgDyn = oldOrgInfoDynMap.get(orgId);
            if (null == oldOrgDyn) continue;
            DynamicObject newDyn = new DynamicObject(oldOrgDyn.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)oldOrgDyn, (DynamicObject)newDyn);
            newDyn.set("name", dyn.get("name"));
            newDyn.set("number", (Object)(orgTeamNumberPrefix + '_' + dyn.getString("number")));
            newDyn.set("bsed", dyn.get("bsed"));
            newDyn.set("bsled", dyn.get("bsled"));
            newDyn.set("index", dyn.get("index"));
            orgTeamDynList.add(newDyn);
        }
        return orgTeamDynList;
    }

    private List<DynamicObject> getOrgTeamParentChgStructDyn(Map<Long, Long> idVsPidMap, DynamicObject[] allChildDynArr, Date effectDate) {
        ArrayList<DynamicObject> retList = new ArrayList<DynamicObject>(16);
        if (ObjectUtils.isEmpty(idVsPidMap)) {
            return retList;
        }
        Set<Long> orgTeamIdSet = idVsPidMap.keySet();
        HashSet<Long> pidSet = new HashSet<Long>(idVsPidMap.values());
        HashSet<Long> allIdSet = new HashSet<Long>();
        HashSet<Long> retainIdSet = new HashSet<Long>();
        allIdSet.addAll(pidSet);
        allIdSet.addAll(orgTeamIdSet);
        retainIdSet.addAll(pidSet);
        retainIdSet.retainAll(orgTeamIdSet);
        Object[] allDynArr = this.getCurOrgTeamStructDynArr(allIdSet);
        if (ObjectUtils.isEmpty((Object[])allDynArr)) {
            return retList;
        }
        HashMap<Long, DynamicObject> curOrgTeamDynMap = new HashMap<Long, DynamicObject>(orgTeamIdSet.size());
        HashMap<Long, DynamicObject> dbParentDynMap = new HashMap<Long, DynamicObject>(orgTeamIdSet.size());
        Arrays.stream(allDynArr).forEach(dyn -> {
            Long orgTeamId = dyn.getLong("orgteam.id");
            if (orgTeamIdSet.contains(orgTeamId)) {
                curOrgTeamDynMap.put(orgTeamId, (DynamicObject)dyn);
            }
            if (retainIdSet.contains(orgTeamId) || pidSet.contains(orgTeamId)) {
                dbParentDynMap.put(orgTeamId, (DynamicObject)dyn);
            }
        });
        Map<Long, List<DynamicObject>> subStructDynInfoMap = null;
        Map<Long, DynamicObject> allChildDynMap = null;
        if (!ObjectUtils.isEmpty((Object[])allChildDynArr)) {
            allChildDynMap = Arrays.stream(allChildDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgteam.id"), dyn -> dyn));
            subStructDynInfoMap = this.getSubStructDynInfoMap(curOrgTeamDynMap, allChildDynArr);
        }
        this.assembleOrgTeamParentChgList(idVsPidMap, effectDate, retList, curOrgTeamDynMap, dbParentDynMap, allChildDynMap, subStructDynInfoMap);
        return retList;
    }

    public DynamicObject[] getCurOrgTeamStructDynArr(Set<Long> allIdSet) {
        HRBaseServiceHelper orgTeamStructHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter filter = new QFilter("orgteam", "in", allIdSet);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] allDynArr = orgTeamStructHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return allDynArr;
    }

    private void assembleOrgTeamParentChgList(Map<Long, Long> idVsPidMap, Date effectDate, List<DynamicObject> retList, Map<Long, DynamicObject> curOrgTeamDynMap, Map<Long, DynamicObject> dbParentDynMap, Map<Long, DynamicObject> allChildDynMap, Map<Long, List<DynamicObject>> subStructDynInfoMap) {
        Tree tree = new Tree(idVsPidMap);
        List orgTeamIdOrderList = tree.levelTraverse();
        for (Long orgTeamId : orgTeamIdOrderList) {
            List<DynamicObject> subDynList;
            DynamicObject curDyn = curOrgTeamDynMap.get(orgTeamId);
            Long pId = idVsPidMap.get(orgTeamId);
            DynamicObject dbParentDyn = dbParentDynMap.get(pId);
            DynamicObject newParentDyn = dbParentDyn != null ? dbParentDyn : curOrgTeamDynMap.get(pId);
            DynamicObject newDyn = this.getNewParentStructDyn(curDyn, newParentDyn, effectDate);
            retList.add(newDyn);
            if (ObjectUtils.isEmpty(subStructDynInfoMap) || ObjectUtils.isEmpty(subDynList = subStructDynInfoMap.get(orgTeamId))) continue;
            for (DynamicObject subDyn : subDynList) {
                Long orgTeamParentId = subDyn.getLong("parentorgteam.id");
                DynamicObject subParentDyn = curOrgTeamDynMap.get(orgTeamParentId);
                DynamicObject subParent = subParentDyn == null ? allChildDynMap.get(orgTeamParentId) : subParentDyn;
                if (subParent == null) continue;
                retList.add(this.getNewParentStructDyn(subDyn, subParent, effectDate));
            }
        }
    }

    public DynamicObject[] getCurSubAndSortByLongNumber(Set<Long> orgTeamIdSet, Set<Long> pidSet, DynamicObject[] allDynArr) {
        Object[] allChildDynArr;
        HRBaseServiceHelper orgTeamStructHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        HashMap allOrgStructDynMap = new HashMap(16);
        ArrayList chgOrgTeamLongNumberList = new ArrayList(16);
        ArrayList newParentOrgTeamLongNumberList = new ArrayList(16);
        Arrays.stream(allDynArr).forEach(dyn -> {
            Long orgTeamId = dyn.getLong("orgteam.id");
            allOrgStructDynMap.put(orgTeamId, dyn);
            String longNumber = dyn.getString("structlongnumber");
            if (orgTeamIdSet.contains(orgTeamId)) {
                chgOrgTeamLongNumberList.add(longNumber);
            }
            if (pidSet.contains(orgTeamId)) {
                newParentOrgTeamLongNumberList.add(longNumber);
            }
        });
        List prefixStructLongNumberList = StructLongNumberUtil.getPrefixStructLongNumber(chgOrgTeamLongNumberList);
        QFilter qFilter = null;
        for (String longNumber : prefixStructLongNumberList) {
            if (qFilter == null) {
                qFilter = new QFilter("structlongnumber", "like", (Object)(longNumber + "!%"));
                continue;
            }
            qFilter.or(new QFilter("structlongnumber", "like", (Object)(longNumber + "!%")));
        }
        if (qFilter != null) {
            qFilter.and("iscurrentversion", "=", (Object)"1");
        }
        if (!ObjectUtils.isEmpty((Object[])(allChildDynArr = orgTeamStructHelper.loadDynamicObjectArray(new QFilter[]{qFilter})))) {
            Arrays.stream(allChildDynArr).sorted(Comparator.comparing(o -> o.getString("structlongnumber").length()));
        }
        return allChildDynArr;
    }

    public Map<Long, List<DynamicObject>> getSubStructDynInfoMap(Map<Long, DynamicObject> curOrgTeamStructDynMap, DynamicObject[] allCurAndChildDynArr) {
        HashMap<Long, List<DynamicObject>> subDynInfoListMap = new HashMap<Long, List<DynamicObject>>(16);
        HashSet<Integer> flag = new HashSet<Integer>(16);
        for (Map.Entry<Long, DynamicObject> map : curOrgTeamStructDynMap.entrySet()) {
            Long key = map.getKey();
            DynamicObject curDyn = map.getValue();
            String curOrgTeamLongNumber = curDyn.getString("structlongnumber");
            for (int i = 0; i < allCurAndChildDynArr.length; ++i) {
                DynamicObject dyn;
                String longNumber;
                if (flag.contains(i) || !(longNumber = (dyn = allCurAndChildDynArr[i]).getString("structlongnumber")).startsWith(curOrgTeamLongNumber)) continue;
                flag.add(i);
                List subList = subDynInfoListMap.computeIfAbsent(key, k -> new ArrayList());
                subList.add(dyn);
            }
        }
        return subDynInfoListMap;
    }

    public void setOtType(DynamicObject newOt) {
        newOt.set(TEAMTYPE, (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getTeamType());
        newOt.set("teamtype_id", (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getTeamType());
        newOt.set(ORGTYPE, (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getOrgType());
        newOt.set("orgtype_id", (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getOrgType());
        newOt.set("otclassify", (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getOtClassify());
        newOt.set("otclassify_id", (Object)PRJ_ORG_TEAM_BASIC_INFO_BO.getOtClassify());
    }

    private DynamicObject getNewParentStructDyn(DynamicObject curDyn, DynamicObject parentDyn, Date effectDate) {
        DynamicObject newDyn = new DynamicObject(curDyn.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)curDyn, (DynamicObject)newDyn);
        String dbParentLongNumber = parentDyn.getString("structlongnumber");
        String curOrgTeamStructLongNumber = curDyn.getString("structlongnumber");
        String newLongNumber = dbParentLongNumber + "!" + curOrgTeamStructLongNumber.substring(curOrgTeamStructLongNumber.lastIndexOf("!") + 1);
        curDyn.set("structlongnumber", (Object)newLongNumber);
        newDyn.set("structlongnumber", (Object)newLongNumber);
        newDyn.set("parentorgteam", (Object)parentDyn.getDynamicObject("orgteam"));
        newDyn.set("level", (Object)newLongNumber.split("!").length);
        newDyn.set("bsed", (Object)effectDate);
        return newDyn;
    }
}

