/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.orgteam.model.OtCascadeBo;
import kd.hr.haos.business.service.orgteam.model.OtStructBo;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.util.HAOSDynamicObjectUtil;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.OtherStructSplitUtil;
import kd.hr.haos.business.util.cascade.MultiVersionTree;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OtherTeamStructService {
    private final OtherStructEntity otherStructEntity;
    private final Map<Long, Date> esDateBoIdMap;
    private Map<Boolean, List<DynamicObject>> otMap;
    private Collection<DynamicObject> enablingOtList;
    private Map<Long, Long> firstIdMap;
    private IdCreator idCreator;
    private Set<Long> relateOrgSet;

    public OtherTeamStructService() {
        this(null, null);
    }

    public OtherTeamStructService(OtherStructEntity otherStructEntity, Map<Long, Date> esDateBoIdMap) {
        this.otherStructEntity = otherStructEntity;
        this.esDateBoIdMap = esDateBoIdMap;
    }

    public void saveOtherTeamStruct() {
        this.idCreator = new IdCreator();
        if (this.otherStructEntity.getDeleteAll().booleanValue()) {
            this.deleteByFilter();
        }
        if (!CollectionUtils.isEmpty(this.enablingOtList)) {
            OTQueryRepository.getInstance().save(this.enablingOtList.toArray(new DynamicObject[0]));
        }
        List<DynamicObject> structList = this.buildData();
        List<DynamicObject> otList = this.otMap.get(Boolean.FALSE);
        if (!CollectionUtils.isEmpty(otList)) {
            Set<Long> orgTeamIdSet = otList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
            structList.forEach(dy -> orgTeamIdSet.remove(dy.getLong("orgteam.id")));
            structList.addAll(this.getStructListByOt(orgTeamIdSet));
            structList = OtherStructSplitUtil.splitStructAndSetHisId(otList, structList, true);
        }
        Map<Boolean, List<DynamicObject>> map = this.buildMap(structList, this.otherStructEntity.getStructProjectId());
        this.batchHisVersionChange(this.buildParamBoList(map, Boolean.TRUE));
        this.batchHisVersionChange(this.buildParamBoList(map, Boolean.FALSE));
    }

    private List<DynamicObject> getStructListByOt(Set<Long> orgTeamIdSet) {
        if (CollectionUtils.isEmpty(orgTeamIdSet)) {
            return Collections.emptyList();
        }
        DynamicObject[] hisStructs = OTStructRepository.getInstance().loadHisByStructIdBoDate(orgTeamIdSet, this.otherStructEntity.getEffectDate(), this.otherStructEntity.getStructProjectId());
        return Arrays.stream(hisStructs).map(hisDy -> {
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            return newDy;
        }).collect(Collectors.toList());
    }

    public void enabledByStructProjectAndOrg(Set<Long> structProjectSet, Set<Long> orgSet) {
        DynamicObject[] array;
        for (DynamicObject dy : array = OTStructRepository.getInstance().queryByStructProjectAndOrg("id,enable", structProjectSet, orgSet)) {
            dy.set("enable", (Object)"1");
        }
        OTStructRepository.getInstance().save(array);
    }

    public void deleteByStructProject(Set<Long> structProjectSet) {
        this.deleteOrgSet();
        OTStructRepository.getInstance().deleteByStructProjectNotOrg(structProjectSet, null);
    }

    public void deleteByOrgSet(Long structProjectId, Set<Long> orgSet, Set<Long> structOrgSet) {
        OTQueryRepository.getInstance().deleteVirtualByOrgSet(orgSet);
        OTStructRepository.getInstance().deleteByStructProjectOrg(structProjectId, structOrgSet);
    }

    public List<DynamicObject> getOtherStructByOt(List<DynamicObject> otList) {
        if (CollectionUtils.isEmpty(otList)) {
            return Collections.emptyList();
        }
        HashSet<Long> otIdSet = new HashSet<Long>(otList.size());
        DynamicObject otDy = otList.get(0);
        Date minStartDate = otDy.getDate("bsed");
        Date maxEndDate = otDy.getDate("bsled");
        otIdSet.add(otDy.getLong("boid"));
        for (int index = 1; index < otList.size(); ++index) {
            otDy = otList.get(index);
            otIdSet.add(otDy.getLong("boid"));
            Date date = otDy.getDate("bsed");
            if (date.compareTo(minStartDate) < 0) {
                minStartDate = date;
            }
            if ((date = otDy.getDate("bsled")).compareTo(maxEndDate) <= 0) continue;
            maxEndDate = date;
        }
        otIdSet.remove(0L);
        if (CollectionUtils.isEmpty(otIdSet)) {
            return Collections.emptyList();
        }
        DynamicObject[] structArray = OTStructRepository.getInstance().loadByOrgDateOtherStruct(otIdSet, minStartDate, maxEndDate);
        if (structArray.length == 0) {
            return Collections.emptyList();
        }
        List<Object> newStructList = new ArrayList<DynamicObject>(structArray.length);
        for (DynamicObject struct : structArray) {
            DynamicObject newStructDy = new DynamicObject(struct.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)struct, (DynamicObject)newStructDy);
            newStructDy.set("orgteamhisid", (Object)0L);
            newStructList.add(newStructDy);
        }
        newStructList = OtherStructSplitUtil.splitStructAndSetHisId(otList, newStructList);
        newStructList = newStructList.stream().filter(dy -> dy.getLong("orgteamhisid") != 0L).collect(Collectors.toList());
        return newStructList;
    }

    private Map<Boolean, List<DynamicObject>> buildMap(List<DynamicObject> otStructList, Long structProjectId) {
        DynamicObject creatorDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        creatorDy.set("id", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        DynamicObject structProject = HAOSDynamicObjectUtil.newDy("haos_structure", structProjectId);
        return otStructList.stream().peek(dy -> {
            HAOSDynamicObjectUtil.setInitFields(dy);
            if (dy.getDate("bsled").compareTo(OrgDateTimeUtil.BSLED) != 0) {
                dy.set("iscurrentversion", (Object)Boolean.FALSE);
            }
            if (dy.getBoolean("iscurrentversion")) {
                dy.set("id", (Object)dy.getLong("boid"));
            } else {
                dy.set("id", (Object)this.idCreator.getId());
            }
            dy.set("structproject", (Object)structProject);
            dy.set("createtime", (Object)date);
            dy.set("creator", (Object)creatorDy);
        }).collect(Collectors.groupingBy(dy -> dy.getBoolean("iscurrentversion")));
    }

    private List<DynamicObject> buildData() {
        Map<Long, Long> parentChangeMap = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.PARENT).stream().collect(Collectors.toMap(OtherStructVO::getOrgId, OtherStructVO::getParentId));
        Set<Long> parentChangeOrgSet = parentChangeMap.keySet();
        Date effectDate = this.otherStructEntity.getEffectDate();
        DynamicObjectCollection structLongNumberCol = OTStructRepository.getInstance().queryHisColByBoDate(this.esDateBoIdMap.keySet(), effectDate, OrgDateTimeUtil.BSLED, this.otherStructEntity.getStructProjectId());
        Map booleanMap = structLongNumberCol.stream().collect(Collectors.groupingBy(struct -> parentChangeOrgSet.contains(struct.getLong("orgteam.id")), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
        DynamicObjectCollection structCol = OTStructRepository.getInstance().queryHisColBySLN(booleanMap.get(Boolean.TRUE), booleanMap.get(Boolean.FALSE), effectDate, OrgDateTimeUtil.BSLED, Collections.singletonList(this.otherStructEntity.getStructProjectId()));
        this.setParentChangeValue(structCol);
        List<DynamicObject> addStructList = this.buildAddStruct();
        CascadeResult cascadeResult = this.getCascadeResult(Stream.of(addStructList, structCol).flatMap(Collection::stream).collect(Collectors.toList()));
        List<DynamicObject> structList = this.buildStructChangeData(parentChangeMap, cascadeResult, addStructList);
        OtherStructSplitUtil.addStatusChangeList(this.otherStructEntity, structList, true);
        addStructList.stream().filter(dy -> dy.get("parentorgteam") == null).forEach(structList::add);
        return structList;
    }

    private List<DynamicObject> buildStructChangeData(Map<Long, Long> parentIdMap, CascadeResult cascadeResult, List<DynamicObject> addStructList) {
        Set<Long> idSet = cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
        DynamicObject[] structArray = OTStructRepository.getInstance().loadByIds(idSet);
        Map<Long, DynamicObject> map = Stream.concat(Arrays.stream(structArray), addStructList.stream()).collect(Collectors.toMap(struct -> struct.getLong("id"), obj -> obj));
        return cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(partBo -> {
            OtStructBo structBo = (OtStructBo)((Object)partBo);
            DynamicObject hisDy = (DynamicObject)map.get(structBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            newDy.set("id", (Object)structBo.getVid());
            LocalDateRangeUtils.setEffectRange(newDy, partBo.getEffectRange());
            newDy.set("structlongnumber", (Object)structBo.getSLN());
            Long parentId = (Long)parentIdMap.get(hisDy.getLong("orgteam.id"));
            if (parentId != null) {
                newDy.set("parentorgteam", (Object)HAOSDynamicObjectUtil.newDy("haos_adminorgstructure", parentId));
                newDy.set("enable", (Object)this.otherStructEntity.getEnable());
            }
            newDy.set("level", (Object)structBo.getSLN().split("!").length);
            return newDy;
        }).collect(Collectors.toList());
    }

    private CascadeResult getCascadeResult(List<DynamicObject> allStructList) {
        List cascadeBoList = allStructList.stream().map(structDy -> {
            String structLongNumber = structDy.getString("structlongnumber");
            OtCascadeBo cascadeBo = new OtCascadeBo();
            cascadeBo.setBo(structDy.getLong("orgteam.id"));
            cascadeBo.setParentBo(structDy.getLong("parentorgteam.id"));
            cascadeBo.setEffectRange(LocalDateRangeUtils.getEffectRange(structDy));
            int index = structLongNumber.lastIndexOf("!");
            cascadeBo.setStructNumber(index != -1 ? structLongNumber.substring(index + 1) : structLongNumber);
            OtStructBo structBo = new OtStructBo();
            structBo.setVid(structDy.getLong("id"));
            structBo.setEffectRange(cascadeBo.getEffectRange());
            structBo.setSLN(structLongNumber);
            ArrayList<OtStructBo> structBoList = new ArrayList<OtStructBo>();
            structBoList.add(structBo);
            cascadeBo.setOtStructBoList(structBoList);
            return cascadeBo;
        }).collect(Collectors.toList());
        MultiVersionTree multiVersionTree = MultiVersionTree.create(cascadeBoList);
        multiVersionTree.traverse();
        return multiVersionTree.getResult();
    }

    private void setParentChangeValue(DynamicObjectCollection structCol) {
        List<OtherStructVO> otherStructVOList = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.PARENT);
        if (CollectionUtils.isEmpty(otherStructVOList)) {
            return;
        }
        Map<Long, Long> idParentMap = otherStructVOList.stream().collect(Collectors.toMap(OtherStructVO::getOrgId, OtherStructVO::getParentId));
        Set<Long> parentChangeOrgSet = idParentMap.keySet();
        Date effectDate = this.otherStructEntity.getEffectDate();
        structCol.stream().filter(dy -> parentChangeOrgSet.contains(dy.getLong("orgteam.id"))).forEach(dy -> {
            Long parentId = (Long)idParentMap.get(dy.getLong("orgteam.id"));
            dy.set("parentorgteam.id", (Object)parentId);
            Date date = this.getTruncateDate(effectDate, this.esDateBoIdMap.get(parentId));
            if (dy.getDate("bsed").compareTo(date) < 0) {
                dy.set("bsed", (Object)date);
            }
        });
    }

    private List<DynamicObject> buildAddStruct() {
        List<OtherStructVO> addList = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.ADD);
        if (CollectionUtils.isEmpty(addList)) {
            return Collections.emptyList();
        }
        Map<Long, OtherStructVO> addParentMap = addList.stream().collect(Collectors.toMap(OtherStructVO::getOrgId, otherStructVO -> otherStructVO));
        Date effectDate = this.otherStructEntity.getEffectDate();
        String enable = this.otherStructEntity.getEnable();
        DynamicObjectCollection otCol = OTQueryRepository.getInstance().queryColByBoIdAndDate(addParentMap.keySet(), effectDate, OrgDateTimeUtil.BSLED);
        if (!CollectionUtils.isEmpty((Collection)this.otMap.get(Boolean.TRUE))) {
            otCol.addAll((Collection)this.otMap.get(Boolean.TRUE));
        }
        ArrayList<DynamicObject> otStructList = new ArrayList<DynamicObject>(otCol.size());
        Map<Long, List<DynamicObject>> otMap = otCol.stream().collect(Collectors.groupingBy(struct -> struct.getLong("boid")));
        otMap.forEach((key, value) -> {
            Long boId = this.idCreator.getId();
            value.forEach(otDy -> {
                Long vid;
                Long parentId = ((OtherStructVO)addParentMap.get(key)).getParentId();
                DynamicObject otStructDy = HAOSDynamicObjectUtil.newDy("haos_adminorgstructure", this.idCreator.getId());
                otStructDy.set("enable", (Object)enable);
                otStructDy.set("boid", (Object)boId);
                otStructDy.set("orgteam", (Object)HAOSDynamicObjectUtil.newDy("haos_adminorgstructure", otDy.getLong("boid")));
                otStructDy.set("iscurrentversion", (Object)Boolean.TRUE);
                Date startDate = this.getTruncateDate(effectDate, otDy.getDate("bsed"));
                otStructDy.set("bsed", (Object)startDate);
                otStructDy.set("bsled", (Object)otDy.getDate("bsled"));
                otStructDy.set("parentorgteam", (Object)HAOSDynamicObjectUtil.newDy("haos_adminorgstructure", parentId));
                otStructDy.set("structlongnumber", (Object)otDy.getString("structnumber"));
                otStructDy.set("level", (Object)1);
                otStructDy.set("isroot", (Object)"0");
                Long l = vid = this.firstIdMap == null ? null : this.firstIdMap.get(key);
                if (vid != null) {
                    otStructDy.set("orgteamhisid", (Object)vid);
                } else {
                    otStructDy.set("orgteamhisid", (Object)otDy.getLong("id"));
                }
                otStructDy.set("otclassify", (Object)otDy.getLong("otclassify"));
                otStructList.add(otStructDy);
                if (parentId != null) {
                    this.splitNoParentDy(otStructList, otStructDy, startDate, parentId);
                } else {
                    otStructDy.set("isroot", (Object)"1");
                }
            });
        });
        return otStructList;
    }

    private void splitNoParentDy(List<DynamicObject> otStructList, DynamicObject otStructDy, Date startDate, Long parentId) {
        Date parentStartDate = this.getTruncateDate(this.otherStructEntity.getEffectDate(), this.esDateBoIdMap.get(parentId));
        if (startDate.compareTo(parentStartDate) < 0) {
            Date endDate = otStructDy.getDate("bsled");
            if (endDate.compareTo(parentStartDate) < 0) {
                otStructDy.set("parentorgteam", null);
            } else {
                DynamicObject noParentStructDy = new DynamicObject(otStructDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)otStructDy, (DynamicObject)noParentStructDy);
                noParentStructDy.set("parentorgteam", null);
                noParentStructDy.set("bsled", (Object)HRDateTimeUtils.addDay((Date)parentStartDate, (long)-1L));
                noParentStructDy.set("id", (Object)this.idCreator.getId());
                otStructDy.set("bsed", (Object)parentStartDate);
                otStructList.add(noParentStructDy);
            }
        }
    }

    private void deleteByFilter() {
        if (!this.otherStructEntity.getDeleteFlag().booleanValue()) {
            return;
        }
        this.deleteOrgSet();
        OTStructRepository.getInstance().deleteByStructProjectNotOrg(Sets.newHashSet((Object[])new Long[]{this.otherStructEntity.getStructProjectId()}), this.otherStructEntity.getRootOrgId());
    }

    private void deleteOrgSet() {
        if (!CollectionUtils.isEmpty(this.relateOrgSet)) {
            OTQueryRepository.getInstance().deleteVirtualByOrgSet(this.relateOrgSet);
        }
    }

    private List<HisVersionParamBo> buildParamBoList(Map<Boolean, List<DynamicObject>> map, Boolean firstFlag) {
        List<DynamicObject> otList;
        ArrayList<HisVersionParamBo> hisBoList = new ArrayList<HisVersionParamBo>(2);
        List<DynamicObject> structDyList = map.get(firstFlag);
        if (!CollectionUtils.isEmpty(structDyList)) {
            DynamicObject[] structArray = structDyList.toArray(new DynamicObject[0]);
            ArrayList customizedList = null;
            if (firstFlag.booleanValue()) {
                customizedList = new ArrayList(structArray.length);
                for (DynamicObject structDy : structArray) {
                    HashMap<String, Long> customizedMap = new HashMap<String, Long>(1);
                    customizedMap.put("orgteamhisid", structDy.getLong("orgteamhisid"));
                    structDy.set("orgteamhisid", (Object)structDy.getLong("orgteam.id"));
                    customizedList.add(customizedMap);
                }
            }
            HisVersionParamBo paramBo = AdminOrgHisServiceHelper.getHisVersionParam(structArray, "haos_adminorgstructure", false, customizedList);
            paramBo.setNeedProcessAttachment(false);
            hisBoList.add(paramBo);
        }
        if (!CollectionUtils.isEmpty(otList = this.otMap.get(firstFlag))) {
            DynamicObject[] otArray = otList.toArray(new DynamicObject[0]);
            long[] firstVersionIds = null;
            if (firstFlag.booleanValue()) {
                firstVersionIds = new long[otArray.length];
                for (int index = 0; index < otArray.length; ++index) {
                    firstVersionIds[index] = this.firstIdMap.get(otArray[index].getLong("id"));
                }
            }
            HisVersionParamBo paramBo = AdminOrgHisServiceHelper.getHisVersionParam(otArray, "haos_adminorgteam", false);
            paramBo.setFirstVersionIds(firstVersionIds);
            paramBo.setNeedProcessAttachment(false);
            hisBoList.add(paramBo);
        }
        return hisBoList;
    }

    private void batchHisVersionChange(List<HisVersionParamBo> hisBoList) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(this.otherStructEntity.getEventId());
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private Date getTruncateDate(Date effectDate, Date date) {
        return HRDateTimeUtils.truncateDate((Date)(effectDate.compareTo(date) < 0 ? date : effectDate));
    }

    public void setOtMap(Map<Boolean, List<DynamicObject>> otMap) {
        this.otMap = otMap;
    }

    public void setEnablingOtList(Collection<DynamicObject> enablingOtList) {
        this.enablingOtList = enablingOtList;
    }

    public void setFirstIdMap(Map<Long, Long> firstIdMap) {
        this.firstIdMap = firstIdMap;
    }

    public void setRelateOrgSet(Set<Long> relateOrgSet) {
        this.relateOrgSet = relateOrgSet;
    }
}

