/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.cascade;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.bean.cascade.PRJCascadeBo;
import kd.hr.haos.business.service.projectgroup.cascade.ProjectGroupCascadeService;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.util.LocalDateRange;

public class ParentChangeCascadeService
extends ProjectGroupCascadeService {
    private List<DynamicObject> projectOrgList;
    private static final DynamicObject EMPTY_DY = new DynamicObject();
    private Set<Long> adOrgBoSet;

    @Override
    protected List<PRJCascadeBo> getHisData() {
        Set prjOrgBoCascadeSet = this.getProjectOrgList().stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        Set prjOrgPboCascadeSet = this.getProjectOrgList().stream().map(prjOrg -> prjOrg.getLong("parentorg.id")).filter(bo -> bo != 0L).collect(Collectors.toSet());
        Optional<Date> earliestBsedOpt = this.getProjectOrgList().stream().map(dy -> dy.getDate("bsed")).reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
        Date earliestBsed = earliestBsedOpt.get();
        DynamicObject[] hisStruct4Cascade = OTStructRepository.getInstance().queryOriginalHis4CascadeByOtBo(Stream.of(prjOrgBoCascadeSet, prjOrgPboCascadeSet).flatMap(Collection::stream).collect(Collectors.toSet()), earliestBsed);
        Map isParentVsSLN = Arrays.stream(hisStruct4Cascade).collect(Collectors.groupingBy(struct -> prjOrgPboCascadeSet.contains(struct.getLong("orgteam.id")), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
        List<DynamicObject> cascadeStructList = Arrays.asList(OTStructRepository.getInstance().queryOriginalHisBySLN(isParentVsSLN.getOrDefault(false, Collections.emptySet()), isParentVsSLN.getOrDefault(true, Collections.emptySet()), earliestBsed));
        Set<Long> cascadeBoSet = cascadeStructList.stream().map(struct -> struct.getLong("orgteam.id")).collect(Collectors.toSet());
        DynamicObject[] prjOrgs4Cascade = PRJOrgRepository.getInstance().query4Cascade(cascadeBoSet, earliestBsed);
        DynamicObject[] adOt4Cascade = OTQueryRepository.getInstance().query4Cascade(this.getAdOrgBoSet(), earliestBsed);
        Map<Long, LocalDateRange> parentChgPrjBoVsDateRange = this.getProjectOrgList().stream().collect(Collectors.toMap(prjOrg -> prjOrg.getLong("boid"), LocalDateRangeUtils::getEffectRange));
        List<PRJCascadeBo> prjCascadeBoList = Arrays.stream(prjOrgs4Cascade).map(prjOrg -> {
            LocalDateRange newEffectRange = parentChgPrjBoVsDateRange.getOrDefault(prjOrg.getLong("boid"), null);
            if (newEffectRange == null) {
                return prjOrg;
            }
            LocalDateRange dbPrjEffectRange = LocalDateRangeUtils.getEffectRange(prjOrg);
            if (newEffectRange.encloses(dbPrjEffectRange)) {
                return EMPTY_DY;
            }
            if (newEffectRange.overlaps(dbPrjEffectRange)) {
                prjOrg.set("bsled", (Object)TimeConvertUtil.localDate2Date(newEffectRange.getStart().minusDays(1L)));
                return prjOrg;
            }
            return prjOrg;
        }).filter(dy -> dy != EMPTY_DY).map(this::buildPrjCascadeBo).collect(Collectors.toList());
        prjCascadeBoList.addAll(Arrays.stream(adOt4Cascade).map(this::buildPrjCascadeBo4AdOt).collect(Collectors.toList()));
        return prjCascadeBoList;
    }

    @Override
    protected List<PRJCascadeBo> getChangeData() {
        return this.getProjectOrgList().stream().map(this::buildPrjCascadeBo).collect(Collectors.toList());
    }

    public List<DynamicObject> getProjectOrgList() {
        return this.projectOrgList;
    }

    public void setProjectOrgList(List<DynamicObject> projectOrgList) {
        this.projectOrgList = projectOrgList;
    }

    private Set<Long> getAdOrgBoSet() {
        if (this.adOrgBoSet == null) {
            this.adOrgBoSet = this.projectOrgList.stream().filter(prjOrg -> prjOrg.getLong("parentorg.otclassify.id") == 1010L).map(prjOrg -> prjOrg.getLong("parentorg.id")).collect(Collectors.toSet());
        }
        return this.adOrgBoSet;
    }
}

