/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.projectgroup.bean.cascade.PRJMasterBo;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupChangeService;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public abstract class AbstractProjectGroupDataService {
    private static final OrgTeamBasicInfoBO PRJ_ORG_TEAM_BASIC_INFO_BO = OrgTeamSynService.PRJ_ORG_TEAM_BASIC_INFO_BO;
    protected String prjOtNumberPrefix;
    protected IdCreator idCreator;
    private MainEntityType prjOrgDt;
    private DynamicObjectType prjOrgDtOnlyId;
    private DynamicObjectType bosDt;
    private DynamicObjectType adOrgDt;

    void init() {
        this.prjOtNumberPrefix = OrgTeamSynService.getNumberByPrefixId(1020L);
        this.idCreator = new IdCreator();
        this.prjOrgDt = MetadataServiceHelper.getDataEntityType((String)"haos_projteambaseinfo");
        this.bosDt = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
        this.adOrgDt = EntityMetadataCache.getSubDataEntityType((String)"haos_adminorgdetail", Collections.singletonList("id"));
        this.prjOrgDtOnlyId = EntityMetadataCache.getSubDataEntityType((String)"haos_projteambaseinfo", Collections.singletonList("id"));
    }

    DynamicObject createPrjOrgWithPrjMasterBo(Map<Long, DynamicObject> idVsPrjOrg, PRJMasterBo prjMasterBo) {
        DynamicObject sourcePrjOrg = idVsPrjOrg.get(prjMasterBo.getVid());
        DynamicObject newPrjOrg = new DynamicObject((DynamicObjectType)this.prjOrgDt);
        HRDynamicObjectUtils.copy((DynamicObject)sourcePrjOrg, (DynamicObject)newPrjOrg);
        LocalDateRangeUtils.setEffectRange(newPrjOrg, prjMasterBo.getEffectRange());
        DynamicObject adOrg = new DynamicObject(this.adOrgDt);
        adOrg.set("id", (Object)prjMasterBo.getBelongAdOrgBo());
        newPrjOrg.set("belongadminorg", (Object)adOrg);
        DynamicObject rootPrjOrg = new DynamicObject(this.prjOrgDtOnlyId);
        rootPrjOrg.set("id", (Object)prjMasterBo.getRootProjectTeam());
        newPrjOrg.set("rootprojectteam", (Object)rootPrjOrg);
        DynamicObject org = new DynamicObject(this.bosDt);
        org.set("id", (Object)prjMasterBo.getOrgId());
        newPrjOrg.set("org", (Object)org);
        if (this instanceof ProjectGroupChangeService) {
            newPrjOrg.set("sourcevid", (Object)sourcePrjOrg.getLong("id"));
        }
        return newPrjOrg;
    }

    DynamicObject copyMasterData(DynamicObject pjt) {
        DynamicObject newDy = PRJOrgRepository.getInstance().genEmptyDy();
        HRDynamicObjectUtils.copy((DynamicObject)pjt, (DynamicObject)newDy);
        return newDy;
    }
}

