/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRStringUtils;

public class LocaleStringComparator {
    List<EnabledLang> enabledLangList;
    String errorNumber;
    ILocaleString emptyLocaleString;
    boolean isCompareEmpty = false;

    public boolean compareAnyMatch(ILocaleString localeStringA, ILocaleString localeStringB) {
        this.init();
        boolean isAEmpty = this.isEmpty(localeStringA);
        boolean isBEmpty = this.isEmpty(localeStringB);
        if (isAEmpty && isBEmpty) {
            return true;
        }
        if (!isAEmpty && !isBEmpty) {
            return this.doCompareAnyMatch(localeStringA, localeStringB);
        }
        return false;
    }

    public boolean compareAllMatch(ILocaleString localeStringA, ILocaleString localeStringB) {
        this.init();
        boolean isAEmpty = this.isEmpty(localeStringA);
        boolean isBEmpty = this.isEmpty(localeStringB);
        if (isAEmpty && isBEmpty) {
            return true;
        }
        if (!isAEmpty && !isBEmpty) {
            return this.doCompareAllMatch(localeStringA, localeStringB);
        }
        return false;
    }

    public boolean isBizEmpty(ILocaleString localeString) {
        this.init();
        if (localeString == null) {
            return true;
        }
        return this.isEmpty(localeString);
    }

    private boolean doCompareAllMatch(ILocaleString localeStringA, ILocaleString localeStringB) {
        for (EnabledLang enabledLang : this.enabledLangList) {
            if (this.equals((String)localeStringA.getItem(enabledLang.getNumber()), (String)localeStringB.getItem(enabledLang.getNumber()))) continue;
            return false;
        }
        return true;
    }

    boolean doCompareAnyMatch(ILocaleString localeStringA, ILocaleString localeStringB) {
        for (EnabledLang enabledLang : this.enabledLangList) {
            String number = enabledLang.getNumber();
            if (this.isCompareEmpty) {
                if (!this.equals((String)localeStringA.getItem(number), (String)localeStringB.getItem(number))) continue;
                this.errorNumber = number;
                return true;
            }
            String itemA = (String)localeStringA.getItem(number);
            String itemB = (String)localeStringB.getItem(number);
            if (this.isEmpty(itemA) || this.isEmpty(itemB) || !itemA.equals(itemB)) continue;
            this.errorNumber = number;
            return true;
        }
        return false;
    }

    void init() {
        if (this.enabledLangList == null) {
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            this.enabledLangList = service.getEnabledLang();
        }
    }

    ILocaleString getEmptyLocaleString() {
        this.init();
        if (this.emptyLocaleString == null) {
            LocaleString localeString = new LocaleString("");
            for (EnabledLang enabledLang : this.enabledLangList) {
                localeString.setItem(enabledLang.getNumber(), (Object)"");
            }
            this.emptyLocaleString = localeString;
        }
        return this.emptyLocaleString;
    }

    boolean isEmpty(ILocaleString localeString) {
        for (EnabledLang enabledLang : this.enabledLangList) {
            if (this.isEmpty((String)localeString.getItem(enabledLang.getNumber()))) continue;
            return false;
        }
        return true;
    }

    boolean isEmpty(String str) {
        return HRStringUtils.isEmpty((String)str);
    }

    boolean equals(String strA, String strB) {
        return HRStringUtils.equals((String)strA, (String)strB);
    }

    public String getErrorNumber() {
        return this.errorNumber;
    }

    public void setCompareEmpty(boolean compareEmpty) {
        this.isCompareEmpty = compareEmpty;
    }

    public List<EnabledLang> getEnabledLangList() {
        this.init();
        return this.enabledLangList;
    }
}

