/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ProjChangeEventService
implements ProjectGroupMDConstants {
    final String PAGE_EVENT_SUM = "haos_projcheventsum";
    final String PAGE_EVENT_DETAIL = "haos_projcheventdetail";
    final String PAGE_OP_DETAIL = "haos_projchopdetail";
    static final String HAOS_PROJ_CHANGE_SCENE = "haos_projchangescene";
    static final String HAOS_PROJ_CHANGE_TYPE = "haos_projchangetype";
    static final String HAOS_PROJ_CHANGE_OPERATE = "haos_projchangeoperate";
    static final String CHANGE_DATE = "changedate";
    static final String PROJ_TEAM_ID = "projteamid";
    static final String DATA_SOURCE = "datasource";
    private static final Log log = LogFactory.getLog(ProjChangeEventService.class);
    private Date now;
    private final long creatorId = RequestContext.get().getCurrUserId();
    private String datasource = "";
    private Map<Long, Long> afterVidToBillIdMap;
    static final String DATASOURCE_POSITION = "10";
    static final String DATASOURCE_PROJECT_ROLE = "20";
    private static final ProjChangeEventService INSTANCE = new ProjChangeEventService();
    Map<String, String> datasourceEntity = new HashMap<String, String>(){
        static final long serialVersionUID = 1L;
        {
            this.put(ProjChangeEventService.DATASOURCE_POSITION, "hbpm_positionhr");
            this.put(ProjChangeEventService.DATASOURCE_PROJECT_ROLE, "hbpm_projectrolesdetail");
        }
    };

    public static ProjChangeEventService getInstance() {
        return INSTANCE;
    }

    public static void handleChangeEventHis(HisResponse<BatchVersionChangeRespData> hisResponse, Set<Long> currentBoIds, String entryNumber) {
        List versionChangeRespDataList = ((BatchVersionChangeRespData)hisResponse.getData()).getVersionChangeRespDataList();
        VersionChangeRespData versionChangeRespData = versionChangeRespDataList.stream().filter(s -> s.getEntityNumber().equals(entryNumber)).findFirst().orElse(null);
        if (versionChangeRespData == null) {
            return;
        }
        DynamicObject[] newDynamicObjects = versionChangeRespData.getNewDynamicObjects();
        DynamicObject[] afterData = (DynamicObject[])Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).filter(dyn -> currentBoIds.contains(dyn.getLong("boid"))).toArray(DynamicObject[]::new);
        DynamicObject[] beforeData = ProjChangeEventService.getBeforeDate(afterData);
        ProjChangeEventService.handleChangeEvent(afterData, beforeData);
    }

    public static void handleChangeEventHis(HisResponse<BatchVersionChangeRespData> hisResponse, String entryNumber, Boolean isUnifyChgScene) {
        List versionChangeRespDataList = ((BatchVersionChangeRespData)hisResponse.getData()).getVersionChangeRespDataList();
        VersionChangeRespData versionChangeRespData = versionChangeRespDataList.stream().filter(s -> s.getEntityNumber().equals(entryNumber)).findFirst().orElse(null);
        if (versionChangeRespData == null) {
            return;
        }
        DynamicObject[] newDynamicObjects = versionChangeRespData.getNewDynamicObjects();
        ProjChangeEventService.handleChangeEventHis(isUnifyChgScene, newDynamicObjects);
    }

    public static void handleChangeEventHis(Boolean isUnifyChgScene, DynamicObject[] newDynamicObjects) {
        DynamicObject changeSceneDyn = null;
        DynamicObject changeOperateDyn = null;
        DynamicObject changeTypeDyn = null;
        DynamicObject changeReasonDyn = null;
        if (isUnifyChgScene != null && isUnifyChgScene.booleanValue()) {
            for (DynamicObject dyn2 : newDynamicObjects) {
                if (dyn2.get("changescene") != null) {
                    changeSceneDyn = dyn2.getDynamicObject("changescene");
                }
                if (dyn2.get("changeoperate") != null) {
                    changeOperateDyn = dyn2.getDynamicObject("changeoperate");
                }
                if (dyn2.get("changetype") != null) {
                    changeTypeDyn = dyn2.getDynamicObject("changetype");
                }
                if (dyn2.get("changereason") == null) continue;
                changeReasonDyn = dyn2.getDynamicObject("changereason");
            }
        }
        DynamicObject[] afterData = (DynamicObject[])Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
        DynamicObject[] beforeData = ProjChangeEventService.getBeforeDate(afterData);
        if (changeSceneDyn != null) {
            for (DynamicObject dyn3 : afterData) {
                dyn3.set("changescene", (Object)changeSceneDyn);
                dyn3.set("changeoperate", (Object)changeOperateDyn);
                dyn3.set("changetype", (Object)changeTypeDyn);
                dyn3.set("changereason", (Object)changeReasonDyn);
            }
        }
        ProjChangeEventService.handleChangeEvent(afterData, beforeData);
    }

    public static void handleChangeEvent(DynamicObject[] projTeamDy) {
        long sourceVid = projTeamDy[0].getLong("sourcevid");
        HRBaseServiceHelper prjTeamHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        DynamicObject hisDyn = prjTeamHelper.queryOne((Object)sourceVid);
        hisDyn.set("changescene", (Object)projTeamDy[0].getDynamicObject("changescene"));
        hisDyn.set("changereason", (Object)projTeamDy[0].getDynamicObject("changereason"));
        hisDyn.set("changeoperate", (Object)projTeamDy[0].getDynamicObject("changeoperate"));
        DynamicObject[] hisDynArr = Collections.singletonList(hisDyn).toArray(new DynamicObject[0]);
        ProjChangeEventService.handleChangeEvent(hisDynArr, hisDynArr);
    }

    public static void handleCoopRelChangeEvent(DynamicObject[] projTeamDy) {
        ProjChangeEventService.handleChangeEvent(projTeamDy, projTeamDy);
    }

    private static void handleChangeEvent(DynamicObject[] afterData, DynamicObject[] beforeData) {
        ProjChangeEventService.getInstance().handleChangeEvent(DATASOURCE_PROJECT_ROLE, beforeData, afterData, null, false, false);
    }

    private static DynamicObject[] getBeforeDate(DynamicObject[] afterData) {
        HRBaseServiceHelper projectRoleHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        ArrayList<DynamicObject> beforeData = new ArrayList<DynamicObject>(16);
        for (DynamicObject position : afterData) {
            DynamicObject object = projectRoleHelper.generateEmptyDynamicObject();
            object.set("id", (Object)position.getLong("sourcevid"));
            object.set("boid", (Object)position.getLong("boid"));
            beforeData.add(object);
        }
        return beforeData.toArray(new DynamicObject[0]);
    }

    public void handleChangeEvent(String datasource, DynamicObject[] beforeData, DynamicObject[] afterData, Map<Long, Long> afterVidToBillIdMap, boolean isInitSource, boolean isSendMsg) {
        if (!this.checkParams(datasource, afterData)) {
            return;
        }
        this.datasource = datasource;
        this.afterVidToBillIdMap = afterVidToBillIdMap;
        Map<Object, Object> beforeMap = beforeData == null ? Maps.newHashMapWithExpectedSize((int)8) : Arrays.stream(beforeData).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> dynamicObject, (dy1, dy2) -> dy2));
        long[] eventIds = DB.genGlobalLongIds((int)afterData.length);
        int index = 0;
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList eventDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList opDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        this.now = new Date();
        for (DynamicObject after : afterData) {
            long eventId = eventIds[index++];
            long boid = after.getLong("boid");
            DynamicObject before = (DynamicObject)beforeMap.get(boid);
            DynamicObject event = this.handleEventSum(after, before, eventId);
            eventList.add(event);
            DynamicObject eventDetail = this.handleEventDetail(after, before, eventId);
            eventDetailList.add(eventDetail);
            DynamicObject operDetail = this.handleOpDetail(after, before, eventId, datasource);
            opDetailList.add(operDetail);
        }
        this.saveBatch("haos_projcheventsum", eventList);
        this.saveBatch("haos_projcheventdetail", eventDetailList);
        this.saveBatch("haos_projchopdetail", opDetailList);
    }

    private boolean checkParams(String datasource, DynamicObject[] afterData) {
        if (!this.datasourceEntity.containsKey(datasource)) {
            return false;
        }
        return afterData != null && afterData.length != 0;
    }

    private DynamicObject handleEventSum(DynamicObject after, DynamicObject before, Long eventId) {
        DynamicObject event = this.newEmptyDynamicObject("haos_projcheventsum");
        Long id = ProjChangeEventService.createId("haos_projcheventsum");
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set(DATA_SOURCE, (Object)this.datasource);
        event.set(PROJ_TEAM_ID, (Object)after.getLong("boid"));
        event.set("changescene", (Object)after.getString("changescene.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set(CHANGE_DATE, (Object)after.getDate("bsed"));
        event.set("beforeorg", (Object)(before == null ? 0L : before.getLong("id")));
        event.set("afterorg", (Object)after.getLong("id"));
        if (this.afterVidToBillIdMap != null) {
            event.set("billid", (Object)this.afterVidToBillIdMap.get(after.getLong("id")));
        }
        return event;
    }

    private DynamicObject handleEventDetail(DynamicObject after, DynamicObject before, Long eventId) {
        DynamicObject event = this.newEmptyDynamicObject("haos_projcheventdetail");
        Long id = ProjChangeEventService.createId("haos_projcheventdetail");
        event.set("id", (Object)id);
        event.set("creator", (Object)this.creatorId);
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set(DATA_SOURCE, (Object)this.datasource);
        event.set(PROJ_TEAM_ID, (Object)after.getLong("boid"));
        event.set("changescene", (Object)after.getString("changescene.id"));
        event.set("changereason", (Object)after.getString("changereason.id"));
        event.set(CHANGE_DATE, (Object)after.getDate("bsed"));
        event.set("beforeorg", (Object)(before == null ? 0L : before.getLong("id")));
        event.set("afterorg", (Object)after.getLong("id"));
        return event;
    }

    private DynamicObject handleOpDetail(DynamicObject after, DynamicObject before, Long eventId, String datasource) {
        DynamicObject operDetail = this.newEmptyDynamicObject("haos_projchopdetail");
        Long id = ProjChangeEventService.createId("haos_projchopdetail");
        long changeType = after.getLong("changetype.id");
        operDetail.set("id", (Object)id);
        operDetail.set("creator", (Object)this.creatorId);
        operDetail.set("createtime", (Object)this.now);
        operDetail.set("event", (Object)eventId);
        operDetail.set(DATA_SOURCE, (Object)datasource);
        operDetail.set(PROJ_TEAM_ID, (Object)after.getLong("boid"));
        operDetail.set("changeoperate", (Object)after.getLong("changeoperate.id"));
        operDetail.set(CHANGE_DATE, (Object)after.getDate("bsed"));
        operDetail.set("beforeorg", (Object)(before == null ? 0L : before.getLong("id")));
        operDetail.set("afterorg", (Object)after.getLong("id"));
        operDetail.set("istructchange", (Object)(changeType == CHANGE_TYPE_NEW || changeType == CHANGETYPE_CHANGEPARENT ? 1 : 0));
        operDetail.set("isinfochange", (Object)(changeType != CHANGETYPE_DISABLE_ID ? 1 : 0));
        return operDetail;
    }

    private static Long createId(String pageValue) {
        return ORM.create().genLongId(pageValue);
    }

    private DynamicObject newEmptyDynamicObject(String pageValue) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageValue);
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }

    public void delEvent(List<Long> positionIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("haos_projcheventsum");
        DynamicObject[] eventsums = eventsumHelper.queryOriginalArray("id,event", new QFilter[]{new QFilter("TARGETPOSITION", "in", positionIds)});
        Set<Long> eventIds = Arrays.stream(eventsums).map(eventsum -> eventsum.getLong("event")).collect(Collectors.toSet());
        this.delEventSum(eventIds);
        ProjChangeEventService.getInstance().delEventDetail(eventIds);
        ProjChangeEventService.getInstance().delOpDetail(eventIds);
    }

    public Map<Long, List<DynamicObject>> getOpdetailByEventIds(List<Long> eventIds) {
        if (eventIds == null || eventIds.size() == 0) {
            return Maps.newHashMapWithExpectedSize((int)8);
        }
        DynamicObject[] opDetails = this.selectOpDetail(eventIds);
        HashMap eventIdToDetailsMap = Maps.newHashMapWithExpectedSize((int)eventIds.size());
        Arrays.stream(opDetails).forEach(opDetail -> {
            Long eventId = opDetail.getLong("event");
            List details = (List)eventIdToDetailsMap.get(eventId);
            if (details == null) {
                details = Lists.newArrayListWithExpectedSize((int)eventIds.size());
            }
            details.add(opDetail);
            eventIdToDetailsMap.put(eventId, details);
        });
        return eventIdToDetailsMap;
    }

    public void saveBatch(String entityPage, List<DynamicObject> dynamicObjects) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityPage);
        serviceHelper.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    public void delEventSum(Set<Long> eventIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("haos_projcheventsum");
        QFilter[] qFilters = new QFilter[]{new QFilter("event", "in", eventIds)};
        eventsumHelper.deleteByFilter(qFilters);
    }

    public void delEventDetail(Set<Long> eventIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("haos_projcheventdetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("event", "in", eventIds)};
        eventsumHelper.deleteByFilter(qFilters);
    }

    public void delOpDetail(Set<Long> eventIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("haos_projchopdetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("event", "in", eventIds)};
        eventsumHelper.deleteByFilter(qFilters);
    }

    public DynamicObject[] selectOpDetail(List<Long> eventIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("haos_projchopdetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("event", "in", eventIds)};
        return eventsumHelper.loadDynamicObjectArray(qFilters);
    }
}

