/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.projectgroup.bean.cascade.PRJMasterBo;
import kd.hr.haos.business.service.projectgroup.cascade.ParentChangeCascadeService;
import kd.hr.haos.business.service.projectgroup.service.AbstractProjectGroupDataService;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.model.prj.OpParam;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class ProjectGroupChangeService
extends AbstractProjectGroupDataService {
    private Long eventId;
    private DynamicObject[] prjOrgs;
    private OpParam opParam;
    private PrjOrgChangeProcessable changeService;
    private Set<Long> prjBoSet;

    public ProjectGroupChangeService(OpParam opParam) {
        this.opParam = opParam;
        switch (opParam.getOpType()) {
            case "donothing_confirmchangeinfo": {
                this.changeService = new ChangeInfoService();
                break;
            }
            case "donothing_confirmchangeparent": {
                this.changeService = new changeParentService();
                break;
            }
            default: {
                throw new RuntimeException("no supported type");
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.prjBoSet = Arrays.stream(this.prjOrgs).map(prjOrg -> prjOrg.getLong("boid")).collect(Collectors.toSet());
        Arrays.stream(this.prjOrgs).filter(prjOrg -> prjOrg.getLong("id") == prjOrg.getLong("boid")).forEach(prjOrg -> prjOrg.set("id", (Object)this.idCreator.getId()));
    }

    public HisResponse<BatchVersionChangeRespData> change() {
        List<DynamicObject> needSavePrjOrgList = this.changeService.createSavePrjOrgList();
        Map<Boolean, List<DynamicObject>> isCurBatchVsPrjOrgList = needSavePrjOrgList.stream().collect(Collectors.groupingBy(prjOrg -> this.prjBoSet.contains(prjOrg.getLong("boid"))));
        List<DynamicObject> needSaveCurBatchPrjOrgList = isCurBatchVsPrjOrgList.getOrDefault(true, Collections.emptyList());
        List<DynamicObject> needSave4CascadePrjOrgList = isCurBatchVsPrjOrgList.getOrDefault(false, Collections.emptyList());
        this.changeService.setValueAfterCascade(needSaveCurBatchPrjOrgList);
        this.changeService.setValueForCascade(needSave4CascadePrjOrgList);
        this.saveOtHis(needSavePrjOrgList);
        return this.savePjt(needSavePrjOrgList);
    }

    private HisResponse<BatchVersionChangeRespData> savePjt(List<DynamicObject> needSavePrjOrgList) {
        List invalidList;
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
        Function<DynamicObject[], Map> groupFunction = dyArr -> {
            if (((DynamicObject[])dyArr).length == 0) {
                return Collections.emptyMap();
            }
            return Arrays.stream(dyArr).collect(Collectors.groupingBy(dy -> date2999.equals(dy.getDate("bsled")), Collectors.toList()));
        };
        DynamicObject[] hisDyns = needSavePrjOrgList.toArray(new DynamicObject[0]);
        Map is2999VsDyList = groupFunction.apply(hisDyns);
        HisResponse<BatchVersionChangeRespData> effectingRespDataHisResponse = null;
        HisResponse<BatchVersionChangeRespData> invalidRespDataHisResponse = null;
        List effectingList = (List)is2999VsDyList.get(true);
        if (effectingList != null) {
            HisVersionParamBo prjOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(effectingList.toArray(new DynamicObject[0]), "haos_projteambaseinfo", true);
            ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(1);
            listHisVersionParamBo.add(prjOrgHisVersionParam);
            effectingRespDataHisResponse = this.saveHis(listHisVersionParamBo);
        }
        if ((invalidList = (List)is2999VsDyList.get(false)) != null) {
            HisVersionParamBo prjOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidList.toArray(new DynamicObject[0]), "haos_projteambaseinfo", true);
            ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(1);
            listHisVersionParamBo.add(prjOrgHisVersionParam);
            invalidRespDataHisResponse = this.saveHis(listHisVersionParamBo);
        }
        return this.merge(effectingRespDataHisResponse, invalidRespDataHisResponse);
    }

    private HisResponse<BatchVersionChangeRespData> merge(HisResponse<BatchVersionChangeRespData> effectingRespDataHisResponse, HisResponse<BatchVersionChangeRespData> invalidRespDataHisResponse) {
        if (effectingRespDataHisResponse == null) {
            return invalidRespDataHisResponse;
        }
        if (invalidRespDataHisResponse == null) {
            return effectingRespDataHisResponse;
        }
        DynamicObject[] effectingNewDynamicObjects = ((VersionChangeRespData)((BatchVersionChangeRespData)effectingRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects();
        DynamicObject[] invalidNewDynamicObjects = ((VersionChangeRespData)((BatchVersionChangeRespData)invalidRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects();
        ((VersionChangeRespData)((BatchVersionChangeRespData)effectingRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).setNewDynamicObjects((DynamicObject[])Stream.concat(Arrays.stream(effectingNewDynamicObjects), Arrays.stream(invalidNewDynamicObjects)).toArray(DynamicObject[]::new));
        return effectingRespDataHisResponse;
    }

    private HisResponse<BatchVersionChangeRespData> saveOtHis(List<DynamicObject> needSavePrjOrgList) {
        HRBaseServiceHelper otClassifyHelper = new HRBaseServiceHelper("haos_otclassify");
        DynamicObject otClassifyDyn = otClassifyHelper.generateEmptyDynamicObject();
        otClassifyDyn.set("id", (Object)1020L);
        List saveOtList = needSavePrjOrgList.stream().map(prjOrg -> {
            DynamicObject newOt = OTQueryRepository.getInstance().genEmptyDy();
            HRDynamicObjectUtils.copy((DynamicObject)prjOrg, (DynamicObject)newOt);
            OrgTeamSynService.getInstance().setOtType(newOt);
            new OrgTeamSynService().synOrgTeamBizFields(newOt, (DynamicObject)prjOrg, this.prjOtNumberPrefix);
            newOt.set("parent", (Object)prjOrg.getDynamicObject("parentorg"));
            newOt.set("id", (Object)prjOrg.getLong("id"));
            newOt.set("otclassify", (Object)otClassifyDyn);
            return newOt;
        }).collect(Collectors.toList());
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setEventId(this.getEventId().longValue());
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        this.changeService.setBatchSynModel(batchSynModel);
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setSaveList(saveOtList);
        batchSynModel.setStrucrProjectId(1020L);
        return orgTeamBatchSynService.syn();
    }

    private List<DynamicObject> createOrgTeam() {
        return Arrays.stream(this.prjOrgs).map(prjOrg -> {
            DynamicObject ot = OTQueryRepository.getInstance().genEmptyDy(Arrays.asList("id", "boid", "parentid", "bsed", "bsled", "structnumber", "status", "enable", "initbatch", "initdatasource", "initstatus", "billenable"));
            ot.set("id", (Object)prjOrg.getLong("id"));
            ot.set("boid", (Object)prjOrg.getLong("boid"));
            ot.set("parentid", (Object)prjOrg.getLong("parentorg.id"));
            LocalDateRangeUtils.synEffectRange(prjOrg, ot);
            ot.set("structnumber", prjOrg.get("structnumber"));
            ot.set("status", prjOrg.get("status"));
            ot.set("enable", prjOrg.get("enable"));
            ot.set("initstatus", prjOrg.get("initstatus"));
            ot.set("initbatch", prjOrg.get("initbatch"));
            ot.set("initdatasource", prjOrg.get("initdatasource"));
            return ot;
        }).collect(Collectors.toList());
    }

    private HisResponse<BatchVersionChangeRespData> saveHis(List<HisVersionParamBo> hisVersionParamBoList) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (this.eventId != null && !this.eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(this.eventId);
        }
        hisVersionParamListBo.setListHisVersionParamBo(hisVersionParamBoList);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public DynamicObject[] getPrjOrgs() {
        return this.prjOrgs;
    }

    public void setPrjOrgs(DynamicObject[] prjOrgs) {
        this.prjOrgs = prjOrgs;
    }

    public OpParam getOpParam() {
        return this.opParam;
    }

    static class SceneVsCascadeResult {
        CascadeResult parentChgResult = new CascadeResult();
        CascadeResult cascadeResult = new CascadeResult();

        SceneVsCascadeResult() {
        }
    }

    static interface PrjOrgChangeProcessable {
        default public void setBatchSynModel(BatchSynModel batchSynModel) {
        }

        default public List<DynamicObject> createSavePrjOrgList() {
            return Collections.emptyList();
        }

        default public void setValueAfterCascade(List<DynamicObject> needSaveCurBatchPrjOrgList) {
            Date now = new Date();
            needSaveCurBatchPrjOrgList.forEach(dy -> dy.set("createtime", (Object)now));
        }

        default public void setValueForCascade(List<DynamicObject> needSave4CascadePrjOrgList) {
            Date now = new Date();
            DynamicObject administrator = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            administrator.set("id", (Object)1);
            needSave4CascadePrjOrgList.forEach(dy -> {
                dy.set("createtime", (Object)now);
                dy.set("creator", (Object)administrator);
            });
        }
    }

    private class changeParentService
    implements PrjOrgChangeProcessable {
        private changeParentService() {
        }

        @Override
        public void setBatchSynModel(BatchSynModel batchSynModel) {
            batchSynModel.setChgParentList(ProjectGroupChangeService.this.createOrgTeam());
        }

        @Override
        public List<DynamicObject> createSavePrjOrgList() {
            ParentChangeCascadeService parentChangeCascadeService = new ParentChangeCascadeService();
            parentChangeCascadeService.setProjectOrgList(Arrays.asList(ProjectGroupChangeService.this.prjOrgs));
            CascadeResult cascadeResult = parentChangeCascadeService.getResult();
            Set<Long> prjOrgIdSet = cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
            DynamicObject[] dbPrjOrgs = PRJOrgRepository.getInstance().loadByIds(prjOrgIdSet);
            Map<Long, DynamicObject> idVsPrjOrg = Arrays.stream(dbPrjOrgs).collect(Collectors.toMap(prjOrg -> prjOrg.getLong("id"), obj -> obj));
            Arrays.stream(ProjectGroupChangeService.this.prjOrgs).forEach(prjOrg -> idVsPrjOrg.put(prjOrg.getLong("id"), (DynamicObject)prjOrg));
            SceneVsCascadeResult sceneVsCascadeResult = new SceneVsCascadeResult();
            cascadeResult.foreach((bo, partBoList) -> {
                if (ProjectGroupChangeService.this.prjBoSet.contains(bo)) {
                    sceneVsCascadeResult.parentChgResult.put(bo.longValue(), partBoList);
                } else {
                    sceneVsCascadeResult.cascadeResult.put(bo.longValue(), partBoList);
                }
            });
            ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
            List cascadePrjOrgList = sceneVsCascadeResult.cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(partBo -> (PRJMasterBo)((Object)partBo)).map(prjMasterBo -> ProjectGroupChangeService.this.createPrjOrgWithPrjMasterBo(idVsPrjOrg, (PRJMasterBo)((Object)prjMasterBo))).peek(dy -> dy.set("id", (Object)ProjectGroupChangeService.this.idCreator.getId())).collect(Collectors.toList());
            List parentChgPrjOrgList = Arrays.stream(ProjectGroupChangeService.this.prjOrgs).map(prjOrg -> {
                long prjOrgBo = prjOrg.getLong("boid");
                List partBoList = sceneVsCascadeResult.parentChgResult.get(prjOrgBo);
                LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(prjOrg);
                List cascadeDateRangeList = partBoList.stream().map(PartBo::getEffectRange).collect(Collectors.toList());
                List unCascadeDateRangeList = effectRange.subtract(cascadeDateRangeList);
                List parentChgCascadePrjOrgList = partBoList.stream().map(partBo -> (PRJMasterBo)((Object)((Object)partBo))).map(prjMasterBo -> ProjectGroupChangeService.this.createPrjOrgWithPrjMasterBo(idVsPrjOrg, (PRJMasterBo)((Object)((Object)prjMasterBo)))).peek(dy -> dy.set("id", (Object)ProjectGroupChangeService.this.idCreator.getId())).collect(Collectors.toList());
                List parentChgNoCascadePrgOrgList = unCascadeDateRangeList.stream().map(dateRange -> {
                    DynamicObject newPrjOrg = PRJOrgRepository.getInstance().genEmptyDy();
                    HRDynamicObjectUtils.copy((DynamicObject)prjOrg, (DynamicObject)newPrjOrg);
                    newPrjOrg.set("id", (Object)ProjectGroupChangeService.this.idCreator.getId());
                    LocalDateRangeUtils.setEffectRange(newPrjOrg, dateRange);
                    return newPrjOrg;
                }).collect(Collectors.toList());
                ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
                result.addAll(parentChgCascadePrjOrgList);
                result.addAll(parentChgNoCascadePrgOrgList);
                this.setPartBoSourceVid((DynamicObject)prjOrg, (List<DynamicObject>)result);
                return result;
            }).flatMap(Collection::stream).collect(Collectors.toList());
            resultList.addAll(parentChgPrjOrgList);
            resultList.addAll(cascadePrjOrgList);
            return resultList;
        }

        private void setPartBoSourceVid(DynamicObject prjOrg, List<DynamicObject> result) {
            long tmpSourceVid = 0L;
            result.sort(Comparator.comparing(dyn -> dyn.getDate("bsed")));
            for (int i = 0; i < result.size(); ++i) {
                DynamicObject newPrjOrg = result.get(i);
                if (i == 0) {
                    newPrjOrg.set("sourcevid", (Object)prjOrg.getLong("sourcevid"));
                } else {
                    newPrjOrg.set("sourcevid", (Object)tmpSourceVid);
                }
                tmpSourceVid = newPrjOrg.getLong("id");
            }
        }
    }

    private class ChangeInfoService
    implements PrjOrgChangeProcessable {
        private ChangeInfoService() {
        }

        @Override
        public void setBatchSynModel(BatchSynModel batchSynModel) {
            batchSynModel.setChgInfoList(ProjectGroupChangeService.this.createOrgTeam());
        }

        @Override
        public List<DynamicObject> createSavePrjOrgList() {
            return Arrays.stream(ProjectGroupChangeService.this.prjOrgs).map(prjOrg -> {
                DynamicObject newPrjOrg = PRJOrgRepository.getInstance().genEmptyDy();
                HRDynamicObjectUtils.copy((DynamicObject)prjOrg, (DynamicObject)newPrjOrg);
                newPrjOrg.set("id", (Object)ProjectGroupChangeService.this.idCreator.getId());
                newPrjOrg.set("sourcevid", (Object)prjOrg.getLong("sourcevid"));
                return newPrjOrg;
            }).collect(Collectors.toList());
        }
    }
}

