/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ProjectGroupRoleService
implements ProjectGroupMDConstants {
    private static final Log log = LogFactory.getLog(ProjectGroupRoleService.class);
    private static final ProjectGroupRoleService projectGroupRoleService = new ProjectGroupRoleService();
    private static final String PAGE_ROLE_PLAN = "hbpm_roleplan";
    private static final String PAGE_PROJECT_ROLE = "hbpm_projectroles";

    public static ProjectGroupRoleService getInstance() {
        return projectGroupRoleService;
    }

    public List<DynamicObject> buildAddNewHisParam(DynamicObject[] dynamicObjects) {
        HRBaseServiceHelper projectRolePlanHelper = new HRBaseServiceHelper(PAGE_ROLE_PLAN);
        QFilter filter = new QFilter("isdefaultplan", "=", (Object)"1");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject defaultRolePlan = projectRolePlanHelper.loadDynamicObject(new QFilter[]{filter});
        if (defaultRolePlan == null) {
            return null;
        }
        DynamicObjectCollection projectRolePlanList = defaultRolePlan.getDynamicObjectCollection("roleentryentity");
        if (projectRolePlanList.size() == 0) {
            return null;
        }
        HRBaseServiceHelper projectRoleService = new HRBaseServiceHelper(PAGE_PROJECT_ROLE);
        ArrayList projectRoleList = Lists.newArrayListWithCapacity((int)(dynamicObjects.length * projectRolePlanList.size()));
        long[] ids = ORM.create().genLongIds(PAGE_PROJECT_ROLE, dynamicObjects.length * (projectRolePlanList.size() + 1));
        Queue idQueue = Arrays.stream(ids).boxed().collect(Collectors.toCollection(ArrayDeque::new));
        for (DynamicObject dynamicObject : dynamicObjects) {
            long projectId = dynamicObject.getLong("id");
            Date establishDate = dynamicObject.getDate("establishmentdate");
            Date bSedDate = dynamicObject.getDate("bsed");
            String projectNumber = dynamicObject.getString("number");
            long parentOrg = dynamicObject.getLong("parentorg.id");
            long mainHeadId = (Long)idQueue.poll();
            for (DynamicObject projectRolePlan : projectRolePlanList) {
                DynamicObject projectRole = projectRoleService.generateEmptyDynamicObject();
                projectRole.set("name", projectRolePlan.get("role.name"));
                boolean isMainHead = projectRolePlan.getBoolean("ismainhead");
                if (isMainHead) {
                    projectRole.set("id", (Object)mainHeadId);
                } else {
                    projectRole.set("id", idQueue.poll());
                }
                projectRole.set("rolestype", (Object)this.getRoleTypeDynByMainHead(isMainHead));
                projectRole.set("isdutypers", (Object)isMainHead);
                projectRole.set("projteam", (Object)projectId);
                projectRole.set("enable", (Object)"1");
                projectRole.set("status", (Object)"C");
                projectRole.set("superroles", (Object)this.getSuperRole(isMainHead, mainHeadId, parentOrg));
                projectRole.set("design", (Object)establishDate);
                projectRole.set("number", (Object)(projectNumber + "_" + projectRolePlan.get("role.number")));
                projectRole.set("bsed", (Object)bSedDate);
                projectRole.set("description", projectRolePlan.get("role.description"));
                projectRole.set("initstatus", (Object)"2");
                projectRole.set("org", (Object)dynamicObject.getDynamicObject("org"));
                projectRoleList.add(projectRole);
            }
        }
        return projectRoleList;
    }

    public DynamicObject getRoleTypeDynByMainHead(Boolean isMainHead) {
        HRBaseServiceHelper roleTypeHelper = new HRBaseServiceHelper("hbpm_roletype");
        DynamicObject roleTypeDyn = roleTypeHelper.generateEmptyDynamicObject();
        if (isMainHead.booleanValue()) {
            roleTypeDyn.set("id", (Object)1010L);
        } else {
            roleTypeDyn.set("id", (Object)1030L);
        }
        log.info("ProjectGroupRoleService.getRoleTypeDynByMainHead,isMainHead={},roleTypeDyn.id={}", (Object)isMainHead, (Object)roleTypeDyn.getLong("id"));
        return roleTypeDyn;
    }

    private Long getSuperRole(boolean isMainHead, Long mainHeadId, Long parentOrg) {
        if (isMainHead) {
            HRBaseServiceHelper workRoleHelper = new HRBaseServiceHelper("hbpm_workroleshr");
            QFilter prjFilter = new QFilter("adminorg", "=", (Object)parentOrg);
            QFilter dutyFilter = new QFilter("mainpeoincharge", "=", (Object)"1");
            DynamicObject[] projectRole = workRoleHelper.queryOriginalArray("id", new QFilter[]{prjFilter, dutyFilter, FILTER_IS_CURRENT_VERSION, FILTER_ENABLE});
            if (projectRole.length == 1) {
                return projectRole[0].getLong("id");
            }
            return null;
        }
        return mainHeadId;
    }
}

