/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.haos.common.constants.projectgroup.model.PermissionNeedParamModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamPermissionUtil {
    public static PermissionNeedParamModel extraPermissionModel(IFormView view) {
        ListShowParameter listParameter = (ListShowParameter)view.getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String permItemId = "47150e89000000ac";
        boolean isF7 = listParameter.isLookUp();
        if (isF7) {
            permEntityId = OrgTeamPermissionUtil.getF7ParentEntityId(view);
            permItemId = OrgTeamPermissionUtil.getF7ParentPermItemId(view);
        }
        permEntityId = OrgTeamPermissionUtil.getDataEntityNumber(permEntityId);
        String appId = OrgTeamPermissionUtil.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
        return new PermissionNeedParamModel(permEntityId, permItemId, Boolean.valueOf(isF7), appId);
    }

    private static String getF7ParentEntityId(IFormView curView) {
        IFormView parentView = OrgTeamPermissionUtil.getParentNoPlugin(curView);
        String customEntityNumber = (String)parentView.getFormShowParameter().getCustomParam("customHREntityNumber");
        if (HRStringUtils.isNotEmpty((String)customEntityNumber)) {
            return customEntityNumber;
        }
        if (parentView.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parentListParameter = (ListShowParameter)parentView.getFormShowParameter();
            return parentListParameter.getBillFormId();
        }
        return parentView.getFormShowParameter().getFormId();
    }

    private static IFormView getParentNoPlugin(IFormView curView) {
        return curView.getViewNoPlugin(curView.getFormShowParameter().getParentPageId());
    }

    private static String getF7ParentPermItemId(IFormView curView) {
        IFormView parentView = OrgTeamPermissionUtil.getParentNoPlugin(curView);
        String customPermItemId = (String)parentView.getFormShowParameter().getCustomParam("customHRPermItemId");
        return HRStringUtils.isNotEmpty((String)customPermItemId) ? customPermItemId : parentView.getFormShowParameter().getPermissionItemId();
    }

    private static String getDataEntityNumber(String entityNumber) {
        return FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId();
    }

    private static String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = OrgTeamPermissionUtil.getAppIdFromShowParam(showParameter);
        return OrgTeamPermissionUtil.getPermAppId(entryAppId, entityNumber);
    }

    private static String getAppIdFromShowParam(FormShowParameter showParameter) {
        String appNumber = showParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        return appInfo != null ? appInfo.getId() : null;
    }

    private static String getPermAppId(String entryAppId, String entityNumber) {
        String oriAppId = FormMetadataCache.getFormConfig((String)entityNumber).getAppId();
        if (HRStringUtils.equals((String)entryAppId, (String)(oriAppId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)oriAppId)))) {
            return entryAppId;
        }
        return OrgTeamPermissionUtil.isPulbicAppId(entryAppId, entityNumber) ? entryAppId : oriAppId;
    }

    private static boolean isPulbicAppId(String appId, String entityNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_bizobjapp");
        QFilter qFilter = new QFilter("bizobj.id", "=", (Object)entityNumber);
        DynamicObject[] dynoArr = helper.queryOriginalArray("bizapp.id", new QFilter[]{qFilter});
        HashSet publicAppIds = Sets.newHashSetWithExpectedSize((int)dynoArr.length);
        for (DynamicObject dyno : dynoArr) {
            publicAppIds.add(dyno.getString("bizapp.id"));
        }
        return publicAppIds.contains(appId);
    }
}

