/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.service.orgteam.CycleChecker;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.constants.TeamCoopRelConstants;
import kd.hr.haos.common.model.cascade.CycleCheckBoWithType;
import kd.hr.haos.common.model.cascade.CycleCheckResultWithType;
import kd.hr.haos.common.util.LocalDateRange;

public class ProjectGroupValidHelper {
    public static boolean checkDateEarlier(Date curDate, Date anoDate) {
        return curDate.before(anoDate);
    }

    public static boolean checkDateLater(Date curDate, Date anoDate) {
        return curDate.after(anoDate);
    }

    public static List<CycleCheckResultWithType> checkCoopRel4New(List<DynamicObject> pjtList) {
        CycleCheckSwitch cycleCheckSwitch = new CycleCheckSwitch();
        cycleCheckSwitch.checkAdCoopRel = true;
        cycleCheckSwitch.checkOtherCoopRel = true;
        cycleCheckSwitch.changeHisData = false;
        return ProjectGroupValidHelper.checkCoopRel(pjtList, cycleCheckSwitch);
    }

    public static List<CycleCheckResultWithType> checkCoopAffRel(List<DynamicObject> otList, boolean changeHisData) {
        CycleCheckSwitch cycleCheckSwitch = new CycleCheckSwitch();
        cycleCheckSwitch.checkAdCoopRel = true;
        cycleCheckSwitch.checkOtherCoopRel = false;
        cycleCheckSwitch.changeHisData = changeHisData;
        cycleCheckSwitch.entityName = "haos_adminorgteam";
        return ProjectGroupValidHelper.checkCoopRel(otList, cycleCheckSwitch);
    }

    public static List<CycleCheckResultWithType> checkCoopRel4CoopRelChange(List<DynamicObject> pjtList) {
        CycleCheckSwitch cycleCheckSwitch = new CycleCheckSwitch();
        cycleCheckSwitch.checkAdCoopRel = false;
        cycleCheckSwitch.checkOtherCoopRel = true;
        cycleCheckSwitch.changeHisData = true;
        return ProjectGroupValidHelper.checkCoopRel(pjtList, cycleCheckSwitch);
    }

    public static List<CycleCheckResultWithType> checkCoopRel4ParentChange(List<DynamicObject> pjtList) {
        CycleCheckSwitch cycleCheckSwitch = new CycleCheckSwitch();
        cycleCheckSwitch.checkAdCoopRel = true;
        cycleCheckSwitch.checkOtherCoopRel = false;
        cycleCheckSwitch.changeHisData = true;
        return ProjectGroupValidHelper.checkCoopRel(pjtList, cycleCheckSwitch);
    }

    public static List<CycleCheckResultWithType> checkCoopRel(List<DynamicObject> pjtList, CycleCheckSwitch cycleCheckSwitch) {
        List<CycleCheckBoWithType> cycleCheckBoList;
        List<Date> bsedList = pjtList.stream().map(dy -> dy.getDate("bsed")).collect(Collectors.toList());
        Date minDate = LocalDateRangeUtils.getMinDate(bsedList);
        HashSet<Long> coopRelTypeSet = new HashSet<Long>();
        if (cycleCheckSwitch.checkOtherCoopRel) {
            pjtList.stream().map(dy -> dy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(coopRelRow -> coopRelRow.getLong("coopreltype.id")).forEach(coopRelTypeSet::add);
        }
        if (cycleCheckSwitch.checkAdCoopRel) {
            coopRelTypeSet.add(TeamCoopRelConstants.AFFILIATION_ID);
        }
        List<Long> boIdList = pjtList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        List<CycleCheckBoWithType> memoryCycleCheckBoList = pjtList.stream().map(dy -> {
            ArrayList<CycleCheckBoWithType> result = new ArrayList<CycleCheckBoWithType>();
            if (cycleCheckSwitch.checkAdCoopRel) {
                CycleCheckBoWithType cycleCheckBo = "haos_adminorgteam".equals(cycleCheckSwitch.entityName) ? ProjectGroupValidHelper.getCycleCheckBoByAff(dy) : ProjectGroupValidHelper.getCycleCheckBoWithTypeByAdRel(dy);
                result.add(cycleCheckBo);
            }
            if (cycleCheckSwitch.checkOtherCoopRel) {
                DynamicObjectCollection coopRelEntry = dy.getDynamicObjectCollection("entryentity");
                coopRelEntry.stream().map(row -> {
                    CycleCheckBoWithType cycleCheckBo = new CycleCheckBoWithType();
                    cycleCheckBo.setParentBo(row.getLong("cooporgteam.id"));
                    cycleCheckBo.setRelTypeId(row.getLong("coopreltype.id"));
                    cycleCheckBo.setBo(dy.getLong("boid"));
                    cycleCheckBo.setEffectRange(LocalDateRangeUtils.getEffectRange(dy));
                    return cycleCheckBo;
                }).forEach(result::add);
            }
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (cycleCheckSwitch.changeHisData) {
            DynamicObject[] dbAdCoopRels = TeamCoopRelRepository.getInstance().queryOriginalArrayAllOneTypeRelByBsed("org.id, cooporgteam.id, coopreltype.id, bsed, bsled", coopRelTypeSet, minDate);
            List<CycleCheckBoWithType> dbCycleCheckBoList = Arrays.stream(dbAdCoopRels).map(ProjectGroupValidHelper::createCycleCheckBoWithTypeByDBCoopRelDy).collect(Collectors.toList());
            cycleCheckBoList = ProjectGroupValidHelper.overlapHisData(memoryCycleCheckBoList, dbCycleCheckBoList);
        } else {
            cycleCheckBoList = new ArrayList<CycleCheckBoWithType>(memoryCycleCheckBoList);
        }
        return new CycleChecker().checkWithType(cycleCheckBoList, boIdList);
    }

    private static List<CycleCheckBoWithType> overlapHisData(List<CycleCheckBoWithType> memoryCycleCheckBoList, List<CycleCheckBoWithType> dbCycleCheckBoList) {
        Function<CycleCheckBoWithType, String> stringConvert = cycleCheckBoWithType -> String.format("%s+%s", cycleCheckBoWithType.getBo(), cycleCheckBoWithType.getRelTypeId());
        Map<String, List<CycleCheckBoWithType>> boRelTypeVsDBCheckBo = dbCycleCheckBoList.stream().collect(Collectors.groupingBy(stringConvert));
        memoryCycleCheckBoList.forEach(memoryCheckBo -> {
            String boTypeStr = (String)stringConvert.apply((CycleCheckBoWithType)memoryCheckBo);
            List dbCheckBoList = boRelTypeVsDBCheckBo.getOrDefault(boTypeStr, Collections.emptyList());
            List checkedDbCheckBoList = dbCheckBoList.stream().filter(dbCheckBo -> !memoryCheckBo.getEffectRange().encloses(dbCheckBo.getEffectRange())).peek(dbCheckBo -> {
                if (dbCheckBo.getEffectRange().overlaps(memoryCheckBo.getEffectRange())) {
                    LocalDateRange diffEffectRange = (LocalDateRange)dbCheckBo.getEffectRange().subtract(memoryCheckBo.getEffectRange()).get(0);
                    dbCheckBo.setEffectRange(diffEffectRange);
                }
            }).collect(Collectors.toList());
            boRelTypeVsDBCheckBo.put(boTypeStr, checkedDbCheckBoList);
        });
        ArrayList<CycleCheckBoWithType> result = new ArrayList<CycleCheckBoWithType>();
        result.addAll(memoryCycleCheckBoList);
        boRelTypeVsDBCheckBo.values().forEach(result::addAll);
        return result;
    }

    private static CycleCheckBoWithType getCycleCheckBoByAff(DynamicObject otDy) {
        CycleCheckBoWithType cycleCheckBo = new CycleCheckBoWithType();
        cycleCheckBo.setBo(otDy.getLong("boid"));
        cycleCheckBo.setParentBo(otDy.getLong("parent.id"));
        cycleCheckBo.setEffectRange(LocalDateRangeUtils.getEffectRange(otDy));
        cycleCheckBo.setRelTypeId(TeamCoopRelConstants.AFFILIATION_ID.longValue());
        return cycleCheckBo;
    }

    private static CycleCheckBoWithType getCycleCheckBoWithTypeByAdRel(DynamicObject dy) {
        CycleCheckBoWithType cycleCheckBo = new CycleCheckBoWithType();
        cycleCheckBo.setBo(dy.getLong("boid"));
        cycleCheckBo.setParentBo(dy.getLong("parentorg.id"));
        cycleCheckBo.setEffectRange(LocalDateRangeUtils.getEffectRange(dy));
        cycleCheckBo.setRelTypeId(TeamCoopRelConstants.AFFILIATION_ID.longValue());
        return cycleCheckBo;
    }

    private static CycleCheckBoWithType createCycleCheckBoWithTypeByDBCoopRelDy(DynamicObject dy) {
        CycleCheckBoWithType cycleCheckBo = new CycleCheckBoWithType();
        cycleCheckBo.setBo(dy.getLong("org.id"));
        cycleCheckBo.setParentBo(dy.getLong("cooporgteam.id"));
        cycleCheckBo.setEffectRange(LocalDateRangeUtils.getEffectRange(dy));
        cycleCheckBo.setRelTypeId(dy.getLong("coopreltype.id"));
        return cycleCheckBo;
    }

    private static class CycleCheckSwitch {
        boolean checkAdCoopRel;
        boolean checkOtherCoopRel;
        boolean changeHisData;
        String entityName;

        private CycleCheckSwitch() {
        }
    }
}

