/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.calibrator;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;
import kd.hr.haos.business.util.CycleDetector;
import kd.hr.haos.business.util.DirectedGraph;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ProjectGroupCoopRelCycleValidator
implements ProjectGroupValidService,
ProjectGroupMDConstants {
    private static final Log logger = LogFactory.getLog(ProjectGroupCoopRelCycleValidator.class);
    public Map<Long, String> coopRelTypeIdNameMap;

    public ProjectGroupCoopRelCycleValidator() {
        HRBaseServiceHelper coopRelTypeHelper = new HRBaseServiceHelper("haos_teamcoopreltype");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] coopRelTypeArr = coopRelTypeHelper.queryOriginalArray("id, name", new QFilter[]{enableFilter});
        this.coopRelTypeIdNameMap = Arrays.stream(coopRelTypeArr).collect(Collectors.toMap(coopRelInfo -> coopRelInfo.getLong("id"), coopRelInfo -> coopRelInfo.getString("name")));
    }

    @Override
    public List<CalibratorBean> valid(ProjectGroupValidContext context) {
        DynamicObject targetObject = context.getTargetObject();
        DynamicObjectCollection coopInfoList = targetObject.getDynamicObjectCollection("entryentity");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        long boId = targetObject.getLong("boid");
        long parentOrgId = targetObject.getLong("parentorg.id");
        Map<Long, List<DynamicObject>> coopInfoMap = coopInfoList.stream().collect(Collectors.groupingBy(coopInfo -> coopInfo.getLong("coopreltype.id")));
        HRBaseServiceHelper coopRelServiceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        HashSet<Long> coopRelTypeSet = new HashSet<Long>(coopInfoMap.keySet());
        coopRelTypeSet.add(1010L);
        QFilter filter = new QFilter("coopreltype", "in", coopRelTypeSet);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("org", "!=", (Object)boId);
        filter.and(FILTER_ENABLE);
        DynamicObject[] coopRelInfoMainArr = coopRelServiceHelper.queryOriginalArray("boid, coopreltype, org, cooporgteam", new QFilter[]{filter});
        Map<Long, List<DynamicObject>> coopRelTypeMapMain = Arrays.stream(coopRelInfoMainArr).collect(Collectors.groupingBy(coopInfo -> coopInfo.getLong("coopreltype")));
        for (Long coopRelTypeId : coopRelTypeSet) {
            List cycleList;
            CycleDetector cycleDetector;
            String message;
            DirectedGraph<Long> directedGraph = new DirectedGraph<Long>();
            List<DynamicObject> coopRelInfoMain = coopRelTypeMapMain.get(coopRelTypeId);
            if (CollectionUtils.isEmpty(coopRelInfoMain)) continue;
            coopRelInfoMain.forEach(coopInfo -> directedGraph.addEdge(coopInfo.getLong("org"), coopInfo.getLong("cooporgteam")));
            if (coopRelTypeId == 1010L) {
                directedGraph.addEdge(boId, parentOrgId);
                message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopRelCycleValidator_1", (String)"hrmp-haos-business", (Object[])new Object[0]), targetObject.getString("name"));
            } else {
                String coopRelTypeName = this.coopRelTypeIdNameMap.get(coopRelTypeId);
                List<DynamicObject> coopInfos = coopInfoMap.get(coopRelTypeId);
                coopInfos.forEach(coopInfo -> directedGraph.addEdge(boId, coopInfo.getLong("cooporgteam.id")));
                message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopRelCycleValidator_2", (String)"hrmp-haos-business", (Object[])new Object[0]), coopRelTypeName);
            }
            if (!(cycleDetector = new CycleDetector(directedGraph)).containsCycle() || !(cycleList = cycleDetector.getVerticesInCycles().stream().flatMap(Collection::stream).collect(Collectors.toList())).contains(boId)) continue;
            logger.info("ProjectGroupCoopRelCycleValidator cycle:" + JSON.toJSONString(cycleDetector.getVerticesInCycles()));
            result.add(new CalibratorBean(message, false));
        }
        return result;
    }
}

