/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.calibrator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;

public class ProjectGroupNameValidator
implements ProjectGroupValidService,
ProjectGroupMDConstants {
    @Override
    public List<CalibratorBean> valid(ProjectGroupValidContext context) {
        DynamicObject targetObject = context.getTargetObject();
        ILocaleString projectGroupName = targetObject.getLocaleString("name");
        long oneselfBoId = targetObject.getLong("boid");
        DynamicObject[] hisData = PRJOrgRepository.getInstance().queryProjectTeamWithSameAdOrg("fid,boid,name", targetObject.getLong("belongadminorg.id"), targetObject.getDate("bsed"));
        LocaleStringComparator localeStringComparator = new LocaleStringComparator();
        Optional<DynamicObject> sameNameOpt = Arrays.stream(hisData).filter(dy -> dy.getLong("boid") != oneselfBoId).filter(dy -> localeStringComparator.compareAnyMatch(projectGroupName, dy.getLocaleString("name"))).findAny();
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        sameNameOpt.ifPresent(hisDatum -> {
            String errorNumber = localeStringComparator.getErrorNumber();
            String message = String.format(ResManager.loadKDString((String)"%s\uff1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupNameValidator_1", (String)"hrmp-haos-business", (Object[])new Object[0]), projectGroupName.getItem(errorNumber));
            result.add(new CalibratorBean(message, false));
        });
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangList) {
            String number = enabledLang.getNumber();
            String projectGroupNameVal = (String)projectGroupName.get((Object)number);
            if (StringUtils.isEmpty((CharSequence)projectGroupNameVal) || !PatternUtil.valideName(projectGroupNameVal)) continue;
            String message = String.format(ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u56e2\u961f\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupNameValidator_2", (String)"hrmp-haos-business", (Object[])new Object[0]), projectGroupNameVal);
            result.add(new CalibratorBean(message, false));
            break;
        }
        return result;
    }
}

