/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.core;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidFactory;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;

public class ProjectGroupValidContext {
    private static final Log logger = LogFactory.getLog(ProjectGroupValidContext.class);
    private DynamicObject targetObject;
    private String changeType;
    private ProjectGroupValidFactory validFactory;

    public ProjectGroupValidContext(DynamicObject targetObject, String changeType) {
        this.targetObject = targetObject;
        this.changeType = changeType;
        this.validFactory = new ProjectGroupValidFactory(changeType);
    }

    public List<CalibratorBean> valid() {
        logger.info("ProjectGroupValidContext valid begin!");
        List<ProjectGroupValidService> calibratorList = this.validFactory.getDefaultCalibratorList();
        List<ProjectGroupValidService> customerCalibratorList = this.validFactory.getCustomerCalibratorList();
        calibratorList.addAll(customerCalibratorList);
        for (ProjectGroupValidService calibrator : calibratorList) {
            List<CalibratorBean> validResult = calibrator.valid(this);
            if (CollectionUtils.isEmpty(validResult)) continue;
            return validResult;
        }
        logger.info("ProjectGroupValidContext valid end!");
        return null;
    }

    public void registerCalibrator(ProjectGroupValidService projectGroupValidService) {
        if (projectGroupValidService != null) {
            this.validFactory.getCustomerCalibratorList().add(projectGroupValidService);
        }
    }

    public DynamicObject getTargetObject() {
        return this.targetObject;
    }

    public String getChangeType() {
        return this.changeType;
    }
}

