/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.MuldimUseStaffRepository;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.service.impl.staff.PersonChangeEventServiceImpl;
import kd.hr.haos.business.domain.service.staff.IPersonChangeEventService;
import kd.hr.haos.business.util.StaffActivityHelper;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffBillDataBO {
    private List<Long> personStaffIdList;
    private List<DynamicObject> effectOrgUseStaffDetailList;
    private List<DynamicObject> effectMuldimUseStaffList;
    private List<Long> effectChangeEventIdList;
    private List<DynamicObject> schedulEffectOrgUseStaffDetailList;
    private List<DynamicObject> schedulEffectMuldimUseStaffList;
    private List<Long> schedulEffectChangeEventIdList;
    private List<DynamicObject> schedulEffectPersonStaffList;
    private List<DynamicObject> hisOrgUseStaffDetailList;
    private List<DynamicObject> hisMuldimUseStaffList;
    private List<DynamicObject> hisPersonDimList;
    private Map<Long, String> orgUseStaffDetailIdToEventActNumberMap;
    private List<DynamicObject> oldOrgUseStaffDetailList;
    private Map<Long, Map<String, DynamicObject>> depEmpIdToReleasingDataMap;
    private List<DynamicObject> newOrgUseStaffDetailList;
    private Map<Long, DynamicObject> eventIdToEventMap;
    private List<DynamicObject> offerOrgUseStaffList;
    private List<DynamicObject> offerMuldimUseStaffList;
    private List<Long> offerEventIdList;
    private boolean isTcc;
    private boolean isAbort;
    private IPersonChangeEventService personChangeEventService = new PersonChangeEventServiceImpl();

    private void init(int size, boolean tcc, boolean isAbort) {
        this.personStaffIdList = Lists.newArrayListWithExpectedSize((int)size);
        this.effectOrgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)size);
        this.effectMuldimUseStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.effectChangeEventIdList = Lists.newArrayListWithExpectedSize((int)size);
        this.schedulEffectOrgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)size);
        this.schedulEffectMuldimUseStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.schedulEffectChangeEventIdList = Lists.newArrayListWithExpectedSize((int)size);
        this.schedulEffectPersonStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.hisOrgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)size);
        this.hisMuldimUseStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.hisPersonDimList = Lists.newArrayListWithExpectedSize((int)size);
        this.orgUseStaffDetailIdToEventActNumberMap = Maps.newHashMapWithExpectedSize((int)size);
        this.oldOrgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)size);
        this.depEmpIdToReleasingDataMap = Maps.newHashMapWithExpectedSize((int)size);
        this.newOrgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)size);
        this.eventIdToEventMap = Maps.newHashMapWithExpectedSize((int)size);
        this.offerOrgUseStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.offerMuldimUseStaffList = Lists.newArrayListWithExpectedSize((int)size);
        this.offerEventIdList = Lists.newArrayListWithExpectedSize((int)size);
        this.isTcc = tcc;
        this.isAbort = isAbort;
    }

    public StaffBillDataBO() {
    }

    public StaffBillDataBO(List<Long> billIdList, List<Long> depEmpIdList, boolean queryOld, boolean tcc, boolean isAbort) {
        this.init(billIdList.size(), tcc, isAbort);
        Map<Long, List<DynamicObject>> billToEventMap = this.getBillToEventMap(billIdList);
        HashSet<Long> distinctBillIdSet = new HashSet<Long>(billIdList);
        for (Long bizBillId : distinctBillIdSet) {
            List<DynamicObject> eventList = billToEventMap.get(bizBillId);
            if (CollectionUtils.isEmpty(eventList)) continue;
            for (DynamicObject event : eventList) {
                this.eventIdToEventMap.put(event.getLong("id"), event);
                DynamicObject staffPerson = event.getDynamicObject("staffperson");
                this.personStaffIdList.add(staffPerson.getLong("id"));
                if (HRStringUtils.equals((String)staffPerson.getString("status"), (String)"0")) {
                    this.schedulEffectPersonStaffList.add(staffPerson);
                }
                String changeEventNumber = event.getDynamicObject("changeevent").getString("number");
                DynamicObject orgUseStaffDetail = event.getDynamicObject("orgusestaffdetail");
                if (orgUseStaffDetail == null) continue;
                this.orgUseStaffDetailIdToEventActNumberMap.put(orgUseStaffDetail.getLong("id"), changeEventNumber);
                this.groupingOrgUseStaffDetail(orgUseStaffDetail, event);
                Long depEmpId = orgUseStaffDetail.getLong("orgperson_id");
                if (this.isEmptyOfLong(depEmpId)) continue;
                depEmpIdList.add(depEmpId);
            }
        }
        this.groupingMuldimUseStaff();
        if (queryOld) {
            this.getExistData(depEmpIdList);
        }
    }

    private void groupingOrgUseStaffDetail(DynamicObject orgUseStaffDetail, DynamicObject event) {
        String status = orgUseStaffDetail.getString("status");
        if (HRStringUtils.equals((String)status, (String)"1")) {
            this.effectOrgUseStaffDetailList.add(orgUseStaffDetail);
            this.effectChangeEventIdList.add(event.getLong("id"));
        } else if (HRStringUtils.equals((String)status, (String)"0")) {
            this.schedulEffectOrgUseStaffDetailList.add(orgUseStaffDetail);
            this.schedulEffectChangeEventIdList.add(event.getLong("id"));
        }
    }

    private void groupingMuldimUseStaff() {
        this.effectMuldimUseStaffList.addAll(this.getMuldimUseStaff(this.effectOrgUseStaffDetailList));
        this.schedulEffectMuldimUseStaffList.addAll(this.getMuldimUseStaff(this.schedulEffectOrgUseStaffDetailList));
    }

    private void getExistData(List<Long> depEmpIdList) {
        if (CollectionUtils.isEmpty(depEmpIdList)) {
            return;
        }
        this.oldOrgUseStaffDetailList = this.getOccupyData(depEmpIdList);
        this.depEmpIdToReleasingDataMap = this.personChangeEventService.getDepEmpIdToReleasingDataMap(depEmpIdList);
    }

    public void getOfferDataByStaffPersonId(List<Long> candidateIdList) {
        DynamicObject[] offerBillEvent;
        DynamicObject[] staffPersons = PersonStaffInfoRepository.getInstance().queryBaseInfoByPersonIdsOrCandidateId(Lists.newArrayList(), candidateIdList);
        List<Long> offerStaffPersonId = Arrays.stream(staffPersons).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject offerAct = StaffActivityHelper.getStaffActivityMap().get("1090_S");
        if (offerAct == null || CollectionUtils.isEmpty(offerStaffPersonId)) {
            return;
        }
        for (DynamicObject event : offerBillEvent = this.personChangeEventService.queryByBizStaffPersonAndChangeEventId(offerStaffPersonId, offerAct.getLong("id"))) {
            this.offerEventIdList.add(event.getLong("id"));
            DynamicObject orgUseStaffDetail = event.getDynamicObject("orgusestaffdetail");
            if (orgUseStaffDetail == null) continue;
            this.offerOrgUseStaffList.add(orgUseStaffDetail);
        }
        this.offerMuldimUseStaffList.addAll(this.getMuldimUseStaff(this.offerOrgUseStaffList));
    }

    public void getNeedUpdateOldData() {
        if (CollectionUtils.isEmpty(this.oldOrgUseStaffDetailList)) {
            return;
        }
        this.hisOrgUseStaffDetailList = this.getNeedUpdateUseStaffDetailData();
        this.hisMuldimUseStaffList = this.getMuldimUseStaff(this.hisOrgUseStaffDetailList);
        if (this.hisMuldimUseStaffList.size() > 0) {
            Map<Long, DynamicObject> orgUseStaffIdToDetailMap = this.hisOrgUseStaffDetailList.stream().collect(Collectors.toMap(detail -> detail.getLong("id"), detail -> detail));
            this.updateMuldimUseStaffOldData(this.hisMuldimUseStaffList, orgUseStaffIdToDetailMap);
        }
        this.hisPersonDimList = this.getPersonDim(this.hisOrgUseStaffDetailList);
        if (this.hisPersonDimList.size() > 0) {
            Map<Long, DynamicObject> depempIdToOrgUseStaffDetailMap = this.hisOrgUseStaffDetailList.stream().collect(Collectors.toMap(detail -> detail.getLong("orgperson_id"), detail -> detail, (v1, v2) -> v2));
            this.updatePersonDimOldData(this.hisPersonDimList, depempIdToOrgUseStaffDetailMap);
        }
    }

    public void getNeedUpdateOldData(List<DynamicObject> newOrgUseStaffDetailList, Map<Long, String> orgUseStaffDetailIdToEventActNumberMap) {
        this.newOrgUseStaffDetailList = newOrgUseStaffDetailList;
        this.orgUseStaffDetailIdToEventActNumberMap = orgUseStaffDetailIdToEventActNumberMap;
        this.getNeedUpdateOldData();
    }

    public List<DynamicObject> getOccupyData(List<Long> depEmpIdList) {
        DynamicObject[] orgUseStaffDetails = OrgUseStaffDetailRepository.getInstance().queryAllOrgUseStaffByPersonStaffInfoIds(depEmpIdList, new String[]{"1"});
        ArrayList orgUseStaffDetailList = Lists.newArrayListWithExpectedSize((int)orgUseStaffDetails.length);
        HashSet depEmpIdSet = Sets.newHashSetWithExpectedSize((int)orgUseStaffDetails.length);
        for (DynamicObject detail : orgUseStaffDetails) {
            Long depEmpId = detail.getLong("orgperson_id");
            if (!depEmpIdSet.add(depEmpId)) continue;
            orgUseStaffDetailList.add(detail);
        }
        return orgUseStaffDetailList;
    }

    public List<DynamicObject> getMuldimUseStaff(List<DynamicObject> orgUseStaffDetailList) {
        if (CollectionUtils.isEmpty(orgUseStaffDetailList)) {
            return new ArrayList<DynamicObject>();
        }
        List<Long> orgUseStaffDetailIdList = orgUseStaffDetailList.stream().map(orgUseStaffDetail -> orgUseStaffDetail.getLong("id")).collect(Collectors.toList());
        DynamicObject[] muldimUseStaffs = MuldimUseStaffRepository.getInstance().queryByOrgUseStaffDetailIds(orgUseStaffDetailIdList);
        return Arrays.asList(muldimUseStaffs);
    }

    public List<DynamicObject> getPersonDim(List<DynamicObject> orgUseStaffDetailList) {
        if (CollectionUtils.isEmpty(orgUseStaffDetailList)) {
            return new ArrayList<DynamicObject>();
        }
        List<Long> depEmpIdList = orgUseStaffDetailList.stream().filter(orgUseStaffDetail -> orgUseStaffDetail.getLong("orgperson_id") != 0L).map(orgUseStaffDetail -> orgUseStaffDetail.getLong("orgperson_id")).collect(Collectors.toList());
        DynamicObject[] personDim = OrgPersonStaffInfoRepository.getInstance().queryPersonStaffInfoByDepEmpIds(depEmpIdList);
        return Arrays.asList(personDim);
    }

    private List<DynamicObject> getNeedUpdateUseStaffDetailData() {
        HashMap keyFieldValueToNewLeffdtMap = Maps.newHashMapWithExpectedSize((int)this.oldOrgUseStaffDetailList.size());
        List<DynamicObject> billData = this.getData();
        for (DynamicObject data : billData) {
            DynamicObject quitData;
            Long depEmpId;
            String actNumber = this.orgUseStaffDetailIdToEventActNumberMap.get(data.getLong("id"));
            if (this.isQuitJobAndExistJobTransferBill(actNumber, depEmpId = Long.valueOf(data.getLong("orgperson_id")))) continue;
            if (this.isJobTransferAbort(actNumber) && (quitData = this.getQuitJobReleasingData(depEmpId)) != null) {
                Date effdt = quitData.getDate("effdt");
                Date leffdt = HRDateTimeUtils.addDay((Date)effdt, (long)-1L);
                keyFieldValueToNewLeffdtMap.put(depEmpId, leffdt);
                continue;
            }
            if (this.isAbort) {
                keyFieldValueToNewLeffdtMap.put(depEmpId, OrgDateTimeUtil.BSLED);
                continue;
            }
            Date effdt = HRDateTimeUtils.truncateDate((Date)data.getDate("effdt"));
            Date leffdt = HRDateTimeUtils.addDay((Date)effdt, (long)-1L);
            keyFieldValueToNewLeffdtMap.put(depEmpId, leffdt);
        }
        return this.resetOldDataEffdtAndStatus(keyFieldValueToNewLeffdtMap);
    }

    private DynamicObject getQuitJobReleasingData(Long depEmpId) {
        DynamicObject quitData = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1030_S");
        if (quitData == null) {
            quitData = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1040_S");
        }
        return quitData;
    }

    private boolean isJobTransferAbort(String actNumber) {
        return this.isAbort && HRStringUtils.equals((String)"1070_S", (String)actNumber);
    }

    private boolean isQuitJobAndExistJobTransferBill(String actNumber, Long depEmpId) {
        boolean isQuitJob = HRStringUtils.equals((String)"1030_S", (String)actNumber) || HRStringUtils.equals((String)"1040_S", (String)actNumber);
        boolean isExistJobTransferBill = ((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1070_S") != null;
        return isQuitJob && isExistJobTransferBill;
    }

    private List<DynamicObject> resetOldDataEffdtAndStatus(Map<Long, Date> keyFieldValueToNewLeffdtMap) {
        ArrayList handledOldData = Lists.newArrayListWithExpectedSize((int)this.oldOrgUseStaffDetailList.size());
        for (DynamicObject oldData : this.oldOrgUseStaffDetailList) {
            Long depEmpId = oldData.getLong("orgperson_id");
            Date leffdt = keyFieldValueToNewLeffdtMap.get(depEmpId);
            if (this.isAbort && leffdt == null) {
                leffdt = OrgDateTimeUtil.BSLED;
            } else if (leffdt == null) continue;
            oldData.set("leffdt", (Object)leffdt);
            if (HRDateTimeUtils.dayBefore((Date)leffdt, (Date)oldData.getDate("effdt"))) {
                oldData.set("status", (Object)"-1");
            } else if (HRDateTimeUtils.dayEquals((Date)leffdt, (Date)OrgDateTimeUtil.BSLED)) {
                oldData.set("status", (Object)"1");
            } else {
                oldData.set("status", (Object)"2");
            }
            handledOldData.add(oldData);
        }
        return handledOldData;
    }

    private List<DynamicObject> getData() {
        List<DynamicObject> billData = this.isTcc ? this.schedulEffectOrgUseStaffDetailList : this.effectOrgUseStaffDetailList;
        billData = CollectionUtils.isEmpty(this.newOrgUseStaffDetailList) ? billData : this.newOrgUseStaffDetailList;
        return billData;
    }

    private void updateMuldimUseStaffOldData(List<DynamicObject> muldimUseStaffList, Map<Long, DynamicObject> orgUseStaffIdToDetailMap) {
        for (DynamicObject muldimUseStaff : muldimUseStaffList) {
            Long orgUseStaffDetailId = muldimUseStaff.getLong("orgusestaffdetail.id");
            DynamicObject orgUseStaffDetail = orgUseStaffIdToDetailMap.get(orgUseStaffDetailId);
            muldimUseStaff.set("leffdt", (Object)orgUseStaffDetail.getDate("leffdt"));
            muldimUseStaff.set("status", (Object)orgUseStaffDetail.getString("status"));
        }
    }

    private void updatePersonDimOldData(List<DynamicObject> personDimList, Map<Long, DynamicObject> depempIdToOrgUseStaffDetailMap) {
        for (DynamicObject personDim : personDimList) {
            long depempId = personDim.getLong("orgperson_id");
            DynamicObject orgUseStaffDetail = depempIdToOrgUseStaffDetailMap.get(depempId);
            personDim.set("leffdt", (Object)orgUseStaffDetail.getDate("leffdt"));
            personDim.set("status", (Object)orgUseStaffDetail.getString("status"));
        }
    }

    private Map<Long, List<DynamicObject>> getBillToEventMap(List<Long> billIdList) {
        DynamicObject[] events = this.personChangeEventService.queryByBizBillIds(billIdList);
        HashMap billToEventMap = Maps.newHashMapWithExpectedSize((int)billIdList.size());
        for (DynamicObject event : events) {
            long bizBillId = event.getLong("perevent");
            List eventList = (List)billToEventMap.get(bizBillId);
            if (eventList == null) {
                eventList = Lists.newArrayListWithExpectedSize((int)8);
            }
            eventList.add(event);
            billToEventMap.put(bizBillId, eventList);
        }
        return billToEventMap;
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }

    public List<Long> getPersonStaffIdList() {
        return this.personStaffIdList;
    }

    public List<DynamicObject> getEffectOrgUseStaffDetailList() {
        return this.effectOrgUseStaffDetailList;
    }

    public List<DynamicObject> getEffectMuldimUseStaffList() {
        return this.effectMuldimUseStaffList;
    }

    public List<Long> getEffectChangeEventIdList() {
        return this.effectChangeEventIdList;
    }

    public List<DynamicObject> getSchedulEffectOrgUseStaffDetailList() {
        return this.schedulEffectOrgUseStaffDetailList;
    }

    public List<DynamicObject> getSchedulEffectMuldimUseStaffList() {
        return this.schedulEffectMuldimUseStaffList;
    }

    public List<Long> getSchedulEffectChangeEventIdList() {
        return this.schedulEffectChangeEventIdList;
    }

    public List<DynamicObject> getSchedulEffectPersonStaffList() {
        return this.schedulEffectPersonStaffList;
    }

    public List<DynamicObject> getHisOrgUseStaffDetailList() {
        return this.hisOrgUseStaffDetailList;
    }

    public List<DynamicObject> getHisMuldimUseStaffList() {
        return this.hisMuldimUseStaffList;
    }

    public List<DynamicObject> getHisPersonDimList() {
        return this.hisPersonDimList;
    }

    public Map<Long, DynamicObject> getEventIdToEventMap() {
        return this.eventIdToEventMap;
    }

    public Map<Long, Map<String, DynamicObject>> getDepEmpIdToReleasingDataMap() {
        return this.depEmpIdToReleasingDataMap;
    }

    public List<DynamicObject> getOfferOrgUseStaffList() {
        return this.offerOrgUseStaffList;
    }

    public List<DynamicObject> getOfferMuldimUseStaffList() {
        return this.offerMuldimUseStaffList;
    }

    public List<Long> getOfferEventIdList() {
        return this.offerEventIdList;
    }
}

