/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.service.staff.bean.MulDimDetailBo;

public class StaffContext {
    private final List<Long> personIdList;
    private static UseOrgDetailRepository useOrgDetailRepository = UseOrgDetailRepository.getInstance();
    private static MuldimDetailRepository muldimDetailRepository = MuldimDetailRepository.getInstance();
    private static PersonStaffInfoRepository personStaffInfoRepository = PersonStaffInfoRepository.getInstance();
    private final List<Long> useOrgBoidList;
    private List<Long> useOrgIdList = Lists.newArrayList();
    private Map<Long, Long> useOrgDetailMapping = Maps.newHashMap();
    private Map<Long, List<MulDimDetailBo>> mulDimMapping = Maps.newHashMap();
    private Map<Long, Long> useOrgBOMapping = Maps.newHashMap();
    private Map<Long, Long> mulDimBOMapping = Maps.newHashMap();
    private Map<Long, Long> personAndStaffPersonMapping = Maps.newHashMap();

    public StaffContext(List<Long> useOrgBoIdList, List<Long> personIdList) {
        this.useOrgBoidList = useOrgBoIdList;
        this.personIdList = personIdList;
    }

    public void init() {
        this.initUseOrgDetail();
        this.initMulDimDetail();
        this.initStaffPerson();
    }

    private void initStaffPerson() {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dy : dynamicObjects = personStaffInfoRepository.queryBaseInfoByPersonIds(this.personIdList)) {
            this.personAndStaffPersonMapping.put(dy.getLong("person_id"), dy.getLong("id"));
        }
    }

    private void initMulDimDetail() {
        DynamicObject[] dys = muldimDetailRepository.queryMuldimDetail(this.useOrgIdList);
        Map<Long, List<DynamicObject>> muldimMap = Stream.of(dys).collect(Collectors.groupingBy(it -> it.getLong("useorg.boid")));
        for (Map.Entry<Long, List<DynamicObject>> entry : muldimMap.entrySet()) {
            this.mulDimMapping.put(entry.getKey(), this.convertMulDimDetail(entry.getValue()));
        }
    }

    private void initUseOrgDetail() {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dy : dynamicObjects = useOrgDetailRepository.queryUseOrgDetail(this.useOrgBoidList)) {
            this.useOrgDetailMapping.putIfAbsent(dy.getLong("useorgbo"), dy.getLong("id"));
            this.useOrgIdList.add(dy.getLong("useorg_id"));
            this.useOrgBOMapping.putIfAbsent(dy.getLong("id"), dy.getLong("bo"));
        }
    }

    private List<MulDimDetailBo> convertMulDimDetail(List<DynamicObject> list) {
        ArrayList mulDimDetailBoList = Lists.newArrayListWithExpectedSize((int)list.size());
        for (DynamicObject dy : list) {
            MulDimDetailBo bo;
            MulDimDetailBo mulDimDetailBo = new MulDimDetailBo(dy);
            Long id = null;
            Iterator iterator = mulDimDetailBoList.iterator();
            while (iterator.hasNext() && Objects.isNull(id = mulDimDetailBo.mapping((bo = (MulDimDetailBo)iterator.next()).getMulMidControlDetailDy()))) {
            }
            if (!Objects.isNull(id)) continue;
            this.mulDimBOMapping.put(dy.getLong("id"), dy.getLong("bo"));
            mulDimDetailBoList.add(mulDimDetailBo);
        }
        return mulDimDetailBoList;
    }

    public Map<Long, Long> getUseOrgDetailMapping() {
        return this.useOrgDetailMapping;
    }

    public Map<Long, List<MulDimDetailBo>> getMulDimMapping() {
        return this.mulDimMapping;
    }

    public Map<Long, Long> getPersonAndStaffPersonMapping() {
        return this.personAndStaffPersonMapping;
    }

    public Map<Long, Long> getUseOrgBOMapping() {
        return this.useOrgBOMapping;
    }

    public Map<Long, Long> getMulDimBOMapping() {
        return this.mulDimBOMapping;
    }
}

