/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import java.time.LocalDate;
import kd.bos.orm.query.QFilter;

public enum StaffCycleEnum {
    YEAR(1020L){

        @Override
        protected int getTodayValue() {
            return LocalDate.now().getYear();
        }

        @Override
        protected QFilter getAdminOrgFilter(int value) {
            return new QFilter("yearstaff", "!=", null);
        }

        @Override
        protected String getSelectFields(int value) {
            return "yearstaff";
        }
    }
    ,
    MONTH(1010L){

        @Override
        protected int getTodayValue() {
            return LocalDate.now().getMonth().getValue();
        }

        @Override
        protected QFilter getAdminOrgFilter(int value) {
            return new QFilter("monthstaff" + value, "!=", null);
        }

        @Override
        protected String getSelectFields(int value) {
            return "monthstaff" + value;
        }
    };

    long id;
    private static final String STAFF_CYCLE_ENUM_NO_SUPPORT = "StaffCycleEnum no support";

    public static StaffCycleEnum getInstance(long id) {
        if (id == 1010L) {
            return MONTH;
        }
        if (id == 1020L) {
            return YEAR;
        }
        throw new RuntimeException(STAFF_CYCLE_ENUM_NO_SUPPORT);
    }

    private StaffCycleEnum(long id) {
        this.id = id;
    }

    protected int getTodayValue() {
        throw new RuntimeException(STAFF_CYCLE_ENUM_NO_SUPPORT);
    }

    protected QFilter getAdminOrgFilter(int value) {
        throw new RuntimeException(STAFF_CYCLE_ENUM_NO_SUPPORT);
    }

    protected String getSelectFields(int value) {
        throw new RuntimeException(STAFF_CYCLE_ENUM_NO_SUPPORT);
    }
}

