/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffIncludeSubCountContext
implements OrgStaffConstants {
    private static final Log LOG = LogFactory.getLog(StaffIncludeSubCountContext.class);
    private static AdOrgRepository adminOrgRepository = AdOrgRepository.getInstance();
    private static AdminOrgStructRepository adminOrgStructRepository = AdminOrgStructRepository.getInstance();
    private static UseOrgDetailRepository useOrgDetailRepository = UseOrgDetailRepository.getInstance();
    private static DutyOrgDetailRepository dutyOrgDetailRepository = DutyOrgDetailRepository.getInstance();
    private Map<Long, Long> useOrgBoIdVsParentOrgIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, String> adminOrgBoIdVsLongStructNumberMap = Maps.newHashMapWithExpectedSize((int)16);
    private List<Long> curAndSubAdminOrgBoIdList = Lists.newArrayListWithExpectedSize((int)16);
    private Map<Long, Integer> useOrgBoIdVsStaffCountMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Long> useOrgBoIdVsUseOrgMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Long> useOrgBoIdVsDutyOrgMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Integer> dutyOrgIdVsIncludeSubCountMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> systemParamMap = Maps.newHashMapWithExpectedSize((int)16);
    private Integer month;
    Map<Long, Function<DynamicObject, Integer>> commonFunctionMap = Maps.newHashMapWithExpectedSize((int)16);

    public StaffIncludeSubCountContext(Date queryDate, List<Long> adminOrgIds) {
        this.commonFunctionMap.put(STAFF_CYCLE_MONTH, this::getMonthStaffCount);
        this.commonFunctionMap.put(STAFF_CYCLE_YEAR, this::getYearStaffCount);
        this.month = HRDateTimeUtils.getMonth((Date)queryDate);
        QFilter idFilter = new QFilter("id", "in", adminOrgIds);
        DynamicObject[] adminOrgDynArr = adminOrgRepository.queryOriginalArray("id, boid, structnumber", new QFilter[]{idFilter});
        Set structNumberSet = Arrays.stream(adminOrgDynArr).map(dyn -> dyn.getString("structnumber")).collect(Collectors.toSet());
        DynamicObject[] adminOrgStructDynArr = adminOrgStructRepository.queryOriginStructInfoLikeStructNum("id, adminorg, structlongnumber, parentorg", new ArrayList<String>(structNumberSet));
        this.adminOrgBoIdVsLongStructNumberMap = Arrays.stream(adminOrgStructDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg"), dyn -> dyn.getString("structlongnumber")));
        this.useOrgBoIdVsParentOrgIdMap = Arrays.stream(adminOrgStructDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg"), dyn -> dyn.getLong("parentorg")));
        this.curAndSubAdminOrgBoIdList = Arrays.stream(adminOrgStructDynArr).map(dyn -> dyn.getLong("adminorg")).collect(Collectors.toList());
        DynamicObject[] useOrgDynArr = useOrgDetailRepository.queryOriginalUseOrgStaff(this.curAndSubAdminOrgBoIdList, queryDate);
        List<Long> orgIdList = Arrays.stream(useOrgDynArr).filter(dyn -> !this.longIsNullOrZero(dyn.getLong("staff.org"))).map(dyn -> dyn.getLong("staff.org")).collect(Collectors.toList());
        Map<String, Map<String, Object>> systemParamAll = StaffCommonService.batchLoadSystemParam(orgIdList);
        LOG.info("StaffIncludeSubCountContext.systemParamAll:{}", (Object)JSON.toJSONString(systemParamAll, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter}));
        this.systemParamMap = Maps.newHashMapWithExpectedSize((int)systemParamAll.size());
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = systemParamAll.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != null) continue;
            iterator.remove();
        }
        systemParamAll.forEach((orgId, paramKeyAndValueAll) -> paramKeyAndValueAll.forEach((paramKey, paramValue) -> {
            if (paramKey.equals("elasticcountgroup")) {
                Map paramKeyAndValue = this.systemParamMap.getOrDefault(orgId, new HashMap());
                paramKeyAndValue.put(paramKey, paramValue);
                this.systemParamMap.put((String)orgId, paramKeyAndValue);
            }
        }));
        LOG.info("StaffIncludeSubCountContext.systemParamMap:{}", (Object)JSON.toJSONString(this.systemParamMap));
        for (DynamicObject useOrgDyn : useOrgDynArr) {
            long staffCycle = useOrgDyn.getLong("staff.staffcycle");
            this.useOrgBoIdVsStaffCountMap.put(useOrgDyn.getLong("useorgbo"), this.commonFunctionMap.get(staffCycle).apply(useOrgDyn));
        }
        this.useOrgBoIdVsDutyOrgMap = Arrays.stream(useOrgDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo"), dyn -> dyn.getLong("dutyorg")));
        this.useOrgBoIdVsUseOrgMap = Arrays.stream(useOrgDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo"), dyn -> dyn.getLong("useorg")));
        List<Long> dutyOrgIdList = Arrays.stream(useOrgDynArr).filter(dyn -> !this.longIsNullOrZero(dyn.getLong("dutyorg"))).map(dyn -> dyn.getLong("dutyorg")).collect(Collectors.toList());
        DynamicObject[] dutyDynArr = dutyOrgDetailRepository.queryIncludeSubStaffByOrgId(dutyOrgIdList, queryDate);
        this.dutyOrgIdVsIncludeSubCountMap = Arrays.stream(dutyDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("dutyorg"), dyn -> {
            Integer includeCount = dyn.getInt("staffcount");
            return this.getAfterSpringResult((DynamicObject)dyn, includeCount);
        }));
    }

    private boolean longIsNullOrZero(Long aLong) {
        return aLong == null || aLong == 0L;
    }

    private Integer getMonthStaffCount(DynamicObject useOrgDyn) {
        DynamicProperty monthStaffProp = useOrgDyn.getDynamicObjectType().getProperty("monthstaff" + this.month);
        Object monthStaffValue = useOrgDyn.getDataStorage().getLocalValue((IDataEntityProperty)monthStaffProp);
        return this.getAfterSpringResult(useOrgDyn, monthStaffValue);
    }

    private Integer getYearStaffCount(DynamicObject useOrgDyn) {
        DynamicProperty yearStaffProp = useOrgDyn.getDynamicObjectType().getProperty("yearstaff");
        Object yearStaffValue = useOrgDyn.getDataStorage().getLocalValue((IDataEntityProperty)yearStaffProp);
        return this.getAfterSpringResult(useOrgDyn, yearStaffValue);
    }

    private Integer getAfterSpringResult(DynamicObject useOrgDyn, Object result) {
        if (Objects.isNull(result)) {
            return null;
        }
        String controlStrategy = useOrgDyn.getString("controlstrategy");
        if (HRStringUtils.equals((String)controlStrategy, (String)"3")) {
            long orgId = useOrgDyn.getLong("staff.org");
            String elasticControl = useOrgDyn.getString("elasticcontrol");
            Integer elasticCount = useOrgDyn.getInt("elasticcount");
            String roundType = ((Map)this.systemParamMap.getOrDefault(String.valueOf(orgId), new HashMap())).getOrDefault("elasticcountgroup", "1");
            return StaffCommonService.elasticValueCalc(roundType, elasticControl, elasticCount, (Integer)result);
        }
        return (Integer)result;
    }

    public Map<Long, Long> getUseOrgBoIdVsParentOrgIdMap() {
        return this.useOrgBoIdVsParentOrgIdMap;
    }

    public Map<Long, String> getAdminOrgBoIdVsLongStructNumberMap() {
        return this.adminOrgBoIdVsLongStructNumberMap;
    }

    public List<Long> getCurAndSubAdminOrgBoIdList() {
        return this.curAndSubAdminOrgBoIdList;
    }

    public Map<Long, Integer> getUseOrgBoIdVsStaffCountMap() {
        return this.useOrgBoIdVsStaffCountMap;
    }

    public Map<Long, Long> getUseOrgBoIdVsUseOrgMap() {
        return this.useOrgBoIdVsUseOrgMap;
    }

    public Map<Long, Long> getUseOrgBoIdVsDutyOrgMap() {
        return this.useOrgBoIdVsDutyOrgMap;
    }

    public Map<Long, Integer> getDutyOrgIdVsIncludeSubCountMap() {
        return this.dutyOrgIdVsIncludeSubCountMap;
    }

    public Integer getMonth() {
        return this.month;
    }
}

