/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.service.staff.helper.AbStractStaffEntryImport;
import kd.hr.haos.business.service.staff.helper.StaffEntryImportHelper;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MultiEntryImportStrategy
extends AbStractStaffEntryImport {
    Map<String, Map<String, Object>>[] keyVsPropValueMapArray = new Map[2];
    Map<Long, Long> adminOrgIdVsBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<String, Map<String, Map<String, List<String>>>> prefixVsImportTypeVsValueList = Maps.newHashMapWithExpectedSize((int)16);
    Map<String, List<String>> hasPermJobValueListMap = Maps.newHashMapWithExpectedSize((int)16);
    List<String> groupNumberList = Lists.newArrayListWithExpectedSize((int)16);
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    public MultiEntryImportStrategy() {
    }

    public MultiEntryImportStrategy(Map<String, List<ImportEntryData>> source, IFormView formView, BeforeImportEntryEventArgs event) {
        super(event, source, formView);
    }

    @Override
    public void init() {
        super.init();
        DynamicObjectCollection useOrgEntryEntityCol = this.formView.getModel().getEntryEntity("bentryentity");
        List<Long> useOrgBoIdList = useOrgEntryEntityCol.stream().map(entryEntity -> entryEntity.getLong("buseorg.boid")).collect(Collectors.toList());
        StaffEntryImportHelper staffEntryImportHelper = new StaffEntryImportHelper(this.source, this.formView.getModel());
        List<Long> orgIdList = Collections.singletonList(this.formView.getModel().getDataEntity().getLong("org.id"));
        this.keyVsPropValueMapArray = staffEntryImportHelper.buildMultiVsPropValueMap(orgIdList, useOrgBoIdList);
        List<String> multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (DynamicObject useOrgEntryEntity : useOrgEntryEntityCol) {
            String useOrgNumber = useOrgEntryEntity.getString("buseorg.number");
            for (String multiPrefix : multiPrefixList) {
                DynamicObjectCollection multiEntryCol = useOrgEntryEntity.getDynamicObjectCollection(multiPrefix + "entryentity");
                for (DynamicObject multiEntry : multiEntryCol) {
                    String keyFieldNumber = multiEntry.getString(multiPrefix + StaffEntryTempHelperEnum.getKeyFieldByPrefix(multiPrefix) + ".number");
                    this.groupNumberList.add(useOrgNumber + keyFieldNumber.replaceAll("POS_", ""));
                }
            }
        }
        this.prefixVsImportTypeVsValueList = staffEntryImportHelper.getMultiNumberAndNameList(useOrgBoIdList);
        long orgId = this.formView.getModel().getDataEntity().getLong("org.id");
        this.hasPermJobValueListMap = staffEntryImportHelper.getHasPermJobInfo(Collections.singletonList(orgId));
        for (DynamicObject useOrgEntryEntity : useOrgEntryEntityCol) {
            long useOrgId = useOrgEntryEntity.getLong("buseorg.id");
            long useOrgBoId = useOrgEntryEntity.getLong("buseorg.boid");
            this.adminOrgIdVsBoIdMap.put(useOrgId, useOrgBoId);
        }
    }

    @Override
    public void validAndTreatExcelDisplay() {
        super.validAndTreatExcelDisplay();
    }

    @Override
    protected Map<Integer, String> validate(List<ImportEntryData> entryEntityImportDataList) {
        HashMap indexVsMsgMap = Maps.newHashMapWithExpectedSize((int)entryEntityImportDataList.size());
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        boolean unityControlMode = dataEntity.getBoolean("staffproject.unitycontrolmode");
        List useOrgNotNullDataList = entryEntityImportDataList.stream().filter(data -> Objects.nonNull(data.getData().getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")))).collect(Collectors.toList());
        List keyFieldNotNullDataList = entryEntityImportDataList.stream().filter(data -> Objects.nonNull(data.getData().getJSONObject(this.entryKeyField))).collect(Collectors.toList());
        String useOrgImportProp = "";
        String keyFieldImportProp = "";
        Map<Object, Object> useOrgVsKeyFieldListMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(useOrgNotNullDataList) && !CollectionUtils.isEmpty(keyFieldNotNullDataList)) {
            useOrgImportProp = ((ImportEntryData)useOrgNotNullDataList.get(0)).getData().getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")).getString("importprop");
            keyFieldImportProp = entryEntityImportDataList.get(0).getData().getJSONObject(this.entryKeyField).getString("importprop");
            String finalUseOrgImportProp = useOrgImportProp;
            String finalKeyFieldImportProp = keyFieldImportProp;
            useOrgVsKeyFieldListMap = entryEntityImportDataList.stream().filter(importEntryData -> Objects.nonNull(importEntryData.getData().getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")))).filter(importEntryData -> Objects.nonNull(importEntryData.getData().getJSONObject(this.entryKeyField))).collect(Collectors.groupingBy(importEntryData -> importEntryData.getData().getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")).getString(finalUseOrgImportProp), Collectors.mapping(importData -> importData.getData().getJSONObject(this.entryKeyField).getString(finalKeyFieldImportProp), Collectors.toList())));
        }
        for (ImportEntryData importEntryData2 : entryEntityImportDataList) {
            List keyFieldList;
            StringBuilder errorMsg = new StringBuilder();
            JSONObject data2 = importEntryData2.getData();
            Integer rowNum = data2.getInteger("rowNum");
            if (!this.requiredFieldValidate(importEntryData2, errorMsg).booleanValue()) {
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            String useOrgNumber = data2.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")).getString("number");
            if (!this.useOrgNumberList.contains(useOrgNumber)) {
                errorMsg.append(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539;", (String)"MultiEntryImportStrategy_00", (String)"hrmp-haos-business", (Object[])new Object[0]));
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            String importPropValue = data2.getJSONObject(this.entryKeyField).getString(keyFieldImportProp);
            if (Arrays.asList("c", "d", "e").contains(this.prefix)) {
                Map importTypeVsValueListMap = this.prefixVsImportTypeVsValueList.getOrDefault(this.prefix, new HashMap());
                Map valueListMap = importTypeVsValueListMap.getOrDefault(keyFieldImportProp, new HashMap());
                List allValueList = valueListMap.getOrDefault("allInfo", new ArrayList());
                String keyFieldLocale = this.staffExtEntryHelper.getKeyFieldLocaleByPrefix(this.prefix);
                if (allValueList.contains(importPropValue)) {
                    List<String> hasPermValueList = this.hasPermJobValueListMap.get(keyFieldImportProp);
                    if (HRStringUtils.equals((String)"d", (String)this.prefix) && !hasPermValueList.contains(importPropValue)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165;", (String)"MultiEntryImportStrategy_01", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
                        indexVsMsgMap.put(rowNum, errorMsg.toString());
                        continue;
                    }
                    String groupKey = useOrgNumber + importPropValue;
                    if (HRStringUtils.equals((String)"c", (String)this.prefix) && !this.groupNumberList.contains(groupKey)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"MultiEntryImportStrategy_03", (String)"hrmp-haos-business", (Object[])new Object[0]), keyFieldLocale));
                        indexVsMsgMap.put(rowNum, errorMsg.toString());
                        continue;
                    }
                    List enableValueList = (List)valueListMap.get("enableInfo");
                    if (!HRStringUtils.equals((String)"c", (String)this.prefix) && !enableValueList.contains(importPropValue)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\uff1b", (String)"MultiEntryImportStrategy_02", (String)"hrmp-haos-business", (Object[])new Object[0]), keyFieldLocale));
                        indexVsMsgMap.put(rowNum, errorMsg.toString());
                        continue;
                    }
                } else {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"MultiEntryImportStrategy_03", (String)"hrmp-haos-business", (Object[])new Object[0]), keyFieldLocale));
                    indexVsMsgMap.put(rowNum, errorMsg.toString());
                    continue;
                }
            }
            if ((keyFieldList = (List)useOrgVsKeyFieldListMap.get(useOrgNumber)).contains(importPropValue) && this.isRepeat(keyFieldList, importPropValue)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u4f7f\u7528\u7ec4\u7ec7\u4e0b\u5b58\u5728\u4e24\u884c\u76f8\u540c\u7684\u6570\u636e[%s]\uff0c\u8bf7\u4fee\u6539;", (String)"MultiEntryImportStrategy_04", (String)"hrmp-haos-business", (Object[])new Object[0]), importPropValue));
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            this.intValidator(errorMsg, data2);
            if (HRStringUtils.isNotEmpty((String)errorMsg.toString())) {
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            boolean existEnableOrDisableDyn = StaffRepository.getInstance().isExistEnableOrDisableDynById(dataEntity.getLong("id"));
            long orgId = dataEntity.getLong("org.id");
            Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter(orgId);
            if (!enableModify.booleanValue() && existEnableOrDisableDyn) {
                this.validatePastYearAndMonth(dataEntity, errorMsg, data2);
            }
            this.unityControlModeValidate(unityControlMode, errorMsg, data2);
            this.notStringControlValidate(errorMsg, data2);
            if (!HRStringUtils.isNotEmpty((String)errorMsg.toString())) continue;
            indexVsMsgMap.put(rowNum, errorMsg.toString());
        }
        return indexVsMsgMap;
    }

    private boolean isRepeat(List<String> keyFieldList, String importPropValue) {
        int count = 0;
        for (String keyField : keyFieldList) {
            if (!HRStringUtils.equals((String)keyField, (String)importPropValue) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assembleImportPropValue() {
        super.assembleImportPropValue();
        Set entries = this.source.entrySet();
        for (Map.Entry entry : entries) {
            super.initFieldName((String)entry.getKey());
            List entryEntityImportDataList = (List)entry.getValue();
            this.entryNumberTransId(entryEntityImportDataList);
        }
    }

    private void entryNumberTransId(List<ImportEntryData> entryEntityImportDataList) {
        if (entryEntityImportDataList == null) {
            return;
        }
        for (ImportEntryData importEntryData : entryEntityImportDataList) {
            Map<String, Object> keyImportPropMap;
            String entryUseOrg;
            JSONObject data = importEntryData.getData();
            JSONObject useOrgJsonObjectForMul = data.getJSONObject(entryUseOrg = StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg"));
            if (Objects.isNull(useOrgJsonObjectForMul)) continue;
            Long orgId = useOrgJsonObjectForMul.getLong("id");
            Long adminOrgBoId = this.adminOrgIdVsBoIdMap.get(orgId);
            JSONObject keyFieldJsonObject = data.getJSONObject(this.entryKeyField);
            if (Objects.isNull(keyFieldJsonObject)) continue;
            String importProp = keyFieldJsonObject.getString("importprop");
            String importPropValue = keyFieldJsonObject.getString(importProp);
            String orgBoIdPrefixKeyField = HRStringUtils.equals((String)this.prefix, (String)"c") ? adminOrgBoId + this.prefix + importPropValue : this.prefix + importPropValue;
            Map<String, Map<String, Object>> keyVsPropValueMap = HRStringUtils.equals((String)importProp, (String)"number") ? this.keyVsPropValueMapArray[0] : this.keyVsPropValueMapArray[1];
            if (keyVsPropValueMap == null || (keyImportPropMap = keyVsPropValueMap.get(orgBoIdPrefixKeyField)) == null) continue;
            data.put(this.entryKeyField, keyImportPropMap);
        }
    }

    @Override
    protected Boolean requiredFieldValidate(ImportEntryData importEntryData, StringBuilder errorMsg) {
        StringBuilder emptyField = new StringBuilder();
        JSONObject data = importEntryData.getData();
        if (Objects.isNull(data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")))) {
            emptyField.append(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u3001", (String)"MultiEntryImportStrategy_05", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        if (!HRStringUtils.equals((String)"b", (String)this.prefix) && Objects.isNull(data.getJSONObject(this.entryKeyField))) {
            emptyField.append(this.staffExtEntryHelper.getKeyFieldLocaleByPrefix(this.prefix));
            emptyField.append("\u3001");
        }
        if (HRStringUtils.isNotEmpty((String)emptyField.toString())) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"MultiEntryImportStrategy_06", (String)"hrmp-haos-business", (Object[])new Object[0]), emptyField.toString().substring(0, emptyField.toString().length() - 1)));
        }
        return HRStringUtils.isEmpty((String)errorMsg.toString());
    }
}

